//////////////////////////////////////////////////////////////////
// UTFrontEnd: Elite Machines Menu
// Special Credits: Warlord57 & CustomizeUT
// Author: *PingFre@K* & Warlord57
// Wrote for Elite Machines By: *PingFre@K*
//////////////////////////////////////////////////////////////////

class UIFrontEnd_EM_Menu extends UTUIFrontEnd
	dependson(MutEM_XX);

/** Replacement info. */
var transient array<ReplacementInfo> WeaponsToReplace;
var transient array<ReplacementInfo> AmmoToReplace;

/** Reference to option list. */
var transient UTUIOptionList		OptionList;

/** Reference ot the options datastore. */
var transient UTUIDataStore_Options OptionsDataStore;

/** Reference to the string list datastore. */
var transient UTUIDataStore_StringList StringListDataStore;

/** Reference to the menu item datastore. */
var transient UTUIDataStore_MenuItems MenuItemDataStore;

/** List of possible weapon classes. */
var transient array<string>	WeaponClassNames;
var transient array<string>	WeaponFriendlyNames;
var transient array<UTUIDataProvider_Weapon> WeaponProviders;

// GUI Frame Boxes //
var transient UTSimpleList MyWeaponList;
var transient UIFrameBox frameWeapon[13];
var transient UIFrameBox frameMutators;
//var transient UIFrameBox frameReplacement;

// Allows for changing the Title //
var class<MutEM_XX> MutatorClass;

// Mutators //
struct NewContent
{
   var transient UTUICollectionCheckBox bStartIn3rdPerson;
	var transient UTUICollectionCheckBox bHitSounds;
	var transient UTUICollectionCheckBox bShowDMG;
	var transient UTUICollectionCheckBox bHeadshotSounds;
	var transient UTUICollectionCheckBox bHeadshotMessage;
	var transient UTUICollectionCheckBox bVampirism;
	var transient UTUICollectionCheckBox bNoSelfDamage;
	var transient UTUISlider VampHealth;
   var transient UTUICollectionCheckBox bInventoryDrop;
   var transient UTUICollectionCheckBox bDodgeJumping;
   var transient UTUICollectionCheckBox bHeater;
   var transient UTUISlider Heater;
   var transient UTUISlider HeaterSeconds;
   var transient UTUISlider HeaterHealthLimit;
   var transient UTUICollectionCheckBox bCooler;
   var transient UTUISlider Cooler;
   var transient UTUISlider CoolerSeconds;
   var transient UTUISlider CoolerHealthLimit;
   var transient UTUISlider MaxNumJumps;
   var transient UTUISlider MaxJumpBoost;
   var transient UTUISlider jumpZ;
   var transient UTUISlider DodgeSpeed;
   var transient UTUISlider DodgeSpeedZ;
   var transient UTUISlider GroundSpeed;
   var transient UINumericEditBox AirControl;
   var transient UTUISlider MaxAirDodges;
   var transient UTUISlider MaxHoverTime;
   var transient UTUISlider CrouchJumpBoost;
};
var NewContent Config_Content;

// BIO Rifle //
struct BioRifle
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UTUISlider Damage;
	var transient UTUISlider Momentum;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider HelpRadius;
	var transient UTUISlider AimError;
	var transient UTUISlider ShotCost;
	var transient UTUISlider Speed;
	var transient UTUISlider MaxResting;
	var transient UTUISlider GlobStrength;
	var transient UTUISlider GloblingSpeed;
	var transient UTUISlider DamageRadius;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox PriFireInterval;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox DripTime;
	var transient UTUISlider BioRecoil;
	var transient UINumericEditBox SecFireInterval;
   var transient UTUISlider SecSpeed;
   var transient UTUISlider SecDamage;
   var transient UTUISlider SecDamageRadius;
};
var BioRifle Config_Bio_Rifle;

// Enforcer //
struct Enforcer
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UINumericEditBox PriFireInterval;
	var transient UINumericEditBox SecFireInterval;
	var transient UINumericEditBox PriSpread;
	var transient UINumericEditBox SecSpread;
	var transient UTUISlider PriDamage;
	var transient UTUISlider SecDamage;
	var transient UTUISlider Momentum;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider EnforcerRecoil;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider ShotCost;
	var transient UTUISlider HelpRadius;
	var transient UTUISlider AimError;
	var transient UINumericEditBox VehicleMomentumScaling;
   var transient UTUISlider BurstMax;
	var transient UINumericEditBox AkimboTime;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox BurstCoolDownTime;
};
var Enforcer Config_Enforcer;

// Flak Cannon //
struct FlakCannon
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
   var transient UINumericEditBox AIRating;
	var transient UINumericEditBox PriFireRate;
	var transient UINumericEditBox SecFireRate;
	var transient UINumericEditBox Spread;
	var transient UINumericEditBox MaxBonusTime;
	var transient UINumericEditBox CustomGravityScaling;
   var transient UINumericEditBox DamageOverlayTime;
   var transient UINumericEditBox NodeDamageScaling;
   var transient UINumericEditBox VehicleDamageScaling;
   var transient UINumericEditBox VehicleMomentumScaling;
   var transient UTUISlider FlakRecoil;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider ShotCost;
	var transient UTUISlider speed;
	var transient UTUISlider Damage;
	var transient UTUISlider DamageRadius;
	var transient UTUISlider Momentum;
	var transient UTUISlider ShardBounces;
   var transient UTUISlider CenteredDamageBonus;
	var transient UTUISlider MainBounces;
	var transient UTUISlider SecDamageRadius;
	var transient UTUISlider SecDamage;
	var transient UTUISlider Secspeed;
	var transient UTUISlider TossZ;
};
var FlakCannon Config_FlakCannon;

// Impact Hammer //
struct ImpactHammer
{
	var transient UTUICollectionCheckBox bUseHammer;
	var transient UTUISlider MinDmg;
	var transient UTUISlider MaxDmg;
	var transient UTUISlider MinForce;
	var transient UTUISlider MaxForce;
	var transient UTUISlider MinSelfDmg;
	var transient UTUISlider EMPDmg;
	var transient UTUISlider SelfDmgScale;
	var transient UTUISlider SelfForceScale;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox MaxChargeTime;
	var transient UINumericEditBox MinChargeTime;
};
var ImpactHammer Config_ImpactHammer;

// Link Gun //
struct LinkGun
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox LinkFlexibility;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox PriFireInterval;
	var transient UTUISlider PriDamage;
   var transient UTUISlider ProJSpeed;
	var transient UTUISlider SecDamage;
	var transient UTUISlider Momentum;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider DamageRadius;
	var transient UTUISlider BeamAmmoSec;
	var transient UTUISlider WeaponLinkDistance;
   var transient UTUISlider ShotCost;
   var transient UTUISlider BeamRange;
	var transient UTUISlider LucyRecoil;
};
var LinkGun Config_LinkGun;

// Rocket Launcher //
struct RocketLauncher
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UINumericEditBox PriFireInterval;
	var transient UINumericEditBox SecFireInterval;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox LockAcquireTime;
	var transient UTUISlider Damage;
	var transient UTUISlider Momentum;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider HelpRadius;
	var transient UTUISlider AimError;
	var transient UTUISlider ShotCost;
	var transient UTUISlider Speed;
	var transient UTUISlider GrenadeSpeed;
	var transient UTUISlider DamageRadius;
	var transient UTUISlider spreaddist;
	var transient UTUISlider grenadespreaddist;
	var transient UTUISlider LockRange;
   var transient UTUISlider FlockRadius;
   var transient UTUISlider RocketRecoil;
   var transient UTUISlider FlockStiffness;
   var transient UTUISlider FlockCurlForce;
};
var RocketLauncher Config_RL_BFG;

// Shock Rifle //
struct ShockRifle
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
//   var transient UTUICollectionCheckBox bUseCombo;
	var transient UINumericEditBox FireInterval;
	var transient UINumericEditBox SecFireInterval;
	var transient UTUISlider Damage;
//	var transient UTUISlider ComboDamage;
	var transient UTUISlider InstaDamage;
	var transient UTUISlider Momentum;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider InstaRecoil;
	var transient UINumericEditBox SlowHeadshotScale;
	var transient UINumericEditBox RunningHeadshotScale;
	var transient UINumericEditBox HeadShotDmgMult;
//	var transient UTUISlider PriHelpRadius;
//	var transient UTUISlider AimError;
	var transient UTUISlider ShotCost;
	var transient UTUISlider ComboAmmoCost;
	var transient UTUISlider Speed;
	var transient UTUISlider DamageRadius;
//	var transient UTUISlider ComboDamageRadius;
	var transient UTUISlider DamageImpulse;
	var transient UTUISlider ImpulseRadius;
   var transient UTUISlider VortexRadius;
   var transient UTUISlider VortexForcePerSecond;
   var transient UINumericEditBox VortexDuration;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
};
var ShockRifle Config_Shock_Rifle;

// Sniper Rifle //
struct SniperRifle
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UINumericEditBox FireInterval;
	var transient UTUISlider Damage;
	var transient UTUISlider Momentum;
	var transient UINumericEditBox HeadShotDmgMult;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider ZoomFOV;
	var transient UTUISlider ZoomRate;
	var transient UTUISlider PriHelpRadius;
	var transient UTUISlider AimError;
	var transient UTUISlider ShotCost;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox SlowHeadshotScale;
	var transient UINumericEditBox RunningHeadshotScale;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UTUISlider SniperRecoil;
};
var SniperRifle Config_Sniper_Rifle;

// Stinger //
struct Stinger
{
   var transient UTUICollectionCheckBox bAmmoRegeneration;
   var transient UTUICollectionCheckBox bDoubles;
	var transient UINumericEditBox PriFireInterval;
	var transient UINumericEditBox SecFireInterval;
	var transient UINumericEditBox PriSpread;
	var transient UINumericEditBox SecSpread;
	var transient UINumericEditBox AIRating;
	var transient UTUISlider ShotCost;
	var transient UTUISlider AimingHelpRadius;
	var transient UTUISlider AimError;
	var transient UTUISlider StingerRecoil;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UINumericEditBox DamageOverlayTime;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmoCount;
	var transient UTUISlider Speed;
	var transient UTUISlider Damage;
	var transient UTUISlider DamageRadius;
	var transient UTUISlider MomentumTransfer;
	var transient UTUISlider SecSpeed;
	var transient UTUISlider SecDamage;
	var transient UTUISlider SecDamageRadius;
	var transient UTUISlider SecBounces;
};
var Stinger Config_Stinger;

// Goliath Cannon //
struct GoliathCannon
{
	var transient UINumericEditBox FireInterval;
	var transient UTUISlider ZoomFOV;
	var transient UTUISlider ZoomRate;
	var transient UTUISlider Damage;
	var transient UTUISlider DmgRadius;
	var transient UTUISlider Momentum;
	var transient UTUISlider Speed;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider RespawnTime;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UTUISlider ShotCost;
	var transient UINumericEditBox AIRating;
	var transient UTUISlider GoliathRecoil;
};
var GoliathCannon Config_GoliathCannon;

// Redeemer //
struct Redeemer
{
	var transient UTUISlider Damage;
	var transient UTUISlider Momentum;
	var transient UTUISlider RocketSpeed;
	var transient UTUISlider AmmoCount;
	var transient UTUISlider MaxAmmo;
	var transient UTUISlider RespawnTime;
	var transient UTUISlider ZoomFOV;
	var transient UTUISlider ZoomRate;
	var transient UTUISlider ShotCost;
	var transient UINumericEditBox AIRating;
	var transient UINumericEditBox NodeDamageScaling;
	var transient UINumericEditBox VehicleDamageScaling;
	var transient UINumericEditBox VehicleMomentumScaling;
   var transient UTUISlider DeemerRecoil;
};
var Redeemer Config_RedeemMachine;

// Trans //
struct Trans
{
   var transient UTUICollectionCheckBox bUseTrans;
	var transient UINumericEditBox FireInterval;
   var transient UTUINumericEditBox AIRating;
	var transient UTUISlider RechargeRate;
	var transient UTUISlider TossZ;
	var transient UTUISlider Speed;
	var transient UTUISlider MaxAmmo;
   var transient UTUISlider Buoyancy;
   var transient UTUISlider MomentumTransfer;
   var transient UTUISlider GibPerterbation;
};
var Trans Config_TransElite;


/**** Begin Code: ****/

/** Replacement info. */
event PostInitialize()
{
	Super.PostInitialize();

	WeaponsToReplace = class'EM_XX.MutEM_XX'.default.WeaponsToReplace;
	AmmoToReplace = class'EM_XX.MutEM_XX'.default.AmmoToReplace;

	OptionList = UTUIOptionList(FindChild('lstOptions', true));
	OptionList.OnAcceptOptions=OnAcceptOptions;

	// Get datastore references
	OptionsDataStore = UTUIDataStore_Options(FindDataStore('UTOptions'));
	StringListDataStore = UTUIDataStore_StringList(FindDataStore('UTStringList'));
	MenuItemDataStore = UTUIDataStore_MenuItems(FindDataStore('UTMenuItems'));
	
	BuildWeaponOptions();	
}

/** Actiated event for the scene. */
event SceneActivated(bool bInitialActivation)
{
	Super.SceneActivated(bInitialActivation);

	InitiateWeaponSettings();
	InitiateWeaponSettingsContinued();
	InitiateMutationSettings();
//	InitiateReplacementSettings();

/** Replacement info. */
//	OptionList.SetFocus(none); // This opens the scene on the wrong page (Starts on a Hidden Replacement Page)
}
/*
function InitiateReplacementSettings()
{
   // Frame
	frameReplacement = UIFrameBox(FindChild('frame_Replacement', true));
}
*/
/** Builds the weapons option lists. */
function BuildWeaponOptions()
{
	local int WeaponIdx;
	local int SelectedIdx;
	local int NameIdx;
	local array<UTUIResourceDataProvider> OutProviders;
	local array<UTUIResourceDataProvider> WeaponOptions;
	local bool bAddWeapon;
	local string ClassPath;

	// Build a list of weapons
	WeaponProviders.length = 0;
	WeaponClassNames.length = 0;
	WeaponFriendlyNames.length = 0;

	if(MenuItemDataStore.GetProviderSet('Weapons', OutProviders))
	{
		for(WeaponIdx=0; WeaponIdx<OutProviders.length; WeaponIdx++)
		{
			bAddWeapon=true;

			
			ClassPath = UTUIDataProvider_Weapon(OutProviders[WeaponIdx]).ClassName;

			// Remove content weapons from console
			if (class'WorldInfo'.static.IsConsoleBuild() && Left(ClassPath, 14) ~= "UTGameContent.")
			{
				bAddWeapon=false;
			}

			if(bAddWeapon)
			{
				WeaponProviders.AddItem(UTUIDataProvider_Weapon(OutProviders[WeaponIdx]));
				WeaponClassNames.AddItem(ClassPath);
				WeaponFriendlyNames.AddItem(UTUIDataProvider_Weapon(OutProviders[WeaponIdx]).FriendlyName);
			}
		}
	}

	// Generate weapon set if we havent already.
	OptionsDataStore.GetSet('ReplacementWeapons', WeaponOptions);

	if(WeaponOptions.length==0)
	{
		OptionsDataStore.AppendToSet('ReplacementWeapons', WeaponFriendlyNames.length);
		OptionsDataStore.GetSet('ReplacementWeapons', WeaponOptions);

		// Generate set of options and set of possible values
		for(WeaponIdx=0; WeaponIdx<WeaponFriendlyNames.length; WeaponIdx++)
		{
			ClassPath = GetClassFieldName(WeaponClassNames[WeaponIdx]);
			
			UTUIDataProvider_MenuOption(WeaponOptions[WeaponIdx]).DataStoreMarkup = "<UTStringList:"$ClassPath$">";
			UTUIDataProvider_MenuOption(WeaponOptions[WeaponIdx]).CustomFriendlyName = WeaponFriendlyNames[WeaponIdx];

			StringListDataStore.Empty(name(ClassPath));
			for(NameIdx=0; NameIdx<WeaponFriendlyNames.length; NameIdx++)
			{
				StringListDataStore.AddStr(name(ClassPath), WeaponFriendlyNames[NameIdx]);
			}

			StringListDataStore.SetCurrentValueIndex(name(ClassPath), WeaponIdx);
		}

		OptionList.bRegenOptions=true;
	}
	else
	{
		for(WeaponIdx=0; WeaponIdx<WeaponFriendlyNames.length; WeaponIdx++)
		{
			ClassPath = GetClassFieldName(WeaponClassNames[WeaponIdx]);
			StringListDataStore.SetCurrentValueIndex(name(ClassPath), WeaponIdx);
		}
	}

	// Set defaults
	for(WeaponIdx=0; WeaponIdx<WeaponsToReplace.length; WeaponIdx++)
	{
		for(SelectedIdx=0; SelectedIdx<WeaponClassNames.length; SelectedIdx++)
		{
			if(WeaponsToReplace[WeaponIdx].NewClassPath==WeaponClassNames[SelectedIdx])
			{
				ClassPath = GetClassFieldName(string(WeaponsToReplace[WeaponIdx].OldClassName));
				StringListDataStore.SetCurrentValueIndex(name(ClassPath), SelectedIdx);
			}
		}
	}

	OptionList.RefreshAllOptions();
}

/** Callback for when the option list is accepted. */
function OnAcceptOptions(UIScreenObject InObj, int PlayerIndex)
{
	OnAccept();
}

/** @return string	Returns a fieldname given a weapon class name. */
function string GetClassFieldName(string ClassName)
{
	ClassName = Right(ClassName, Len(ClassName) - InStr(ClassName, ".") - 1);
	ClassName = Repl(ClassName, ".", "_");
	ClassName = "ReplaceWeapon_"$ClassName;
	return ClassName;
}

/** Sets up the scene's button bar. */
function SetupButtonBar()
{
	ButtonBar.Clear();
	ButtonBar.AppendButton("<Strings:UTGameUI.ButtonCallouts.Back>", OnButtonBar_Back);
	ButtonBar.AppendButton("<Strings:UTGameUI.ButtonCallouts.Accept>", OnButtonBar_Accept);
}

/** Callback for when the user wants to back out of this screen. */
function OnBack()
{
	CloseScene(self);
}

function SetTitle()
{
	local UILabel TitleLabel;
	local UTUIDataStore_MenuItems MenuDataStore;
	local int MutatorIndex;
	local string MutatorName;

	TitleLabel = GetTitleLabel();

	if(TitleLabel != none)
	{
		if(TabControl == none)
		{
			//Find mutator's FriendlyName.
			MenuDataStore = UTUIDataStore_MenuItems(class'UIInteraction'.static.GetDataStoreClient().FindDataStore('UTMenuItems'));
			MutatorIndex = MenuDataStore.FindValueInProviderSet('Mutators', 'ClassName', PathName(MutatorClass));

			if(MutatorIndex != INDEX_NONE)
			{
				MenuDataStore.GetValueFromProviderSet('Mutators', 'FriendlyName', MutatorIndex, MutatorName);
			}
		}

		TitleLabel.SetDataStoreBinding(MutatorName);
	}
}

function OnSelectionChange(UTSimpleList SourceList, int NewSelectedIndex)
{
	if (SourceList == MyWeaponList)
	{
		UpdateWeaponStatDisplay(MyWeaponList.Selection);
	}
}

//////////////////////////////////////
// Weapon Frame List for UI
//////////////////////////////////////
function UpdateWeaponStatDisplay(int Selection)
{

/* 
 Weapon Listing
	0=Bio Rifle
   1=Enforcer
   2=Flak Cannon
   3=Impact Hammer
   4=Link Gun
   5=Rocket Launcher
	6=Shock Rifle
   7=Sniper Rifle
   8=Stinger
   9=Goliath Cannon
   10=Redeemer
   11=Trans
*/

	local int x;

	for (x=0;x<=13;x++)
	{
		if (x == Selection)
		{
			frameWeapon[x].SetVisibility(True);
		}
		else
		{
			frameWeapon[x].SetVisibility(False);
		}
	}
}

function InitiateWeaponSettings()
{
//////////////////////////////////////
// Bindings Settings
//////////////////////////////////////
	// Weapon List Binding
	MyWeaponList = UTSimpleList(FindChild('MyWeaponList', true));
   frameWeapon[0] = UIFrameBox(FindChild('frameImpactHammer', true));
   frameWeapon[1] = UIFrameBox(FindChild('frameEnforcer', true));
	frameWeapon[2] = UIFrameBox(FindChild('frameBioRifle', true));
   frameWeapon[3] = UIFrameBox(FindChild('frameShockRifle', true));
   frameWeapon[4] = UIFrameBox(FindChild('frameLinkGun', true));
   frameWeapon[5] = UIFrameBox(FindChild('frameStinger', true));
	frameWeapon[6] = UIFrameBox(FindChild('frameFlakCannon', true));
	frameWeapon[7] = UIFrameBox(FindChild('frameRocketLauncher', true));
	frameWeapon[8] = UIFrameBox(FindChild('frameSniperRifle', true));

	// Bio Rifle Settings Binding
	Config_Bio_Rifle.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbBioAmmoRegeneration', true));
	Config_Bio_Rifle.bDoubles = UTUICollectionCheckBox(FindChild('cbBioDoubles', true));
	Config_Bio_Rifle.PriFireInterval = UINumericEditBox(FindChild('oilBioPriFireInterval', true));
	Config_Bio_Rifle.SecFireInterval = UINumericEditBox(FindChild('oilBioSecFireInterval', true));
	Config_Bio_Rifle.AIRating = UINumericEditBox(FindChild('oilBioAIRating', true));
	Config_Bio_Rifle.DamageOverlayTime = UINumericEditBox(FindChild('oilBioOverlay', true));
	Config_Bio_Rifle.VehicleDamageScaling = UINumericEditBox(FindChild('oilBioVehicle', true));
   Config_Bio_Rifle.NodeDamageScaling = UINumericEditBox(FindChild('oilBioNode', true));
	Config_Bio_Rifle.Damage = UTUISlider(FindChild('sliBioDamage', true));
	Config_Bio_Rifle.Momentum = UTUISlider(FindChild('sliBioMomentum', true));
	Config_Bio_Rifle.AmmoCount = UTUISlider(FindChild('sliBioAmmoCount', true));
	Config_Bio_Rifle.MaxAmmo = UTUISlider(FindChild('sliBioMaxAmmo', true));
	Config_Bio_Rifle.HelpRadius = UTUISlider(FindChild('sliBioPriHelp', true));
	Config_Bio_Rifle.AimError = UTUISlider(FindChild('sliBioAimError', true));
	Config_Bio_Rifle.ShotCost = UTUISlider(FindChild('sliBioShotCost', true));
	Config_Bio_Rifle.Speed = UTUISlider(FindChild('sliBioSpeed', true));
	Config_Bio_Rifle.MaxResting = UTUISlider(FindChild('sliBioMaxResting', true));
	Config_Bio_Rifle.GlobStrength = UTUISlider(FindChild('sliBioGlobStrength', true));
	Config_Bio_Rifle.GloblingSpeed = UTUISlider(FindChild('sliBioGloblingSpeed', true));
	Config_Bio_Rifle.DamageRadius = UTUISlider(FindChild('sliBioDamageRadius', true));
	Config_Bio_Rifle.VehicleMomentumScaling = UINumericEditBox(FindChild('oilBioVehicleScaling', true));
	Config_Bio_Rifle.DripTime = UINumericEditBox(FindChild('oilBioDripTime', true));
	Config_Bio_Rifle.BioRecoil = UTUISlider(FindChild('sliBioRecoil', true));
   Config_Bio_Rifle.SecSpeed = UTUISlider(FindChild('sliBioSecSpeed', true));
   Config_Bio_Rifle.SecDamage = UTUISlider(FindChild('sliBioSecDamage', true));
   Config_Bio_Rifle.SecDamageRadius = UTUISlider(FindChild('sliBioSecDamageRadius', true));
	Config_Bio_Rifle.PriFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fPriFireInterval);
   Config_Bio_Rifle.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fAIRating);
   Config_Bio_Rifle.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDamageOverlayTime);
   Config_Bio_Rifle.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleDamageScaling);
   Config_Bio_Rifle.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fNodeDamageScaling);
   Config_Bio_Rifle.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleMomentumScaling);
   Config_Bio_Rifle.DripTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDripTime);
   Config_Bio_Rifle.SecFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fSecFireInterval);

	// Enforcer Settings Binding
	Config_Enforcer.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbENFAmmoRegeneration', true));
	Config_Enforcer.bDoubles = UTUICollectionCheckBox(FindChild('cbENFDoubles', true));
	Config_Enforcer.PriFireInterval = UINumericEditBox(FindChild('oilEnfPriFireInterval', true));
	Config_Enforcer.SecFireInterval = UINumericEditBox(FindChild('oilEnfSecFireInterval', true));
	Config_Enforcer.PriSpread = UINumericEditBox(FindChild('oilEnfPriSpread', true));
	Config_Enforcer.SecSpread = UINumericEditBox(FindChild('oilEnfSecSpread', true));
	Config_Enforcer.PriDamage = UTUISlider(FindChild('sliPriEnfDmg', true));
	Config_Enforcer.SecDamage = UTUISlider(FindChild('sliSecEnfDmg', true));
	Config_Enforcer.Momentum = UTUISlider(FindChild('sliEnfMomentum', true));
	Config_Enforcer.AmmoCount = UTUISlider(FindChild('sliEnforcerAmmoCount', true));
	Config_Enforcer.MaxAmmo = UTUISlider(FindChild('sliEnfMaxAmmo', true));
	Config_Enforcer.ShotCost = UTUISlider(FindChild('sliEnfShotCost', true));
	Config_Enforcer.HelpRadius = UTUISlider(FindChild('sliEnfPriHelp', true));
	Config_Enforcer.AimError = UTUISlider(FindChild('sliEnfAimError', true));
	Config_Enforcer.AkimboTime = UINumericEditBox(FindChild('oilEnfAkimboTime', true));
	Config_Enforcer.BurstMax = UTUISlider(FindChild('sliEnfBurstMax', true));
	Config_Enforcer.EnforcerRecoil = UTUISlider(FindChild('sliEnfRecoil', true));
	Config_Enforcer.AIRating = UINumericEditBox(FindChild('oilEnfAIRating', true));
	Config_Enforcer.DamageOverlayTime = UINumericEditBox(FindChild('oilEnfDamageOverlay', true));
	Config_Enforcer.VehicleDamageScaling = UINumericEditBox(FindChild('oilEnfVehicle', true));
	Config_Enforcer.VehicleMomentumScaling = UINumericEditBox(FindChild('oilEnfVehMomentum', true));
	Config_Enforcer.NodeDamageScaling = UINumericEditBox(FindChild('oilEnfNode', true));
	Config_Enforcer.BurstCoolDownTime = UINumericEditBox(FindChild('oilEnfBurstCool', true));
	Config_Enforcer.PriFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriFireInterval);
	Config_Enforcer.SecFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecFireInterval);
	Config_Enforcer.PriSpread.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriSpread);
	Config_Enforcer.SecSpread.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecSpread);
	Config_Enforcer.AkimboTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAkimboTime);
	Config_Enforcer.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAIRating);
	Config_Enforcer.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fDamageOverlayTime);
	Config_Enforcer.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleDamageScaling);
	Config_Enforcer.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleMomentumScaling);
	Config_Enforcer.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fNodeDamageScaling);
	Config_Enforcer.BurstCoolDownTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.fBurstCoolDownTime);

	// Flak Cannon Settings Binding
	Config_FlakCannon.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbFlakAmmoRegeneration', true));
	Config_FlakCannon.bDoubles = UTUICollectionCheckBox(FindChild('cbFlakDoubles', true));
	Config_FlakCannon.AIRating = UINumericEditBox(FindChild('oilFlakAIRating', true));
	Config_FlakCannon.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fAIRating);
	Config_FlakCannon.PriFireRate = UINumericEditBox(FindChild('oilFlakPriFireRate', true));
	Config_FlakCannon.PriFireRate.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fPriFireRate);
	Config_FlakCannon.SecFireRate = UINumericEditBox(FindChild('oilFlakSecFireRate', true));
	Config_FlakCannon.SecFireRate.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSecFireRate);
	Config_FlakCannon.Spread = UINumericEditBox(FindChild('oilFlakSpread', true));
	Config_FlakCannon.Spread.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSpread);
	Config_FlakCannon.MaxBonusTime = UINumericEditBox(FindChild('oilFlakMaxBonusTime', true));
	Config_FlakCannon.MaxBonusTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fMaxBonusTime);
	Config_FlakCannon.CustomGravityScaling = UINumericEditBox(FindChild('oilFlakCustomGravityScaling', true));
	Config_FlakCannon.CustomGravityScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fCustomGravityScaling);
	Config_FlakCannon.DamageOverlayTime = UINumericEditBox(FindChild('oilFlakDamageOverlayTime', true));
	Config_FlakCannon.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fDamageOverlayTime);
	Config_FlakCannon.NodeDamageScaling = UINumericEditBox(FindChild('oilFlakNodeDamageScaling', true));
	Config_FlakCannon.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fNodeDamageScaling);
	Config_FlakCannon.VehicleDamageScaling = UINumericEditBox(FindChild('oilFlakVehicleDamageScaling', true));
	Config_FlakCannon.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleDamageScaling);
	Config_FlakCannon.VehicleMomentumScaling = UINumericEditBox(FindChild('oilFlakVehicleMomentumScaling', true));
	Config_FlakCannon.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleMomentumScaling);
	Config_FlakCannon.FlakRecoil = UTUISlider(FindChild('sliFlakRecoil', true));
	Config_FlakCannon.AmmoCount = UTUISlider(FindChild('sliFlakAmmoCount', true));
	Config_FlakCannon.MaxAmmo = UTUISlider(FindChild('sliFlakMaxAmmo', true));
   Config_FlakCannon.speed = UTUISlider(FindChild('sliFlakspeed', true));
   Config_FlakCannon.Damage = UTUISlider(FindChild('sliFlakDamage', true));
   Config_FlakCannon.DamageRadius = UTUISlider(FindChild('sliFlakDamageRadius', true));
   Config_FlakCannon.Momentum = UTUISlider(FindChild('sliFlakMomentum', true));
   Config_FlakCannon.ShardBounces = UTUISlider(FindChild('sliFlakShardBounces', true));
   Config_FlakCannon.CenteredDamageBonus = UTUISlider(FindChild('sliFlakCenteredDamageBonus', true));
   Config_FlakCannon.MainBounces = UTUISlider(FindChild('sliFlakMainBounces', true));
   Config_FlakCannon.SecDamageRadius = UTUISlider(FindChild('sliFlakSecDamageRadius', true));
   Config_FlakCannon.SecDamage = UTUISlider(FindChild('sliFlakSecDamage', true));
   Config_FlakCannon.Secspeed = UTUISlider(FindChild('sliFlakSecspeed', true));
   Config_FlakCannon.TossZ = UTUISlider(FindChild('sliFlakTossZ', true));
   Config_FlakCannon.ShotCost = UTUISlider(FindChild('sliFlakShotCost', true));

	// Impact Hammer Settings Binding
	Config_ImpactHammer.MinDmg = UTUISlider(FindChild('sliImpactMinDmg', true));
	Config_ImpactHammer.MaxDmg = UTUISlider(FindChild('sliImpactMaxDmg', true));
	Config_ImpactHammer.MinForce = UTUISlider(FindChild('sliImpactMinForce', true));
	Config_ImpactHammer.MaxForce = UTUISlider(FindChild('sliImpactMaxForce', true));
	Config_ImpactHammer.MinSelfDmg = UTUISlider(FindChild('sliImpactMinSelfDmg', true));
	Config_ImpactHammer.EMPDmg = UTUISlider(FindChild('sliImpactEmpDmg', true));
	Config_ImpactHammer.SelfDmgScale = UTUISlider(FindChild('sliSelfDmgScale', true));
	Config_ImpactHammer.SelfForceScale = UTUISlider(FindChild('sliSelfForceScale', true));
	Config_ImpactHammer.bUseHammer = UTUICollectionCheckBox(FindChild('cbUseHammer', true));
	Config_ImpactHammer.AIRating = UINumericEditBox(FindChild('oilHammerAIRating', true));
	Config_ImpactHammer.MaxChargeTime = UINumericEditBox(FindChild('oilImpactMaxChargeTime', true));
	Config_ImpactHammer.MinChargeTime = UINumericEditBox(FindChild('oilImpactMinChargeTime', true));
	Config_ImpactHammer.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fAIRating);
	Config_ImpactHammer.MaxChargeTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxChargeTime);
	Config_ImpactHammer.MinChargeTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinChargeTime);

	// Link Gun Settings Binding
	Config_LinkGun.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbLinkAmmoRegeneration', true));
	Config_LinkGun.bDoubles = UTUICollectionCheckBox(FindChild('cbLinkDoubles', true));
	Config_LinkGun.PriFireInterval = UINumericEditBox(FindChild('oilLinkFireInterval', true));
	Config_LinkGun.NodeDamageScaling = UINumericEditBox(FindChild('oilLinkNode', true));
	Config_LinkGun.VehicleDamageScaling = UINumericEditBox(FindChild('oilLinkVehicle', true));
	Config_LinkGun.VehicleMomentumScaling = UINumericEditBox(FindChild('oilLinkVehicleMomentum', true));
	Config_LinkGun.DamageOverlayTime = UINumericEditBox(FindChild('oilLinkOverlay', true));
	Config_LinkGun.LinkFlexibility = UINumericEditBox(FindChild('oilLinkFlex', true));
	Config_LinkGun.AIRating = UINumericEditBox(FindChild('oilLinkAIRating', true));
	Config_LinkGun.PriDamage = UTUISlider(FindChild('sliLinkPriDmg', true));
	Config_LinkGun.SecDamage = UTUISlider(FindChild('sliLinkSecDmg', true));
	Config_LinkGun.Momentum = UTUISlider(FindChild('sliLinkMomentum', true));
	Config_LinkGun.AmmoCount = UTUISlider(FindChild('sliLinkAmmoCount', true));
	Config_LinkGun.MaxAmmo = UTUISlider(FindChild('sliLinkMaxAmmo', true));
	Config_LinkGun.ProJSpeed = UTUISlider(FindChild('sliLinkProJSpeed', true));
	Config_LinkGun.DamageRadius = UTUISlider(FindChild('sliLinkDamageRadius', true));
	Config_LinkGun.BeamAmmoSec = UTUISlider(FindChild('sliLinkBeamAmmoSec', true));
	Config_LinkGun.WeaponLinkDistance = UTUISlider(FindChild('sliLinkDistance', true));
	Config_LinkGun.ShotCost = UTUISlider(FindChild('sliLinkShotCost', true));
	Config_LinkGun.BeamRange = UTUISlider(FindChild('sliLinkBeamDistance', true));
	Config_LinkGun.LucyRecoil = UTUISlider(FindChild('sliLucyRecoil', true));
   Config_LinkGun.PriFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fPriFireInterval);
   Config_LinkGun.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fNodeDamageScaling);
   Config_LinkGun.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleDamageScaling);
   Config_LinkGun.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleMomentumScaling);
   Config_LinkGun.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime);
   Config_LinkGun.LinkFlexibility.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fLinkFlexibility);
   Config_LinkGun.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.fAIRating);

	// Rocket Launcher Settings Binding
	Config_RL_BFG.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbRocketAmmoRegeneration', true));
	Config_RL_BFG.bDoubles = UTUICollectionCheckBox(FindChild('cbRocketDoubles', true));
	Config_RL_BFG.PriFireInterval = UINumericEditBox(FindChild('oilRocketPriFireInterval', true));
	Config_RL_BFG.SecFireInterval = UINumericEditBox(FindChild('oilRocketSecFireInterval', true));
	Config_RL_BFG.AIRating = UINumericEditBox(FindChild('oilRocketAIRating', true));
	Config_RL_BFG.DamageOverlayTime = UINumericEditBox(FindChild('oilRocketOverlay', true));
	Config_RL_BFG.NodeDamageScaling = UINumericEditBox(FindChild('oilRocketNode', true));
	Config_RL_BFG.VehicleDamageScaling = UINumericEditBox(FindChild('oilRocketVehicle', true));
	Config_RL_BFG.VehicleMomentumScaling = UINumericEditBox(FindChild('oilRocketVehicleMomentum', true));
	Config_RL_BFG.Damage = UTUISlider(FindChild('sliRocketDamage', true));
	Config_RL_BFG.Momentum = UTUISlider(FindChild('sliRocketMomentum', true));
	Config_RL_BFG.AmmoCount = UTUISlider(FindChild('sliRocketAmmoCount', true));
	Config_RL_BFG.MaxAmmo = UTUISlider(FindChild('sliRocketMaxAmmo', true));
	Config_RL_BFG.HelpRadius = UTUISlider(FindChild('sliRocketPriHelp', true));
	Config_RL_BFG.AimError = UTUISlider(FindChild('sliRocketAimError', true));
	Config_RL_BFG.ShotCost = UTUISlider(FindChild('sliRocketShotCost', true));
	Config_RL_BFG.Speed = UTUISlider(FindChild('sliRocketSpeed', true));
	Config_RL_BFG.GrenadeSpeed = UTUISlider(FindChild('sliRGrenadeSpeed', true));
	Config_RL_BFG.DamageRadius = UTUISlider(FindChild('sliRocketDamageRadius', true));
	Config_RL_BFG.LockAcquireTime = UINumericEditBox(FindChild('oilRocketAcquireTime', true));
	Config_RL_BFG.spreaddist = UTUISlider(FindChild('sliRocketspreaddist', true));
	Config_RL_BFG.grenadespreaddist = UTUISlider(FindChild('sliRocketgrenadespreaddist', true));
	Config_RL_BFG.LockRange = UTUISlider(FindChild('sliRocketLockRange', true));
   Config_RL_BFG.FlockRadius = UTUISlider(FindChild('sliRocketFlockRadius', true));
   Config_RL_BFG.RocketRecoil = UTUISlider(FindChild('sliRocketRecoil', true));
   Config_RL_BFG.FlockStiffness = UTUISlider(FindChild('sliRocketStiffness', true));
   Config_RL_BFG.FlockCurlForce = UTUISlider(FindChild('sliRocketCurlForce', true));
   Config_RL_BFG.PriFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fPriFireInterval);
   Config_RL_BFG.SecFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fSecFireInterval);
   Config_RL_BFG.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAIRating);
   Config_RL_BFG.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fDamageOverlayTime);
   Config_RL_BFG.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fNodeDamageScaling);
   Config_RL_BFG.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleDamageScaling);
   Config_RL_BFG.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleMomentumScaling);
   Config_RL_BFG.LockAcquireTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAcquireTime);

	// Shock Rifle Settings Binding
	Config_Shock_Rifle.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbShockAmmoRegeneration', true));
	Config_Shock_Rifle.bDoubles = UTUICollectionCheckBox(FindChild('cbShockDoubles', true));
//	Config_Shock_Rifle.bUseCombo = UTUICollectionCheckBox(FindChild('cbUseCombo', true));
	Config_Shock_Rifle.FireInterval = UINumericEditBox(FindChild('oilShockFireInterval', true));
	Config_Shock_Rifle.SecFireInterval = UINumericEditBox(FindChild('oilShockSecFireInterval', true));
	Config_Shock_Rifle.AIRating = UINumericEditBox(FindChild('oilShockAIRating', true));
	Config_Shock_Rifle.DamageOverlayTime = UINumericEditBox(FindChild('oilShockOverlay', true));
	Config_Shock_Rifle.NodeDamageScaling = UINumericEditBox(FindChild('oilShockNode', true));
	Config_Shock_Rifle.VehicleDamageScaling = UINumericEditBox(FindChild('oilShockVehicle', true));
	Config_Shock_Rifle.VehicleMomentumScaling = UINumericEditBox(FindChild('oilShockMomentumVehicle', true));
	Config_Shock_Rifle.Damage = UTUISlider(FindChild('sliShockDamage', true));
//	Config_Shock_Rifle.ComboDamage = UTUISlider(FindChild('sliShockComboDamage', true));
	Config_Shock_Rifle.InstaDamage = UTUISlider(FindChild('sliInstaDamage', true));
	Config_Shock_Rifle.Momentum = UTUISlider(FindChild('sliShockMomentum', true));
	Config_Shock_Rifle.AmmoCount = UTUISlider(FindChild('sliShockAmmoCount', true));
	Config_Shock_Rifle.MaxAmmo = UTUISlider(FindChild('sliShockMaxAmmo', true));
	Config_Shock_Rifle.HeadShotDmgMult = UINumericEditBox(FindChild('oilShockHeadShotDmgMult', true));
	Config_Shock_Rifle.SlowHeadshotScale = UINumericEditBox(FindChild('oilShockSlowHeadshotScale', true));
	Config_Shock_Rifle.RunningHeadshotScale = UINumericEditBox(FindChild('oilShockRunningHeadshotScale', true));
//	Config_Shock_Rifle.PriHelpRadius = UTUISlider(FindChild('sliShockPriHelp', true));
//	Config_Shock_Rifle.AimError = UTUISlider(FindChild('sliShockAimError', true));
	Config_Shock_Rifle.ShotCost = UTUISlider(FindChild('sliShockShotCost', true));
	Config_Shock_Rifle.ComboAmmoCost = UTUISlider(FindChild('sliShockComboCost', true));
	Config_Shock_Rifle.InstaRecoil = UTUISlider(FindChild('sliInstaRecoil', true));
	Config_Shock_Rifle.Speed = UTUISlider(FindChild('sliShockSpeed', true));
	Config_Shock_Rifle.DamageRadius = UTUISlider(FindChild('sliShockDamageRadius', true));
//	Config_Shock_Rifle.ComboDamageRadius = UTUISlider(FindChild('sliShockComboRadius', true));
	Config_Shock_Rifle.DamageImpulse = UTUISlider(FindChild('sliShockDamageImpulse', true));
	Config_Shock_Rifle.ImpulseRadius = UTUISlider(FindChild('sliShockImpulseRadius', true));
//	Config_Shock_Rifle.ComboDamageRadius = UTUISlider(FindChild('sliShockImpulseRadius', true));
   Config_Shock_Rifle.VortexRadius = UTUISlider(FindChild('sliShockVortexRadius', true));
   Config_Shock_Rifle.VortexForcePerSecond = UTUISlider(FindChild('sliShockVortexForcePerSecond', true));
   Config_Shock_Rifle.VortexDuration = UINumericEditBox(FindChild('oilShockVortexDuration', true));
   Config_Shock_Rifle.VortexDuration.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVortexDuration);
	Config_Shock_Rifle.FireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fFireInterval);
	Config_Shock_Rifle.SecFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSecFireInterval);
	Config_Shock_Rifle.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fAIRating);
	Config_Shock_Rifle.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fDamageOverlayTime);
	Config_Shock_Rifle.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fNodeDamageScaling);
	Config_Shock_Rifle.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleDamageScaling);
	Config_Shock_Rifle.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleMomentumScaling);
	Config_Shock_Rifle.HeadShotDmgMult.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fHeadShotDmgMult);
	Config_Shock_Rifle.SlowHeadshotScale.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSlowHeadshotScale);
	Config_Shock_Rifle.RunningHeadshotScale.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fRunningHeadshotScale);

	// Sniper Rifle Settings Binding
	Config_Sniper_Rifle.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbTigerAmmoRegeneration', true));
	Config_Sniper_Rifle.bDoubles = UTUICollectionCheckBox(FindChild('cbTigerDoubles', true));
	Config_Sniper_Rifle.FireInterval = UINumericEditBox(FindChild('oilTigerFire', true));
	Config_Sniper_Rifle.DamageOverlayTime = UINumericEditBox(FindChild('oilTigerOverlayTime', true));
	Config_Sniper_Rifle.NodeDamageScaling = UINumericEditBox(FindChild('oilTigerNodeScaling', true));
	Config_Sniper_Rifle.VehicleDamageScaling = UINumericEditBox(FindChild('oilTigerVehicleScaling', true));
	Config_Sniper_Rifle.VehicleMomentumScaling = UINumericEditBox(FindChild('oilTigerVehicleMomentum', true));
	Config_Sniper_Rifle.AIRating = UINumericEditBox(FindChild('oilTigerAIRating', true));
	Config_Sniper_Rifle.SlowHeadshotScale = UINumericEditBox(FindChild('oilTigerSlowScale', true));
	Config_Sniper_Rifle.RunningHeadshotScale = UINumericEditBox(FindChild('oilTigerRunScale', true));
	Config_Sniper_Rifle.Damage = UTUISlider(FindChild('sliTigerDamage', true));
	Config_Sniper_Rifle.Momentum = UTUISlider(FindChild('sliTigerMomentum', true));
	Config_Sniper_Rifle.HeadShotDmgMult = UINumericEditBox(FindChild('oilTigerHSDmgMult', true));
	Config_Sniper_Rifle.AmmoCount = UTUISlider(FindChild('sliTigerAmmoCount', true));
	Config_Sniper_Rifle.MaxAmmo = UTUISlider(FindChild('sliTigerMaxAmmo', true));
	Config_Sniper_Rifle.ZoomFOV = UTUISlider(FindChild('sliTigerFOV', true));
	Config_Sniper_Rifle.ZoomRate = UTUISlider(FindChild('sliTigerRate', true));
	Config_Sniper_Rifle.PriHelpRadius = UTUISlider(FindChild('sliTigerPriHelp', true));
	Config_Sniper_Rifle.AimError = UTUISlider(FindChild('sliTigerAimError', true));
	Config_Sniper_Rifle.ShotCost = UTUISlider(FindChild('sliTigerShotCost', true));
	Config_Sniper_Rifle.SniperRecoil = UTUISlider(FindChild('sliSniperRecoil', true));
	Config_Sniper_Rifle.FireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fFireInterval);
	Config_Sniper_Rifle.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fDamageOverlayTime);
	Config_Sniper_Rifle.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fNodeDamageScaling);
	Config_Sniper_Rifle.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleDamageScaling);
	Config_Sniper_Rifle.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleMomentumScaling);
	Config_Sniper_Rifle.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fAIRating);
	Config_Sniper_Rifle.SlowHeadshotScale.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fSlowHeadshotScale);
	Config_Sniper_Rifle.RunningHeadshotScale.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fRunningHeadshotScale);
	Config_Sniper_Rifle.HeadShotDmgMult.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fHeadShotDmgMult);

	// Stinger Settings Binding
	Config_Stinger.bAmmoRegeneration = UTUICollectionCheckBox(FindChild('cbStingerAmmoRegeneration', true));
	Config_Stinger.bDoubles = UTUICollectionCheckBox(FindChild('cbStingerDoubles', true));
	Config_Stinger.PriFireInterval = UINumericEditBox(FindChild('oilStingerPriFireInterval', true));
	Config_Stinger.SecFireInterval = UINumericEditBox(FindChild('oilStingerSecFireInterval', true));
	Config_Stinger.PriSpread = UINumericEditBox(FindChild('oilStingerPriSpread', true));
	Config_Stinger.SecSpread = UINumericEditBox(FindChild('oilStingerSecSpread', true));
	Config_Stinger.AIRating = UINumericEditBox(FindChild('oilStingerAIRating', true));
	Config_Stinger.ShotCost = UTUISlider(FindChild('sliStingerShotCost', true));
	Config_Stinger.AimingHelpRadius = UTUISlider(FindChild('sliStingerAimingHelpRadius', true));
	Config_Stinger.AimError = UTUISlider(FindChild('sliStingerAimError', true));
	Config_Stinger.StingerRecoil = UTUISlider(FindChild('sliStingerRecoil', true));
	Config_Stinger.NodeDamageScaling = UINumericEditBox(FindChild('oilStingerNodeDamageScaling', true));
	Config_Stinger.VehicleDamageScaling = UINumericEditBox(FindChild('oilStingerVehicleDamageScaling', true));
	Config_Stinger.VehicleMomentumScaling = UINumericEditBox(FindChild('oilStingerVehicleMomentum', true));
	Config_Stinger.DamageOverlayTime = UINumericEditBox(FindChild('oilStingerDamageOverlayTime', true));
	Config_Stinger.AmmoCount = UTUISlider(FindChild('sliStingerAmmoCount', true));
	Config_Stinger.MaxAmmoCount = UTUISlider(FindChild('sliStingerMaxAmmoCount', true));
	Config_Stinger.Speed = UTUISlider(FindChild('sliStingerSpeed', true));
	Config_Stinger.Damage = UTUISlider(FindChild('sliStingerDamage', true));
	Config_Stinger.DamageRadius = UTUISlider(FindChild('sliStingerDamageRadius', true));
	Config_Stinger.MomentumTransfer = UTUISlider(FindChild('sliStingerMomentumTransfer', true));
	Config_Stinger.SecSpeed = UTUISlider(FindChild('sliStingerSecSpeed', true));
	Config_Stinger.SecDamage = UTUISlider(FindChild('sliStingerSecDamage', true));
	Config_Stinger.SecDamageRadius = UTUISlider(FindChild('sliStingerSecDamageRadius', true));
	Config_Stinger.SecBounces = UTUISlider(FindChild('sliStingerSecBounces', true));
	Config_Stinger.PriFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriFireInterval);
	Config_Stinger.SecFireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecFireInterval);
	Config_Stinger.PriSpread.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriSpread);
	Config_Stinger.SecSpread.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecSpread);
	Config_Stinger.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fAIRating);
	Config_Stinger.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fNodeDamageScaling);
	Config_Stinger.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleDamageScaling);
	Config_Stinger.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleMomentumScaling);
	Config_Stinger.DamageOverlayTime.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.fDamageOverlayTime);


//////////////////////////////////////
// Initiate Settings
//////////////////////////////////////
	// Bio Rifle Settings Initiate
	Config_Bio_Rifle.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.bAmmoRegeneration);
	Config_Bio_Rifle.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.bDoubles);
	Config_Bio_Rifle.PriFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fPriFireInterval;
	Config_Bio_Rifle.PriFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.PriFireInterval.NumericValue.MinValue = 0.01;
	Config_Bio_Rifle.PriFireInterval.NumericValue.MaxValue = 2;
	Config_Bio_Rifle.PriFireInterval.DecimalPlaces = 2;
	Config_Bio_Rifle.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fAIRating;
	Config_Bio_Rifle.AIRating.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.AIRating.NumericValue.MinValue = 0;
	Config_Bio_Rifle.AIRating.NumericValue.MaxValue = 2.00;
	Config_Bio_Rifle.AIRating.DecimalPlaces = 2;
	Config_Bio_Rifle.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDamageOverlayTime;
	Config_Bio_Rifle.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_Bio_Rifle.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_Bio_Rifle.DamageOverlayTime.DecimalPlaces = 2;
	Config_Bio_Rifle.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleDamageScaling;
	Config_Bio_Rifle.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_Bio_Rifle.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_Bio_Rifle.VehicleDamageScaling.DecimalPlaces = 2;
	Config_Bio_Rifle.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleMomentumScaling;
	Config_Bio_Rifle.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_Bio_Rifle.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_Bio_Rifle.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_Bio_Rifle.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fNodeDamageScaling;
	Config_Bio_Rifle.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_Bio_Rifle.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_Bio_Rifle.NodeDamageScaling.DecimalPlaces = 2;
	Config_Bio_Rifle.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iDamage;
	Config_Bio_Rifle.Damage.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.Damage.SliderValue.MinValue = 5;
	Config_Bio_Rifle.Damage.SliderValue.MaxValue = 300;
	Config_Bio_Rifle.Damage.SliderValue.bIntRange = true;
   Config_Bio_Rifle.Damage.UpdateCaption();
	Config_Bio_Rifle.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMomentum;
	Config_Bio_Rifle.Momentum.SliderValue.NudgeValue = 1000;
   Config_Bio_Rifle.Momentum.SliderValue.MinValue = 0;
	Config_Bio_Rifle.Momentum.SliderValue.MaxValue = 200000;
	Config_Bio_Rifle.Momentum.SliderValue.bIntRange = true;
   Config_Bio_Rifle.Momentum.UpdateCaption();
	Config_Bio_Rifle.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iAmmoCount;
	Config_Bio_Rifle.AmmoCount.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.AmmoCount.SliderValue.MinValue = 1;
	Config_Bio_Rifle.AmmoCount.SliderValue.MaxValue = 500;
	Config_Bio_Rifle.AmmoCount.SliderValue.bIntRange = true;
   Config_Bio_Rifle.AmmoCount.UpdateCaption();
	Config_Bio_Rifle.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMaxAmmo;
	Config_Bio_Rifle.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.MaxAmmo.SliderValue.MinValue = 1;
	Config_Bio_Rifle.MaxAmmo.SliderValue.MaxValue = 500;
	Config_Bio_Rifle.MaxAmmo.SliderValue.bIntRange = true;
   Config_Bio_Rifle.MaxAmmo.UpdateCaption();
	Config_Bio_Rifle.HelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iHelpRadius;
	Config_Bio_Rifle.HelpRadius.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.HelpRadius.SliderValue.MinValue = 0;
	Config_Bio_Rifle.HelpRadius.SliderValue.MaxValue = 100;
	Config_Bio_Rifle.HelpRadius.SliderValue.bIntRange = true;
   Config_Bio_Rifle.HelpRadius.UpdateCaption();
	Config_Bio_Rifle.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iAimError;
	Config_Bio_Rifle.AimError.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.AimError.SliderValue.MinValue = 0;
	Config_Bio_Rifle.AimError.SliderValue.MaxValue = 1000;
	Config_Bio_Rifle.AimError.SliderValue.bIntRange = true;
   Config_Bio_Rifle.AimError.UpdateCaption();
	Config_Bio_Rifle.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iShotCost;
	Config_Bio_Rifle.ShotCost.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.ShotCost.SliderValue.MinValue = 0;
	Config_Bio_Rifle.ShotCost.SliderValue.MaxValue = 1;
	Config_Bio_Rifle.ShotCost.SliderValue.bIntRange = true;
   Config_Bio_Rifle.ShotCost.UpdateCaption();
	Config_Bio_Rifle.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSpeed;
	Config_Bio_Rifle.Speed.SliderValue.NudgeValue = 50;
   Config_Bio_Rifle.Speed.SliderValue.MinValue = 500;
	Config_Bio_Rifle.Speed.SliderValue.MaxValue = 12000;
	Config_Bio_Rifle.Speed.SliderValue.bIntRange = true;
   Config_Bio_Rifle.Speed.UpdateCaption();
	Config_Bio_Rifle.MaxResting.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMaxResting;
	Config_Bio_Rifle.MaxResting.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.MaxResting.SliderValue.MinValue = 1;
	Config_Bio_Rifle.MaxResting.SliderValue.MaxValue = 30;
	Config_Bio_Rifle.MaxResting.SliderValue.bIntRange = true;
   Config_Bio_Rifle.MaxResting.UpdateCaption();
	Config_Bio_Rifle.GlobStrength.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iGlobStrength;
	Config_Bio_Rifle.GlobStrength.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.GlobStrength.SliderValue.MinValue = 1;
	Config_Bio_Rifle.GlobStrength.SliderValue.MaxValue = 30;
	Config_Bio_Rifle.GlobStrength.SliderValue.bIntRange = true;
   Config_Bio_Rifle.GlobStrength.UpdateCaption();
	Config_Bio_Rifle.GloblingSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iGloblingSpeed;
	Config_Bio_Rifle.GloblingSpeed.SliderValue.NudgeValue = 50;
   Config_Bio_Rifle.GloblingSpeed.SliderValue.MinValue = 100;
	Config_Bio_Rifle.GloblingSpeed.SliderValue.MaxValue = 300;
	Config_Bio_Rifle.GloblingSpeed.SliderValue.bIntRange = true;
   Config_Bio_Rifle.GloblingSpeed.UpdateCaption();
	Config_Bio_Rifle.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iDamageRadius;
	Config_Bio_Rifle.DamageRadius.SliderValue.NudgeValue = 5;
   Config_Bio_Rifle.DamageRadius.SliderValue.MinValue = 0;
	Config_Bio_Rifle.DamageRadius.SliderValue.MaxValue = 150;
	Config_Bio_Rifle.DamageRadius.SliderValue.bIntRange = true;
   Config_Bio_Rifle.DamageRadius.UpdateCaption();
	Config_Bio_Rifle.DripTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDripTime;
	Config_Bio_Rifle.DripTime.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.DripTime.NumericValue.MinValue = 0;
	Config_Bio_Rifle.DripTime.NumericValue.MaxValue = 3;
	Config_Bio_Rifle.DripTime.DecimalPlaces = 2;
   Config_Bio_Rifle.BioRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iBioRecoil;
	Config_Bio_Rifle.BioRecoil.SliderValue.NudgeValue = 500;
   Config_Bio_Rifle.BioRecoil.SliderValue.MinValue = 0;
	Config_Bio_Rifle.BioRecoil.SliderValue.MaxValue = 10000;
	Config_Bio_Rifle.BioRecoil.SliderValue.bIntRange = true;
   Config_Bio_Rifle.BioRecoil.UpdateCaption();
	Config_Bio_Rifle.SecFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fSecFireInterval;
	Config_Bio_Rifle.SecFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Bio_Rifle.SecFireInterval.NumericValue.MinValue = 0.01;
	Config_Bio_Rifle.SecFireInterval.NumericValue.MaxValue = 2;
	Config_Bio_Rifle.SecFireInterval.DecimalPlaces = 2;
	Config_Bio_Rifle.SecSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecSpeed;
	Config_Bio_Rifle.SecSpeed.SliderValue.NudgeValue = 50;
   Config_Bio_Rifle.SecSpeed.SliderValue.MinValue = 500;
	Config_Bio_Rifle.SecSpeed.SliderValue.MaxValue = 12000;
	Config_Bio_Rifle.SecSpeed.SliderValue.bIntRange = true;
   Config_Bio_Rifle.SecSpeed.UpdateCaption();
	Config_Bio_Rifle.SecDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecDamage;
	Config_Bio_Rifle.SecDamage.SliderValue.NudgeValue = 1;
   Config_Bio_Rifle.SecDamage.SliderValue.MinValue = 5;
	Config_Bio_Rifle.SecDamage.SliderValue.MaxValue = 300;
	Config_Bio_Rifle.SecDamage.SliderValue.bIntRange = true;
   Config_Bio_Rifle.SecDamage.UpdateCaption();
	Config_Bio_Rifle.SecDamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecDamageRadius;
	Config_Bio_Rifle.SecDamageRadius.SliderValue.NudgeValue = 5;
   Config_Bio_Rifle.SecDamageRadius.SliderValue.MinValue = 0;
	Config_Bio_Rifle.SecDamageRadius.SliderValue.MaxValue = 150;
	Config_Bio_Rifle.SecDamageRadius.SliderValue.bIntRange = true;
   Config_Bio_Rifle.SecDamageRadius.UpdateCaption();

	// Enforcer Settings Initiate
	Config_Enforcer.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.bAmmoRegeneration);
	Config_Enforcer.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_Enforcer.bDoubles);
	Config_Enforcer.PriFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriFireInterval;
	Config_Enforcer.PriFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.PriFireInterval.NumericValue.MinValue = 0.01;
	Config_Enforcer.PriFireInterval.NumericValue.MaxValue = 2;
	Config_Enforcer.PriFireInterval.DecimalPlaces = 2;
	Config_Enforcer.SecFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecFireInterval;
	Config_Enforcer.SecFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.SecFireInterval.NumericValue.MinValue = 0.01;
	Config_Enforcer.SecFireInterval.NumericValue.MaxValue = 2;
	Config_Enforcer.SecFireInterval.DecimalPlaces = 2;
	Config_Enforcer.PriSpread.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriSpread;
	Config_Enforcer.PriSpread.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.PriSpread.NumericValue.MinValue = 0.00;
	Config_Enforcer.PriSpread.NumericValue.MaxValue = 0.1;
	Config_Enforcer.PriSpread.DecimalPlaces = 2;
	Config_Enforcer.SecSpread.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecSpread;
	Config_Enforcer.SecSpread.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.SecSpread.NumericValue.MinValue = 0.00;
	Config_Enforcer.SecSpread.NumericValue.MaxValue = 0.1;
	Config_Enforcer.SecSpread.DecimalPlaces = 2;
	Config_Enforcer.PriDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iPriDamage;
	Config_Enforcer.PriDamage.SliderValue.NudgeValue = 1;
   Config_Enforcer.PriDamage.SliderValue.MinValue = 10;
	Config_Enforcer.PriDamage.SliderValue.MaxValue = 300;
	Config_Enforcer.PriDamage.SliderValue.bIntRange = true;
   Config_Enforcer.PriDamage.UpdateCaption();
	Config_Enforcer.SecDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iSecDamage;
	Config_Enforcer.SecDamage.SliderValue.NudgeValue = 1;
   Config_Enforcer.SecDamage.SliderValue.MinValue = 5;
	Config_Enforcer.SecDamage.SliderValue.MaxValue = 200;
	Config_Enforcer.SecDamage.SliderValue.bIntRange = true;
   Config_Enforcer.SecDamage.UpdateCaption();
	Config_Enforcer.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iMomentum;
	Config_Enforcer.Momentum.SliderValue.NudgeValue = 1000;
   Config_Enforcer.Momentum.SliderValue.MinValue = 0;
	Config_Enforcer.Momentum.SliderValue.MaxValue = 200000;
	Config_Enforcer.Momentum.SliderValue.bIntRange = true;
   Config_Enforcer.Momentum.UpdateCaption();
	Config_Enforcer.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iAmmoCount;
	Config_Enforcer.AmmoCount.SliderValue.NudgeValue = 1;
   Config_Enforcer.AmmoCount.SliderValue.MinValue = 1;
	Config_Enforcer.AmmoCount.SliderValue.MaxValue = 500;
	Config_Enforcer.AmmoCount.SliderValue.bIntRange = true;
   Config_Enforcer.AmmoCount.UpdateCaption();
	Config_Enforcer.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iMaxAmmo;
	Config_Enforcer.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_Enforcer.MaxAmmo.SliderValue.MinValue = 1;
	Config_Enforcer.MaxAmmo.SliderValue.MaxValue = 500;
	Config_Enforcer.MaxAmmo.SliderValue.bIntRange = true;
   Config_Enforcer.MaxAmmo.UpdateCaption();
	Config_Enforcer.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iShotCost;
	Config_Enforcer.ShotCost.SliderValue.NudgeValue = 1;
   Config_Enforcer.ShotCost.SliderValue.MinValue = 0;
	Config_Enforcer.ShotCost.SliderValue.MaxValue = 1;
	Config_Enforcer.ShotCost.SliderValue.bIntRange = true;
   Config_Enforcer.ShotCost.UpdateCaption();
	Config_Enforcer.HelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iHelpRadius;
	Config_Enforcer.HelpRadius.SliderValue.NudgeValue = 1;
   Config_Enforcer.HelpRadius.SliderValue.MinValue = 0;
	Config_Enforcer.HelpRadius.SliderValue.MaxValue = 100;
	Config_Enforcer.HelpRadius.SliderValue.bIntRange = true;
   Config_Enforcer.HelpRadius.UpdateCaption();
	Config_Enforcer.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iAimError;
	Config_Enforcer.AimError.SliderValue.NudgeValue = 1;
   Config_Enforcer.AimError.SliderValue.MinValue = 0;
	Config_Enforcer.AimError.SliderValue.MaxValue = 1000;
	Config_Enforcer.AimError.SliderValue.bIntRange = true;
   Config_Enforcer.AimError.UpdateCaption();
	Config_Enforcer.AkimboTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAkimboTime;
	Config_Enforcer.AkimboTime.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.AkimboTime.NumericValue.MinValue = 0;
	Config_Enforcer.AkimboTime.NumericValue.MaxValue = 5;
	Config_Enforcer.AkimboTime.DecimalPlaces = 2;
	Config_Enforcer.BurstMax.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iBurstMax;
	Config_Enforcer.BurstMax.SliderValue.NudgeValue = 1;
   Config_Enforcer.BurstMax.SliderValue.MinValue = 1;
	Config_Enforcer.BurstMax.SliderValue.MaxValue = 3;
	Config_Enforcer.BurstMax.SliderValue.bIntRange = true;
   Config_Enforcer.BurstMax.UpdateCaption();
	Config_Enforcer.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAIRating;
	Config_Enforcer.AIRating.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.AIRating.NumericValue.MinValue = 0;
	Config_Enforcer.AIRating.NumericValue.MaxValue = 2.00;
	Config_Enforcer.AIRating.DecimalPlaces = 2;
	Config_Enforcer.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fDamageOverlayTime;
	Config_Enforcer.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_Enforcer.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_Enforcer.DamageOverlayTime.DecimalPlaces = 2;
	Config_Enforcer.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleDamageScaling;
	Config_Enforcer.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_Enforcer.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_Enforcer.VehicleDamageScaling.DecimalPlaces = 2;
	Config_Enforcer.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleMomentumScaling;
	Config_Enforcer.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_Enforcer.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_Enforcer.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_Enforcer.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fNodeDamageScaling;
	Config_Enforcer.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Enforcer.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_Enforcer.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_Enforcer.NodeDamageScaling.DecimalPlaces = 2;
	Config_Enforcer.BurstCoolDownTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.fBurstCoolDownTime;
	Config_Enforcer.BurstCoolDownTime.NumericValue.NudgeValue = 0.001;
   Config_Enforcer.BurstCoolDownTime.NumericValue.MinValue = 0.001;
	Config_Enforcer.BurstCoolDownTime.NumericValue.MaxValue = 2;
	Config_Enforcer.BurstCoolDownTime.DecimalPlaces = 3;
	Config_Enforcer.EnforcerRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Enforcer.iEnforcerRecoil;
	Config_Enforcer.EnforcerRecoil.SliderValue.NudgeValue = 500;
   Config_Enforcer.EnforcerRecoil.SliderValue.MinValue = 0;
	Config_Enforcer.EnforcerRecoil.SliderValue.MaxValue = 10000;
	Config_Enforcer.EnforcerRecoil.SliderValue.bIntRange = true;
   Config_Enforcer.EnforcerRecoil.UpdateCaption();

	// Flak Cannon Settings Initiate
	Config_FlakCannon.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.bAmmoRegeneration);
	Config_FlakCannon.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_FlakCannon.bDoubles);
	Config_FlakCannon.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fAIRating;
	Config_FlakCannon.AIRating.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.AIRating.NumericValue.MinValue = 0;
	Config_FlakCannon.AIRating.NumericValue.MaxValue = 2;
	Config_FlakCannon.AIRating.DecimalPlaces = 2;
	Config_FlakCannon.PriFireRate.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fPriFireRate;
	Config_FlakCannon.PriFireRate.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.PriFireRate.NumericValue.MinValue = 0.01;
	Config_FlakCannon.PriFireRate.NumericValue.MaxValue = 2;
	Config_FlakCannon.PriFireRate.DecimalPlaces = 2;
   Config_FlakCannon.SecFireRate.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSecFireRate;
	Config_FlakCannon.SecFireRate.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.SecFireRate.NumericValue.MinValue = 0.01;
	Config_FlakCannon.SecFireRate.NumericValue.MaxValue = 2;
	Config_FlakCannon.SecFireRate.DecimalPlaces = 2;
	Config_FlakCannon.Spread.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSpread;
	Config_FlakCannon.Spread.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.Spread.NumericValue.MinValue = 0.00;
	Config_FlakCannon.Spread.NumericValue.MaxValue = 0.1;
	Config_FlakCannon.Spread.DecimalPlaces = 2;
	Config_FlakCannon.MaxBonusTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fMaxBonusTime;
	Config_FlakCannon.MaxBonusTime.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.MaxBonusTime.NumericValue.MinValue = 0.01;
	Config_FlakCannon.MaxBonusTime.NumericValue.MaxValue = 1;
	Config_FlakCannon.MaxBonusTime.DecimalPlaces = 2;
	Config_FlakCannon.CustomGravityScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fCustomGravityScaling;
	Config_FlakCannon.CustomGravityScaling.NumericValue.NudgeValue = 0.25;
   Config_FlakCannon.CustomGravityScaling.NumericValue.MinValue = 0;
	Config_FlakCannon.CustomGravityScaling.NumericValue.MaxValue = 5;
	Config_FlakCannon.CustomGravityScaling.DecimalPlaces = 2;
	Config_FlakCannon.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fDamageOverlayTime;
	Config_FlakCannon.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_FlakCannon.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_FlakCannon.DamageOverlayTime.DecimalPlaces = 2;
	Config_FlakCannon.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fNodeDamageScaling;
	Config_FlakCannon.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_FlakCannon.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_FlakCannon.NodeDamageScaling.DecimalPlaces = 2;
	Config_FlakCannon.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleDamageScaling;
	Config_FlakCannon.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_FlakCannon.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_FlakCannon.VehicleDamageScaling.DecimalPlaces = 2;
	Config_FlakCannon.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleMomentumScaling;
	Config_FlakCannon.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_FlakCannon.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_FlakCannon.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_FlakCannon.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_FlakCannon.FlakRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iFlakRecoil;
	Config_FlakCannon.FlakRecoil.SliderValue.NudgeValue = 500;
   Config_FlakCannon.FlakRecoil.SliderValue.MinValue = 0;
	Config_FlakCannon.FlakRecoil.SliderValue.MaxValue = 10000;
	Config_FlakCannon.FlakRecoil.SliderValue.bIntRange = true;
   Config_FlakCannon.FlakRecoil.UpdateCaption();
	Config_FlakCannon.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iAmmoCount;
	Config_FlakCannon.AmmoCount.SliderValue.NudgeValue = 1;
   Config_FlakCannon.AmmoCount.SliderValue.MinValue = 1;
	Config_FlakCannon.AmmoCount.SliderValue.MaxValue = 500;
	Config_FlakCannon.AmmoCount.SliderValue.bIntRange = true;
   Config_FlakCannon.AmmoCount.UpdateCaption();
   Config_FlakCannon.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMaxAmmo;
	Config_FlakCannon.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_FlakCannon.MaxAmmo.SliderValue.MinValue = 1;
	Config_FlakCannon.MaxAmmo.SliderValue.MaxValue = 500;
	Config_FlakCannon.MaxAmmo.SliderValue.bIntRange = true;
   Config_FlakCannon.MaxAmmo.UpdateCaption();
	Config_FlakCannon.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iShotCost;
	Config_FlakCannon.ShotCost.SliderValue.NudgeValue = 1;
   Config_FlakCannon.ShotCost.SliderValue.MinValue = 0;
	Config_FlakCannon.ShotCost.SliderValue.MaxValue = 1;
	Config_FlakCannon.ShotCost.SliderValue.bIntRange = true;
   Config_FlakCannon.ShotCost.UpdateCaption();
   Config_FlakCannon.speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.ispeed;
	Config_FlakCannon.speed.SliderValue.NudgeValue = 50;
   Config_FlakCannon.speed.SliderValue.MinValue = 500;
	Config_FlakCannon.speed.SliderValue.MaxValue = 12000;
	Config_FlakCannon.speed.SliderValue.bIntRange = true;
   Config_FlakCannon.speed.UpdateCaption();
   Config_FlakCannon.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iDamage;
	Config_FlakCannon.Damage.SliderValue.NudgeValue = 1;
   Config_FlakCannon.Damage.SliderValue.MinValue = 5;
	Config_FlakCannon.Damage.SliderValue.MaxValue = 300;
	Config_FlakCannon.Damage.SliderValue.bIntRange = true;
   Config_FlakCannon.Damage.UpdateCaption();
   Config_FlakCannon.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iDamageRadius;
	Config_FlakCannon.DamageRadius.SliderValue.NudgeValue = 5;
   Config_FlakCannon.DamageRadius.SliderValue.MinValue = 0;
	Config_FlakCannon.DamageRadius.SliderValue.MaxValue = 100;
	Config_FlakCannon.DamageRadius.SliderValue.bIntRange = true;
   Config_FlakCannon.DamageRadius.UpdateCaption();
   Config_FlakCannon.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMomentum;
	Config_FlakCannon.Momentum.SliderValue.NudgeValue = 1000;
   Config_FlakCannon.Momentum.SliderValue.MinValue = 0;
	Config_FlakCannon.Momentum.SliderValue.MaxValue = 200000;
	Config_FlakCannon.Momentum.SliderValue.bIntRange = true;
   Config_FlakCannon.Momentum.UpdateCaption();
   Config_FlakCannon.ShardBounces.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iShardBounces;
	Config_FlakCannon.ShardBounces.SliderValue.NudgeValue = 1;
   Config_FlakCannon.ShardBounces.SliderValue.MinValue = 0;
	Config_FlakCannon.ShardBounces.SliderValue.MaxValue = 10;
	Config_FlakCannon.ShardBounces.SliderValue.bIntRange = true;
   Config_FlakCannon.ShardBounces.UpdateCaption();
   Config_FlakCannon.CenteredDamageBonus.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iCenteredDamageBonus;
	Config_FlakCannon.CenteredDamageBonus.SliderValue.NudgeValue = 1;
   Config_FlakCannon.CenteredDamageBonus.SliderValue.MinValue = 0;
	Config_FlakCannon.CenteredDamageBonus.SliderValue.MaxValue = 300;
	Config_FlakCannon.CenteredDamageBonus.SliderValue.bIntRange = true;
   Config_FlakCannon.CenteredDamageBonus.UpdateCaption();
   Config_FlakCannon.MainBounces.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMainBounces;
	Config_FlakCannon.MainBounces.SliderValue.NudgeValue = 1;
   Config_FlakCannon.MainBounces.SliderValue.MinValue = 0;
	Config_FlakCannon.MainBounces.SliderValue.MaxValue = 10;
	Config_FlakCannon.MainBounces.SliderValue.bIntRange = true;
   Config_FlakCannon.MainBounces.UpdateCaption();
   Config_FlakCannon.SecDamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecDamageRadius;
	Config_FlakCannon.SecDamageRadius.SliderValue.NudgeValue = 5;
   Config_FlakCannon.SecDamageRadius.SliderValue.MinValue = 0;
	Config_FlakCannon.SecDamageRadius.SliderValue.MaxValue = 600;
	Config_FlakCannon.SecDamageRadius.SliderValue.bIntRange = true;
   Config_FlakCannon.SecDamageRadius.UpdateCaption();
   Config_FlakCannon.SecDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecDamage;
	Config_FlakCannon.SecDamage.SliderValue.NudgeValue = 1;
   Config_FlakCannon.SecDamage.SliderValue.MinValue = 5;
	Config_FlakCannon.SecDamage.SliderValue.MaxValue = 300;
	Config_FlakCannon.SecDamage.SliderValue.bIntRange = true;
   Config_FlakCannon.SecDamage.UpdateCaption();
   Config_FlakCannon.Secspeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecspeed;
	Config_FlakCannon.Secspeed.SliderValue.NudgeValue = 50;
   Config_FlakCannon.Secspeed.SliderValue.MinValue = 500;
	Config_FlakCannon.Secspeed.SliderValue.MaxValue = 12000;
	Config_FlakCannon.Secspeed.SliderValue.bIntRange = true;
   Config_FlakCannon.Secspeed.UpdateCaption();
   Config_FlakCannon.TossZ.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iTossZ;
	Config_FlakCannon.TossZ.SliderValue.NudgeValue = 20;
   Config_FlakCannon.TossZ.SliderValue.MinValue = 0;
	Config_FlakCannon.TossZ.SliderValue.MaxValue = 800;
	Config_FlakCannon.TossZ.SliderValue.bIntRange = true;
   Config_FlakCannon.TossZ.UpdateCaption();

	// Impact Hammer Settings Initiate
	Config_ImpactHammer.bUseHammer.SetValue(class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.bUseHammer);
	Config_ImpactHammer.MinDmg.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinDmg;
	Config_ImpactHammer.MinDmg.SliderValue.NudgeValue = 5;
   Config_ImpactHammer.MinDmg.SliderValue.MinValue = 10;
	Config_ImpactHammer.MinDmg.SliderValue.MaxValue = 50;
	Config_ImpactHammer.MinDmg.SliderValue.bIntRange = true;
   Config_ImpactHammer.MinDmg.UpdateCaption();
	Config_ImpactHammer.MaxDmg.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxDmg;
	Config_ImpactHammer.MaxDmg.SliderValue.NudgeValue = 5;
   Config_ImpactHammer.MaxDmg.SliderValue.MinValue = 50;
	Config_ImpactHammer.MaxDmg.SliderValue.MaxValue = 300;
	Config_ImpactHammer.MaxDmg.SliderValue.bIntRange = true;
   Config_ImpactHammer.MaxDmg.UpdateCaption();
	Config_ImpactHammer.MinForce.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinForce;
	Config_ImpactHammer.MinForce.SliderValue.NudgeValue = 10000;
	Config_ImpactHammer.MinForce.SliderValue.MinValue = 20000;
	Config_ImpactHammer.MinForce.SliderValue.MaxValue = 50000;
	Config_ImpactHammer.MinForce.SliderValue.bIntRange = true;
   Config_ImpactHammer.MinForce.UpdateCaption();
	Config_ImpactHammer.MaxForce.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxForce;
	Config_ImpactHammer.MaxForce.SliderValue.NudgeValue = 10000;
	Config_ImpactHammer.MaxForce.SliderValue.MinValue = 50000;
	Config_ImpactHammer.MaxForce.SliderValue.MaxValue = 200000;
	Config_ImpactHammer.MaxForce.SliderValue.bIntRange = true;
   Config_ImpactHammer.MaxForce.UpdateCaption();
	Config_ImpactHammer.MinSelfDmg.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinSelfDmg;
	Config_ImpactHammer.MinSelfDmg.SliderValue.NudgeValue = 1;
   Config_ImpactHammer.MinSelfDmg.SliderValue.MinValue = 0;
	Config_ImpactHammer.MinSelfDmg.SliderValue.MaxValue = 25;
	Config_ImpactHammer.MinSelfDmg.SliderValue.bIntRange = true;
   Config_ImpactHammer.MinSelfDmg.UpdateCaption();
	Config_ImpactHammer.EMPDmg.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fEMPDmg;
	Config_ImpactHammer.EMPDmg.SliderValue.NudgeValue = 25;
   Config_ImpactHammer.EMPDmg.SliderValue.MinValue = 50;
	Config_ImpactHammer.EMPDmg.SliderValue.MaxValue = 300;
	Config_ImpactHammer.EMPDmg.SliderValue.bIntRange = true;
   Config_ImpactHammer.EMPDmg.UpdateCaption();
	Config_ImpactHammer.SelfDmgScale.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fSelfDmgScale;
	Config_ImpactHammer.SelfDmgScale.SliderValue.NudgeValue = 1;
   Config_ImpactHammer.SelfDmgScale.SliderValue.MinValue = 0;
	Config_ImpactHammer.SelfDmgScale.SliderValue.MaxValue = 2;
	Config_ImpactHammer.SelfDmgScale.SliderValue.bIntRange = true;
   Config_ImpactHammer.SelfDmgScale.UpdateCaption();
	Config_ImpactHammer.SelfForceScale.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fSelfForceScale;
	Config_ImpactHammer.SelfForceScale.SliderValue.NudgeValue = 1;
   Config_ImpactHammer.SelfForceScale.SliderValue.MinValue = 0;
	Config_ImpactHammer.SelfForceScale.SliderValue.MaxValue = 5;
	Config_ImpactHammer.SelfForceScale.SliderValue.bIntRange = true;
   Config_ImpactHammer.SelfForceScale.UpdateCaption();
	Config_ImpactHammer.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fAIRating;
	Config_ImpactHammer.AIRating.NumericValue.NudgeValue = 0.01;
   Config_ImpactHammer.AIRating.NumericValue.MinValue = 0;
	Config_ImpactHammer.AIRating.NumericValue.MaxValue = 2.00;
	Config_ImpactHammer.AIRating.DecimalPlaces = 2;
	Config_ImpactHammer.MaxChargeTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxChargeTime;
	Config_ImpactHammer.MaxChargeTime.NumericValue.NudgeValue = 0.01;
   Config_ImpactHammer.MaxChargeTime.NumericValue.MinValue = 0.5;
	Config_ImpactHammer.MaxChargeTime.NumericValue.MaxValue = 2;
	Config_ImpactHammer.MaxChargeTime.DecimalPlaces = 2;
	Config_ImpactHammer.MinChargeTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinChargeTime;
	Config_ImpactHammer.MinChargeTime.NumericValue.NudgeValue = 0.01;
   Config_ImpactHammer.MinChargeTime.NumericValue.MinValue = 0.1;
	Config_ImpactHammer.MinChargeTime.NumericValue.MaxValue = 1;
	Config_ImpactHammer.MinChargeTime.DecimalPlaces = 2;

	// Link Gun Settings Initiate
	Config_LinkGun.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.bAmmoRegeneration);
	Config_LinkGun.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_LinkGun.bDoubles);
	Config_LinkGun.PriFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fPriFireInterval;
	Config_LinkGun.PriFireInterval.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.PriFireInterval.NumericValue.MinValue = 0.01;
	Config_LinkGun.PriFireInterval.NumericValue.MaxValue = 2;
	Config_LinkGun.PriFireInterval.DecimalPlaces = 2;
	Config_LinkGun.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fNodeDamageScaling;
	Config_LinkGun.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_LinkGun.NodeDamageScaling.NumericValue.MaxValue = 2;
	Config_LinkGun.NodeDamageScaling.DecimalPlaces = 2;
	Config_LinkGun.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleDamageScaling;
	Config_LinkGun.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_LinkGun.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_LinkGun.VehicleDamageScaling.DecimalPlaces = 2;
	Config_LinkGun.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleMomentumScaling;
	Config_LinkGun.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_LinkGun.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_LinkGun.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_LinkGun.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime;
	Config_LinkGun.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_LinkGun.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_LinkGun.DamageOverlayTime.DecimalPlaces = 2;
	Config_LinkGun.LinkFlexibility.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fLinkFlexibility;
	Config_LinkGun.LinkFlexibility.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.LinkFlexibility.NumericValue.MinValue = 0;
	Config_LinkGun.LinkFlexibility.NumericValue.MaxValue = 1;
	Config_LinkGun.LinkFlexibility.DecimalPlaces = 2;
	Config_LinkGun.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.fAIRating;
	Config_LinkGun.AIRating.NumericValue.NudgeValue = 0.01;
   Config_LinkGun.AIRating.NumericValue.MinValue = 0;
	Config_LinkGun.AIRating.NumericValue.MaxValue = 2.00;
	Config_LinkGun.AIRating.DecimalPlaces = 2;
	Config_LinkGun.PriDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iPriDamage;
	Config_LinkGun.PriDamage.SliderValue.NudgeValue = 1;
   Config_LinkGun.PriDamage.SliderValue.MinValue = 5;
	Config_LinkGun.PriDamage.SliderValue.MaxValue = 300;
	Config_LinkGun.PriDamage.SliderValue.bIntRange = true;
   Config_LinkGun.PriDamage.UpdateCaption();
	Config_LinkGun.SecDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iSecDamage;
	Config_LinkGun.SecDamage.SliderValue.NudgeValue = 1;
   Config_LinkGun.SecDamage.SliderValue.MinValue = 5;
	Config_LinkGun.SecDamage.SliderValue.MaxValue = 300;
	Config_LinkGun.SecDamage.SliderValue.bIntRange = true;
   Config_LinkGun.SecDamage.UpdateCaption();
	Config_LinkGun.ProJSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iProJSpeed;
	Config_LinkGun.ProJSpeed.SliderValue.NudgeValue = 50;
   Config_LinkGun.ProJSpeed.SliderValue.MinValue = 500;
	Config_LinkGun.ProJSpeed.SliderValue.MaxValue = 12000;
	Config_LinkGun.ProJSpeed.SliderValue.bIntRange = true;
   Config_LinkGun.ProJSpeed.UpdateCaption();
	Config_LinkGun.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iMomentum;
	Config_LinkGun.Momentum.SliderValue.NudgeValue = 1000;
   Config_LinkGun.Momentum.SliderValue.MinValue = 0;
	Config_LinkGun.Momentum.SliderValue.MaxValue = 200000;
	Config_LinkGun.Momentum.SliderValue.bIntRange = true;
   Config_LinkGun.Momentum.UpdateCaption();
	Config_LinkGun.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iAmmoCount;
	Config_LinkGun.AmmoCount.SliderValue.NudgeValue = 1;
   Config_LinkGun.AmmoCount.SliderValue.MinValue = 1;
	Config_LinkGun.AmmoCount.SliderValue.MaxValue = 500;
	Config_LinkGun.AmmoCount.SliderValue.bIntRange = true;
   Config_LinkGun.AmmoCount.UpdateCaption();
	Config_LinkGun.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iMaxAmmo;
	Config_LinkGun.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_LinkGun.MaxAmmo.SliderValue.MinValue = 1;
	Config_LinkGun.MaxAmmo.SliderValue.MaxValue = 500;
	Config_LinkGun.MaxAmmo.SliderValue.bIntRange = true;
   Config_LinkGun.MaxAmmo.UpdateCaption();
	Config_LinkGun.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iDamageRadius;
	Config_LinkGun.DamageRadius.SliderValue.NudgeValue = 5;
   Config_LinkGun.DamageRadius.SliderValue.MinValue = 0;
	Config_LinkGun.DamageRadius.SliderValue.MaxValue = 200;
	Config_LinkGun.DamageRadius.SliderValue.bIntRange = true;
   Config_LinkGun.DamageRadius.UpdateCaption();
	Config_LinkGun.BeamAmmoSec.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iBeamAmmoSec;
	Config_LinkGun.BeamAmmoSec.SliderValue.NudgeValue = 1;
   Config_LinkGun.BeamAmmoSec.SliderValue.MinValue = 0;
	Config_LinkGun.BeamAmmoSec.SliderValue.MaxValue = 100;
	Config_LinkGun.BeamAmmoSec.SliderValue.bIntRange = true;
   Config_LinkGun.BeamAmmoSec.UpdateCaption();
	Config_LinkGun.WeaponLinkDistance.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iWeaponLinkDistance;
	Config_LinkGun.WeaponLinkDistance.SliderValue.NudgeValue = 50;
   Config_LinkGun.WeaponLinkDistance.SliderValue.MinValue = 0;
	Config_LinkGun.WeaponLinkDistance.SliderValue.MaxValue = 550;
	Config_LinkGun.WeaponLinkDistance.SliderValue.bIntRange = true;
   Config_LinkGun.WeaponLinkDistance.UpdateCaption();
	Config_LinkGun.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iShotCost;
	Config_LinkGun.ShotCost.SliderValue.NudgeValue = 1;
   Config_LinkGun.ShotCost.SliderValue.MinValue = 0;
	Config_LinkGun.ShotCost.SliderValue.MaxValue = 1;
	Config_LinkGun.ShotCost.SliderValue.bIntRange = true;
   Config_LinkGun.ShotCost.UpdateCaption();
	Config_LinkGun.BeamRange.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iBeamRange;
	Config_LinkGun.BeamRange.SliderValue.NudgeValue = 128;
   Config_LinkGun.BeamRange.SliderValue.MinValue = 512;
	Config_LinkGun.BeamRange.SliderValue.MaxValue = 10000;
	Config_LinkGun.BeamRange.SliderValue.bIntRange = true;
   Config_LinkGun.BeamRange.UpdateCaption();
   Config_LinkGun.LucyRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_LinkGun.iLucyRecoil;
	Config_LinkGun.LucyRecoil.SliderValue.NudgeValue = 500;
   Config_LinkGun.LucyRecoil.SliderValue.MinValue = 0;
	Config_LinkGun.LucyRecoil.SliderValue.MaxValue = 10000;
	Config_LinkGun.LucyRecoil.SliderValue.bIntRange = true;
   Config_LinkGun.LucyRecoil.UpdateCaption();

	// Rocket Launcher Settings Initiate
	Config_RL_BFG.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.bAmmoRegeneration);
	Config_RL_BFG.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_RL_BFG.bDoubles);
	Config_RL_BFG.PriFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fPriFireInterval;
	Config_RL_BFG.PriFireInterval.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.PriFireInterval.NumericValue.MinValue = 0.01;
	Config_RL_BFG.PriFireInterval.NumericValue.MaxValue = 2;
	Config_RL_BFG.PriFireInterval.DecimalPlaces = 2;
	Config_RL_BFG.SecFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fSecFireInterval;
	Config_RL_BFG.SecFireInterval.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.SecFireInterval.NumericValue.MinValue = 0.01;
	Config_RL_BFG.SecFireInterval.NumericValue.MaxValue = 2;
	Config_RL_BFG.SecFireInterval.DecimalPlaces = 2;
	Config_RL_BFG.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAIRating;
	Config_RL_BFG.AIRating.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.AIRating.NumericValue.MinValue = 0;
	Config_RL_BFG.AIRating.NumericValue.MaxValue = 2.00;
	Config_RL_BFG.AIRating.DecimalPlaces = 2;
	Config_RL_BFG.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fDamageOverlayTime;
	Config_RL_BFG.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_RL_BFG.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_RL_BFG.DamageOverlayTime.DecimalPlaces = 2;
	Config_RL_BFG.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fNodeDamageScaling;
	Config_RL_BFG.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_RL_BFG.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_RL_BFG.NodeDamageScaling.DecimalPlaces = 2;
	Config_RL_BFG.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleDamageScaling;
	Config_RL_BFG.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_RL_BFG.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_RL_BFG.VehicleDamageScaling.DecimalPlaces = 2;
	Config_RL_BFG.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleMomentumScaling;
	Config_RL_BFG.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_RL_BFG.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_RL_BFG.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_RL_BFG.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iDamage;
	Config_RL_BFG.Damage.SliderValue.NudgeValue = 5;
   Config_RL_BFG.Damage.SliderValue.MinValue = 10;
	Config_RL_BFG.Damage.SliderValue.MaxValue = 300;
	Config_RL_BFG.Damage.SliderValue.bIntRange = true;
   Config_RL_BFG.Damage.UpdateCaption();
	Config_RL_BFG.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iMomentum;
	Config_RL_BFG.Momentum.SliderValue.NudgeValue = 1000;
   Config_RL_BFG.Momentum.SliderValue.MinValue = 0;
	Config_RL_BFG.Momentum.SliderValue.MaxValue = 200000;
	Config_RL_BFG.Momentum.SliderValue.bIntRange = true;
   Config_RL_BFG.Momentum.UpdateCaption();
	Config_RL_BFG.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iAmmoCount;
	Config_RL_BFG.AmmoCount.SliderValue.NudgeValue = 1;
   Config_RL_BFG.AmmoCount.SliderValue.MinValue = 1;
	Config_RL_BFG.AmmoCount.SliderValue.MaxValue = 500;
	Config_RL_BFG.AmmoCount.SliderValue.bIntRange = true;
   Config_RL_BFG.AmmoCount.UpdateCaption();
	Config_RL_BFG.FlockStiffness.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockStiffness;
	Config_RL_BFG.FlockStiffness.SliderValue.NudgeValue = 1;
   Config_RL_BFG.FlockStiffness.SliderValue.MinValue = -100;
	Config_RL_BFG.FlockStiffness.SliderValue.MaxValue = 100;
	Config_RL_BFG.FlockStiffness.SliderValue.bIntRange = true;
   Config_RL_BFG.FlockStiffness.UpdateCaption();
	Config_RL_BFG.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iMaxAmmo;
	Config_RL_BFG.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_RL_BFG.MaxAmmo.SliderValue.MinValue = 1;
	Config_RL_BFG.MaxAmmo.SliderValue.MaxValue = 500;
	Config_RL_BFG.MaxAmmo.SliderValue.bIntRange = true;
   Config_RL_BFG.MaxAmmo.UpdateCaption();
	Config_RL_BFG.HelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iHelpRadius;
	Config_RL_BFG.HelpRadius.SliderValue.NudgeValue = 1;
   Config_RL_BFG.HelpRadius.SliderValue.MinValue = 0;
	Config_RL_BFG.HelpRadius.SliderValue.MaxValue = 100;
	Config_RL_BFG.HelpRadius.SliderValue.bIntRange = true;
   Config_RL_BFG.HelpRadius.UpdateCaption();
	Config_RL_BFG.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iAimError;
	Config_RL_BFG.AimError.SliderValue.NudgeValue = 1;
   Config_RL_BFG.AimError.SliderValue.MinValue = 0;
	Config_RL_BFG.AimError.SliderValue.MaxValue = 1000;
	Config_RL_BFG.AimError.SliderValue.bIntRange = true;
   Config_RL_BFG.AimError.UpdateCaption();
	Config_RL_BFG.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iShotCost;
	Config_RL_BFG.ShotCost.SliderValue.NudgeValue = 1;
   Config_RL_BFG.ShotCost.SliderValue.MinValue = 0;
	Config_RL_BFG.ShotCost.SliderValue.MaxValue = 1;
	Config_RL_BFG.ShotCost.SliderValue.bIntRange = true;
   Config_RL_BFG.ShotCost.UpdateCaption();
	Config_RL_BFG.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iSpeed;
	Config_RL_BFG.Speed.SliderValue.NudgeValue = 50;
   Config_RL_BFG.Speed.SliderValue.MinValue = 500;
	Config_RL_BFG.Speed.SliderValue.MaxValue = 12000;
	Config_RL_BFG.Speed.SliderValue.bIntRange = true;
   Config_RL_BFG.Speed.UpdateCaption();
	Config_RL_BFG.GrenadeSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iGrenadeSpeed;
	Config_RL_BFG.GrenadeSpeed.SliderValue.NudgeValue = 50;
   Config_RL_BFG.GrenadeSpeed.SliderValue.MinValue = 500;
	Config_RL_BFG.GrenadeSpeed.SliderValue.MaxValue = 12000;
	Config_RL_BFG.GrenadeSpeed.SliderValue.bIntRange = true;
   Config_RL_BFG.GrenadeSpeed.UpdateCaption();
	Config_RL_BFG.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iDamageRadius;
	Config_RL_BFG.DamageRadius.SliderValue.NudgeValue = 5;
   Config_RL_BFG.DamageRadius.SliderValue.MinValue = 0;
	Config_RL_BFG.DamageRadius.SliderValue.MaxValue = 300;
	Config_RL_BFG.DamageRadius.SliderValue.bIntRange = true;
   Config_RL_BFG.DamageRadius.UpdateCaption();
	Config_RL_BFG.LockAcquireTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAcquireTime;
	Config_RL_BFG.LockAcquireTime.NumericValue.NudgeValue = 0.01;
   Config_RL_BFG.LockAcquireTime.NumericValue.MinValue = 0;
	Config_RL_BFG.LockAcquireTime.NumericValue.MaxValue = 5;
	Config_RL_BFG.LockAcquireTime.DecimalPlaces = 2;
	Config_RL_BFG.spreaddist.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.ispreaddist;
	Config_RL_BFG.spreaddist.SliderValue.NudgeValue = 1;
   Config_RL_BFG.spreaddist.SliderValue.MinValue = 0;
	Config_RL_BFG.spreaddist.SliderValue.MaxValue = 512;
	Config_RL_BFG.spreaddist.SliderValue.bIntRange = true;
   Config_RL_BFG.spreaddist.UpdateCaption();
	Config_RL_BFG.grenadespreaddist.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.igrenadespreaddist;
	Config_RL_BFG.grenadespreaddist.SliderValue.NudgeValue = 1;
   Config_RL_BFG.grenadespreaddist.SliderValue.MinValue = 0;
	Config_RL_BFG.grenadespreaddist.SliderValue.MaxValue = 512;
	Config_RL_BFG.grenadespreaddist.SliderValue.bIntRange = true;
   Config_RL_BFG.grenadespreaddist.UpdateCaption();
	Config_RL_BFG.LockRange.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iLockRange;
	Config_RL_BFG.LockRange.SliderValue.NudgeValue = 500;
   Config_RL_BFG.LockRange.SliderValue.MinValue = 500;
	Config_RL_BFG.LockRange.SliderValue.MaxValue = 20000;
	Config_RL_BFG.LockRange.SliderValue.bIntRange = true;
   Config_RL_BFG.LockRange.UpdateCaption();
	Config_RL_BFG.FlockRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockRadius;
	Config_RL_BFG.FlockRadius.SliderValue.NudgeValue = 1;
   Config_RL_BFG.FlockRadius.SliderValue.MinValue = 0;
	Config_RL_BFG.FlockRadius.SliderValue.MaxValue = 100;
	Config_RL_BFG.FlockRadius.SliderValue.bIntRange = true;
   Config_RL_BFG.FlockRadius.UpdateCaption();
	Config_RL_BFG.RocketRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iRocketRecoil;
	Config_RL_BFG.RocketRecoil.SliderValue.NudgeValue = 500;
   Config_RL_BFG.RocketRecoil.SliderValue.MinValue = 0;
	Config_RL_BFG.RocketRecoil.SliderValue.MaxValue = 10000;
	Config_RL_BFG.RocketRecoil.SliderValue.bIntRange = true;
   Config_RL_BFG.RocketRecoil.UpdateCaption();
	Config_RL_BFG.FlockCurlForce.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockCurlForce;
	Config_RL_BFG.FlockCurlForce.SliderValue.NudgeValue = 5;
   Config_RL_BFG.FlockCurlForce.SliderValue.MinValue = 0;
	Config_RL_BFG.FlockCurlForce.SliderValue.MaxValue = 900;
	Config_RL_BFG.FlockCurlForce.SliderValue.bIntRange = true;
   Config_RL_BFG.FlockCurlForce.UpdateCaption();

	// Shock Rifle Settings Initiate
	Config_Shock_Rifle.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bAmmoRegeneration);
	Config_Shock_Rifle.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bDoubles);
//	Config_Shock_Rifle.bUseCombo.SetValue(class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bUseCombo);
	Config_Shock_Rifle.FireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fFireInterval;
	Config_Shock_Rifle.FireInterval.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.FireInterval.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.FireInterval.NumericValue.MaxValue = 2;
	Config_Shock_Rifle.FireInterval.DecimalPlaces = 2;
	Config_Shock_Rifle.SecFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSecFireInterval;
	Config_Shock_Rifle.SecFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.SecFireInterval.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.SecFireInterval.NumericValue.MaxValue = 2;
	Config_Shock_Rifle.SecFireInterval.DecimalPlaces = 2;
	Config_Shock_Rifle.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fAIRating;
	Config_Shock_Rifle.AIRating.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.AIRating.NumericValue.MinValue = 0;
	Config_Shock_Rifle.AIRating.NumericValue.MaxValue = 2.00;
	Config_Shock_Rifle.AIRating.DecimalPlaces = 2;
	Config_Shock_Rifle.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fDamageOverlayTime;
	Config_Shock_Rifle.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_Shock_Rifle.DamageOverlayTime.NumericValue.MaxValue = 3.00;
	Config_Shock_Rifle.DamageOverlayTime.DecimalPlaces = 2;
	Config_Shock_Rifle.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fNodeDamageScaling;
	Config_Shock_Rifle.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.NodeDamageScaling.NumericValue.MaxValue = 5.00;
	Config_Shock_Rifle.NodeDamageScaling.DecimalPlaces = 2;
	Config_Shock_Rifle.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleDamageScaling;
	Config_Shock_Rifle.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.VehicleDamageScaling.NumericValue.MaxValue = 5.00;
	Config_Shock_Rifle.VehicleDamageScaling.DecimalPlaces = 2;
	Config_Shock_Rifle.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleMomentumScaling;
	Config_Shock_Rifle.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.VehicleMomentumScaling.NumericValue.MaxValue = 5.00;
	Config_Shock_Rifle.VehicleMomentumScaling.DecimalPlaces = 2;
//	Config_Shock_Rifle.ComboDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboDamage;
//	Config_Shock_Rifle.ComboDamage.SliderValue.NudgeValue = 5;
//   Config_Shock_Rifle.ComboDamage.SliderValue.MinValue = 10;
//	Config_Shock_Rifle.ComboDamage.SliderValue.MaxValue = 500;
//	Config_Shock_Rifle.ComboDamage.SliderValue.bIntRange = true;
//   Config_Shock_Rifle.ComboDamage.UpdateCaption();
	Config_Shock_Rifle.DamageImpulse.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamageImpulse;
	Config_Shock_Rifle.DamageImpulse.SliderValue.NudgeValue = 20;
   Config_Shock_Rifle.DamageImpulse.SliderValue.MinValue = 0;
	Config_Shock_Rifle.DamageImpulse.SliderValue.MaxValue = 10000;
	Config_Shock_Rifle.DamageImpulse.SliderValue.bIntRange = true;
  Config_Shock_Rifle.DamageImpulse.UpdateCaption();
	Config_Shock_Rifle.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamage;
	Config_Shock_Rifle.Damage.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.Damage.SliderValue.MinValue = 10;
	Config_Shock_Rifle.Damage.SliderValue.MaxValue = 300;
	Config_Shock_Rifle.Damage.SliderValue.bIntRange = true;
   Config_Shock_Rifle.Damage.UpdateCaption();
	Config_Shock_Rifle.InstaDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iInstaDamage;
	Config_Shock_Rifle.InstaDamage.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.InstaDamage.SliderValue.MinValue = 10;
	Config_Shock_Rifle.InstaDamage.SliderValue.MaxValue = 300;
	Config_Shock_Rifle.InstaDamage.SliderValue.bIntRange = true;
   Config_Shock_Rifle.Damage.UpdateCaption();
	Config_Shock_Rifle.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iMomentum;
	Config_Shock_Rifle.Momentum.SliderValue.NudgeValue = 1000;
   Config_Shock_Rifle.Momentum.SliderValue.MinValue = 0;
	Config_Shock_Rifle.Momentum.SliderValue.MaxValue = 200000;
	Config_Shock_Rifle.Momentum.SliderValue.bIntRange = true;
   Config_Shock_Rifle.Momentum.UpdateCaption();
	Config_Shock_Rifle.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iAmmoCount;
	Config_Shock_Rifle.AmmoCount.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.AmmoCount.SliderValue.MinValue = 1;
	Config_Shock_Rifle.AmmoCount.SliderValue.MaxValue = 500;
	Config_Shock_Rifle.AmmoCount.SliderValue.bIntRange = true;
   Config_Shock_Rifle.AmmoCount.UpdateCaption();
	Config_Shock_Rifle.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iMaxAmmo;
	Config_Shock_Rifle.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.MaxAmmo.SliderValue.MinValue = 1;
	Config_Shock_Rifle.MaxAmmo.SliderValue.MaxValue = 500;
	Config_Shock_Rifle.MaxAmmo.SliderValue.bIntRange = true;
   Config_Shock_Rifle.MaxAmmo.UpdateCaption();
	Config_Shock_Rifle.HeadShotDmgMult.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fHeadShotDmgMult;
	Config_Shock_Rifle.HeadShotDmgMult.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.HeadShotDmgMult.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.HeadShotDmgMult.NumericValue.MaxValue = 10;
	Config_Shock_Rifle.HeadShotDmgMult.DecimalPlaces = 2;
	Config_Shock_Rifle.SlowHeadshotScale.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSlowHeadshotScale;
	Config_Shock_Rifle.SlowHeadshotScale.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.SlowHeadshotScale.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.SlowHeadshotScale.NumericValue.MaxValue = 10;
	Config_Shock_Rifle.SlowHeadshotScale.DecimalPlaces = 2;
	Config_Shock_Rifle.RunningHeadshotScale.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fRunningHeadshotScale;
	Config_Shock_Rifle.RunningHeadshotScale.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.RunningHeadshotScale.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.RunningHeadshotScale.NumericValue.MaxValue = 10;
	Config_Shock_Rifle.RunningHeadshotScale.DecimalPlaces = 2;
//	Config_Shock_Rifle.PriHelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iPriHelpRadius;
//	Config_Shock_Rifle.PriHelpRadius.SliderValue.NudgeValue = 1;
//   Config_Shock_Rifle.PriHelpRadius.SliderValue.MinValue = 0;
//	Config_Shock_Rifle.PriHelpRadius.SliderValue.MaxValue = 100;
//	Config_Shock_Rifle.PriHelpRadius.SliderValue.bIntRange = true;
//   Config_Shock_Rifle.PriHelpRadius.UpdateCaption();
//	Config_Shock_Rifle.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iAimError;
//	Config_Shock_Rifle.AimError.SliderValue.NudgeValue = 1;
//   Config_Shock_Rifle.AimError.SliderValue.MinValue = 0;
//	Config_Shock_Rifle.AimError.SliderValue.MaxValue = 1000;
//	Config_Shock_Rifle.AimError.SliderValue.bIntRange = true;
//   Config_Shock_Rifle.AimError.UpdateCaption();
	Config_Shock_Rifle.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iShotCost;
	Config_Shock_Rifle.ShotCost.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.ShotCost.SliderValue.MinValue = 0;
	Config_Shock_Rifle.ShotCost.SliderValue.MaxValue = 1;
	Config_Shock_Rifle.ShotCost.SliderValue.bIntRange = true;
   Config_Shock_Rifle.ShotCost.UpdateCaption();
	Config_Shock_Rifle.ComboAmmoCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboAmmoCost;
	Config_Shock_Rifle.ComboAmmoCost.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.ComboAmmoCost.SliderValue.MinValue = 0;
	Config_Shock_Rifle.ComboAmmoCost.SliderValue.MaxValue = 5;
	Config_Shock_Rifle.ComboAmmoCost.SliderValue.bIntRange = true;
   Config_Shock_Rifle.ComboAmmoCost.UpdateCaption();
	Config_Shock_Rifle.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iSpeed;
	Config_Shock_Rifle.Speed.SliderValue.NudgeValue = 50;
   Config_Shock_Rifle.Speed.SliderValue.MinValue = 500;
	Config_Shock_Rifle.Speed.SliderValue.MaxValue = 12000;
	Config_Shock_Rifle.Speed.SliderValue.bIntRange = true;
   Config_Shock_Rifle.Speed.UpdateCaption();
	Config_Shock_Rifle.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamageRadius;
	Config_Shock_Rifle.DamageRadius.SliderValue.NudgeValue = 5;
   Config_Shock_Rifle.DamageRadius.SliderValue.MinValue = 0;
	Config_Shock_Rifle.DamageRadius.SliderValue.MaxValue = 300;
	Config_Shock_Rifle.DamageRadius.SliderValue.bIntRange = true;
   Config_Shock_Rifle.DamageRadius.UpdateCaption();
//	Config_Shock_Rifle.ComboDamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboDamageRadius;
//	Config_Shock_Rifle.ComboDamageRadius.SliderValue.NudgeValue = 5;
//   Config_Shock_Rifle.ComboDamageRadius.SliderValue.MinValue = 0;
//	Config_Shock_Rifle.ComboDamageRadius.SliderValue.MaxValue = 300;
//	Config_Shock_Rifle.ComboDamageRadius.SliderValue.bIntRange = true;
//   Config_Shock_Rifle.ComboDamageRadius.UpdateCaption();
	Config_Shock_Rifle.ImpulseRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iImpulseRadius;
	Config_Shock_Rifle.ImpulseRadius.SliderValue.NudgeValue = 100;
   Config_Shock_Rifle.ImpulseRadius.SliderValue.MinValue = 100;
	Config_Shock_Rifle.ImpulseRadius.SliderValue.MaxValue = 1000;
	Config_Shock_Rifle.ImpulseRadius.SliderValue.bIntRange = true;
   Config_Shock_Rifle.ImpulseRadius.UpdateCaption();
	Config_Shock_Rifle.InstaRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iInstaRecoil;
	Config_Shock_Rifle.InstaRecoil.SliderValue.NudgeValue = 500;
   Config_Shock_Rifle.InstaRecoil.SliderValue.MinValue = 0;
	Config_Shock_Rifle.InstaRecoil.SliderValue.MaxValue = 10000;
	Config_Shock_Rifle.InstaRecoil.SliderValue.bIntRange = true;
   Config_Shock_Rifle.InstaRecoil.UpdateCaption();
   Config_Shock_Rifle.VortexRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iVortexRadius;
	Config_Shock_Rifle.VortexRadius.SliderValue.NudgeValue = 1;
   Config_Shock_Rifle.VortexRadius.SliderValue.MinValue = 0;
	Config_Shock_Rifle.VortexRadius.SliderValue.MaxValue = 800;
	Config_Shock_Rifle.VortexRadius.SliderValue.bIntRange = true;
   Config_Shock_Rifle.VortexRadius.UpdateCaption();
   Config_Shock_Rifle.VortexForcePerSecond.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iVortexForcePerSecond;
	Config_Shock_Rifle.VortexForcePerSecond.SliderValue.NudgeValue = 10;
   Config_Shock_Rifle.VortexForcePerSecond.SliderValue.MinValue = 0;
	Config_Shock_Rifle.VortexForcePerSecond.SliderValue.MaxValue = 500;
	Config_Shock_Rifle.VortexForcePerSecond.SliderValue.bIntRange = true;
   Config_Shock_Rifle.VortexForcePerSecond.UpdateCaption();
   Config_Shock_Rifle.VortexDuration.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVortexDuration;
	Config_Shock_Rifle.VortexDuration.NumericValue.NudgeValue = 0.01;
   Config_Shock_Rifle.VortexDuration.NumericValue.MinValue = 0.01;
	Config_Shock_Rifle.VortexDuration.NumericValue.MaxValue = 5;
	Config_Shock_Rifle.VortexDuration.DecimalPlaces = 2;


	// Sniper Rifle Settings Initiate
	Config_Sniper_Rifle.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.bAmmoRegeneration);
	Config_Sniper_Rifle.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.bDoubles);
	Config_Sniper_Rifle.FireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fFireInterval;
	Config_Sniper_Rifle.FireInterval.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.FireInterval.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.FireInterval.NumericValue.MaxValue = 2;
	Config_Sniper_Rifle.FireInterval.DecimalPlaces = 2;
	Config_Sniper_Rifle.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fAIRating;
	Config_Sniper_Rifle.AIRating.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.AIRating.NumericValue.MinValue = 0;
	Config_Sniper_Rifle.AIRating.NumericValue.MaxValue = 2.00;
	Config_Sniper_Rifle.AIRating.DecimalPlaces = 2;
	Config_Sniper_Rifle.SlowHeadshotScale.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fSlowHeadshotScale;
	Config_Sniper_Rifle.SlowHeadshotScale.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.SlowHeadshotScale.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.SlowHeadshotScale.NumericValue.MaxValue = 10;
	Config_Sniper_Rifle.SlowHeadshotScale.DecimalPlaces = 2;
	Config_Sniper_Rifle.RunningHeadshotScale.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fRunningHeadshotScale;
	Config_Sniper_Rifle.RunningHeadshotScale.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.RunningHeadshotScale.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.RunningHeadshotScale.NumericValue.MaxValue = 10;
	Config_Sniper_Rifle.RunningHeadshotScale.DecimalPlaces = 2;
	Config_Sniper_Rifle.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fDamageOverlayTime;
	Config_Sniper_Rifle.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_Sniper_Rifle.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_Sniper_Rifle.DamageOverlayTime.DecimalPlaces = 2;
	Config_Sniper_Rifle.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fNodeDamageScaling;
	Config_Sniper_Rifle.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_Sniper_Rifle.NodeDamageScaling.DecimalPlaces = 2;
	Config_Sniper_Rifle.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleDamageScaling;
	Config_Sniper_Rifle.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_Sniper_Rifle.VehicleDamageScaling.DecimalPlaces = 2;
	Config_Sniper_Rifle.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleMomentumScaling;
	Config_Sniper_Rifle.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_Sniper_Rifle.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_Sniper_Rifle.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iDamage;
	Config_Sniper_Rifle.Damage.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.Damage.SliderValue.MinValue = 5;
	Config_Sniper_Rifle.Damage.SliderValue.MaxValue = 300;
	Config_Sniper_Rifle.Damage.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.Damage.UpdateCaption();
	Config_Sniper_Rifle.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iMomentum;
	Config_Sniper_Rifle.Momentum.SliderValue.NudgeValue = 1000;
   Config_Sniper_Rifle.Momentum.SliderValue.MinValue = 0;
	Config_Sniper_Rifle.Momentum.SliderValue.MaxValue = 200000;
	Config_Sniper_Rifle.Momentum.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.Momentum.UpdateCaption();
	Config_Sniper_Rifle.HeadShotDmgMult.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fHeadShotDmgMult;
	Config_Sniper_Rifle.HeadShotDmgMult.NumericValue.NudgeValue = 0.01;
   Config_Sniper_Rifle.HeadShotDmgMult.NumericValue.MinValue = 0.01;
	Config_Sniper_Rifle.HeadShotDmgMult.NumericValue.MaxValue = 10;
	Config_Sniper_Rifle.HeadShotDmgMult.DecimalPlaces = 2;
	Config_Sniper_Rifle.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iAmmoCount;
	Config_Sniper_Rifle.AmmoCount.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.AmmoCount.SliderValue.MinValue = 1;
	Config_Sniper_Rifle.AmmoCount.SliderValue.MaxValue = 500;
	Config_Sniper_Rifle.AmmoCount.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.AmmoCount.UpdateCaption();
	Config_Sniper_Rifle.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iMaxAmmo;
	Config_Sniper_Rifle.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.MaxAmmo.SliderValue.MinValue = 1;
	Config_Sniper_Rifle.MaxAmmo.SliderValue.MaxValue = 500;
	Config_Sniper_Rifle.MaxAmmo.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.MaxAmmo.UpdateCaption();
	Config_Sniper_Rifle.ZoomFOV.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iZoomFOV;
	Config_Sniper_Rifle.ZoomFOV.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.ZoomFOV.SliderValue.MinValue = 1;
	Config_Sniper_Rifle.ZoomFOV.SliderValue.MaxValue = 40;
	Config_Sniper_Rifle.ZoomFOV.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.ZoomFOV.UpdateCaption();
	Config_Sniper_Rifle.ZoomRate.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iZoomRate;
	Config_Sniper_Rifle.ZoomRate.SliderValue.NudgeValue = 10;
   Config_Sniper_Rifle.ZoomRate.SliderValue.MinValue = 50;
	Config_Sniper_Rifle.ZoomRate.SliderValue.MaxValue = 500;
	Config_Sniper_Rifle.ZoomRate.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.ZoomRate.UpdateCaption();
	Config_Sniper_Rifle.PriHelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iPriHelpRadius;
	Config_Sniper_Rifle.PriHelpRadius.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.PriHelpRadius.SliderValue.MinValue = 0;
	Config_Sniper_Rifle.PriHelpRadius.SliderValue.MaxValue = 100;
	Config_Sniper_Rifle.PriHelpRadius.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.PriHelpRadius.UpdateCaption();
	Config_Sniper_Rifle.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iAimError;
	Config_Sniper_Rifle.AimError.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.AimError.SliderValue.MinValue = 0;
	Config_Sniper_Rifle.AimError.SliderValue.MaxValue = 1000;
	Config_Sniper_Rifle.AimError.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.AimError.UpdateCaption();
	Config_Sniper_Rifle.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iShotCost;
	Config_Sniper_Rifle.ShotCost.SliderValue.NudgeValue = 1;
   Config_Sniper_Rifle.ShotCost.SliderValue.MinValue = 0;
	Config_Sniper_Rifle.ShotCost.SliderValue.MaxValue = 1;
	Config_Sniper_Rifle.ShotCost.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.ShotCost.UpdateCaption();
   Config_Sniper_Rifle.SniperRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iSniperRecoil;
	Config_Sniper_Rifle.SniperRecoil.SliderValue.NudgeValue = 500;
   Config_Sniper_Rifle.SniperRecoil.SliderValue.MinValue = 0;
	Config_Sniper_Rifle.SniperRecoil.SliderValue.MaxValue = 10000;
	Config_Sniper_Rifle.SniperRecoil.SliderValue.bIntRange = true;
   Config_Sniper_Rifle.SniperRecoil.UpdateCaption();

	// Stinger Settings Initiate
	Config_Stinger.bAmmoRegeneration.SetValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.bAmmoRegeneration);
	Config_Stinger.bDoubles.SetValue(class'EM_XX.MutEM_XX'.default.Config_Stinger.bDoubles);
	Config_Stinger.PriFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriFireInterval;
	Config_Stinger.PriFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Stinger.PriFireInterval.NumericValue.MinValue = 0.01;
	Config_Stinger.PriFireInterval.NumericValue.MaxValue = 2;
	Config_Stinger.PriFireInterval.DecimalPlaces = 2;
	Config_Stinger.SecFireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecFireInterval;
	Config_Stinger.SecFireInterval.NumericValue.NudgeValue = 0.01;
   Config_Stinger.SecFireInterval.NumericValue.MinValue = 0.01;
	Config_Stinger.SecFireInterval.NumericValue.MaxValue = 2;
	Config_Stinger.SecFireInterval.DecimalPlaces = 2;
	Config_Stinger.PriSpread.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriSpread;
	Config_Stinger.PriSpread.NumericValue.NudgeValue = 0.01;
   Config_Stinger.PriSpread.NumericValue.MinValue = 0.00;
	Config_Stinger.PriSpread.NumericValue.MaxValue = 0.1;
	Config_Stinger.PriSpread.DecimalPlaces = 2;
	Config_Stinger.SecSpread.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecSpread;
	Config_Stinger.SecSpread.NumericValue.NudgeValue = 0.01;
   Config_Stinger.SecSpread.NumericValue.MinValue = 0.00;
	Config_Stinger.SecSpread.NumericValue.MaxValue = 0.1;
	Config_Stinger.SecSpread.DecimalPlaces = 2;
	Config_Stinger.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fAIRating;
	Config_Stinger.AIRating.NumericValue.NudgeValue = 0.01;
   Config_Stinger.AIRating.NumericValue.MinValue = 0;
	Config_Stinger.AIRating.NumericValue.MaxValue = 2;
	Config_Stinger.AIRating.DecimalPlaces = 2;
	Config_Stinger.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iShotCost;
	Config_Stinger.ShotCost.SliderValue.NudgeValue = 1;
   Config_Stinger.ShotCost.SliderValue.MinValue = 0;
	Config_Stinger.ShotCost.SliderValue.MaxValue = 1;
	Config_Stinger.ShotCost.SliderValue.bIntRange = true;
   Config_Stinger.ShotCost.UpdateCaption();
   Config_Stinger.AimingHelpRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iAimingHelpRadius;
	Config_Stinger.AimingHelpRadius.SliderValue.NudgeValue = 1;
   Config_Stinger.AimingHelpRadius.SliderValue.MinValue = 0;
	Config_Stinger.AimingHelpRadius.SliderValue.MaxValue = 100;
	Config_Stinger.AimingHelpRadius.SliderValue.bIntRange = true;
   Config_Stinger.AimingHelpRadius.UpdateCaption();
   Config_Stinger.StingerRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iStingerRecoil;
	Config_Stinger.StingerRecoil.SliderValue.NudgeValue = 500;
   Config_Stinger.StingerRecoil.SliderValue.MinValue = 0;
	Config_Stinger.StingerRecoil.SliderValue.MaxValue = 10000;
	Config_Stinger.StingerRecoil.SliderValue.bIntRange = true;
   Config_Stinger.StingerRecoil.UpdateCaption();
	Config_Stinger.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fNodeDamageScaling;
	Config_Stinger.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Stinger.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_Stinger.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_Stinger.NodeDamageScaling.DecimalPlaces = 2;
	Config_Stinger.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleDamageScaling;
	Config_Stinger.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_Stinger.VehicleDamageScaling.NumericValue.MinValue = 0.01;
	Config_Stinger.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_Stinger.VehicleDamageScaling.DecimalPlaces = 2;
	Config_Stinger.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleMomentumScaling;
	Config_Stinger.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_Stinger.VehicleMomentumScaling.NumericValue.MinValue = 0.01;
	Config_Stinger.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_Stinger.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_Stinger.DamageOverlayTime.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.fDamageOverlayTime;
	Config_Stinger.DamageOverlayTime.NumericValue.NudgeValue = 0.01;
   Config_Stinger.DamageOverlayTime.NumericValue.MinValue = 0;
	Config_Stinger.DamageOverlayTime.NumericValue.MaxValue = 3;
	Config_Stinger.DamageOverlayTime.DecimalPlaces = 2;
	Config_Stinger.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iAmmoCount;
	Config_Stinger.AmmoCount.SliderValue.NudgeValue = 1;
   Config_Stinger.AmmoCount.SliderValue.MinValue = 1;
	Config_Stinger.AmmoCount.SliderValue.MaxValue = 500;
	Config_Stinger.AmmoCount.SliderValue.bIntRange = true;
   Config_Stinger.AmmoCount.UpdateCaption();
	Config_Stinger.AimError.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iAimError;
	Config_Stinger.AimError.SliderValue.NudgeValue = 1;
   Config_Stinger.AimError.SliderValue.MinValue = 0;
	Config_Stinger.AimError.SliderValue.MaxValue = 1000;
	Config_Stinger.AimError.SliderValue.bIntRange = true;
   Config_Stinger.AimError.UpdateCaption();
	Config_Stinger.MaxAmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iMaxAmmoCount;
	Config_Stinger.MaxAmmoCount.SliderValue.NudgeValue = 1;
   Config_Stinger.MaxAmmoCount.SliderValue.MinValue = 1;
	Config_Stinger.MaxAmmoCount.SliderValue.MaxValue = 500;
	Config_Stinger.MaxAmmoCount.SliderValue.bIntRange = true;
   Config_Stinger.MaxAmmoCount.UpdateCaption();
   Config_Stinger.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iSpeed;
	Config_Stinger.Speed.SliderValue.NudgeValue = 50;
   Config_Stinger.Speed.SliderValue.MinValue = 500;
	Config_Stinger.Speed.SliderValue.MaxValue = 12000;
	Config_Stinger.Speed.SliderValue.bIntRange = true;
   Config_Stinger.Speed.UpdateCaption();
	Config_Stinger.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iDamage;
	Config_Stinger.Damage.SliderValue.NudgeValue = 1;
   Config_Stinger.Damage.SliderValue.MinValue = 5;
	Config_Stinger.Damage.SliderValue.MaxValue = 300;
	Config_Stinger.Damage.SliderValue.bIntRange = true;
   Config_Stinger.Damage.UpdateCaption();
	Config_Stinger.DamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iDamageRadius;
	Config_Stinger.DamageRadius.SliderValue.NudgeValue = 5;
   Config_Stinger.DamageRadius.SliderValue.MinValue = 0;
	Config_Stinger.DamageRadius.SliderValue.MaxValue = 200;
	Config_Stinger.DamageRadius.SliderValue.bIntRange = true;
   Config_Stinger.DamageRadius.UpdateCaption();
	Config_Stinger.MomentumTransfer.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iMomentumTransfer;
	Config_Stinger.MomentumTransfer.SliderValue.NudgeValue = 5000;
   Config_Stinger.MomentumTransfer.SliderValue.MinValue = 0;
	Config_Stinger.MomentumTransfer.SliderValue.MaxValue = 200000;
	Config_Stinger.MomentumTransfer.SliderValue.bIntRange = true;
   Config_Stinger.MomentumTransfer.UpdateCaption();
   Config_Stinger.SecSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecSpeed;
	Config_Stinger.SecSpeed.SliderValue.NudgeValue = 50;
   Config_Stinger.SecSpeed.SliderValue.MinValue = 500;
	Config_Stinger.SecSpeed.SliderValue.MaxValue = 12000;
	Config_Stinger.SecSpeed.SliderValue.bIntRange = true;
   Config_Stinger.SecSpeed.UpdateCaption();
	Config_Stinger.SecDamage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecDamage;
	Config_Stinger.SecDamage.SliderValue.NudgeValue = 1;
   Config_Stinger.SecDamage.SliderValue.MinValue = 5;
	Config_Stinger.SecDamage.SliderValue.MaxValue = 300;
	Config_Stinger.SecDamage.SliderValue.bIntRange = true;
   Config_Stinger.SecDamage.UpdateCaption();
	Config_Stinger.SecDamageRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecDamageRadius;
	Config_Stinger.SecDamageRadius.SliderValue.NudgeValue = 5;
   Config_Stinger.SecDamageRadius.SliderValue.MinValue = 0;
	Config_Stinger.SecDamageRadius.SliderValue.MaxValue = 200;
	Config_Stinger.SecDamageRadius.SliderValue.bIntRange = true;
   Config_Stinger.SecDamageRadius.UpdateCaption();
   Config_Stinger.SecBounces.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecBounces;
	Config_Stinger.SecBounces.SliderValue.NudgeValue = 1;
   Config_Stinger.SecBounces.SliderValue.MinValue = 0;
	Config_Stinger.SecBounces.SliderValue.MaxValue = 10;
	Config_Stinger.SecBounces.SliderValue.bIntRange = true;
   Config_Stinger.SecBounces.UpdateCaption();

	// Weapon List Initiate
	MyWeaponList.Selection = 0;
	MyWeaponList.OnSelectionChange=OnSelectionChange;
	UpdateWeaponStatDisplay(MyWeaponList.Selection);
//	MyWeaponList.SetFocus(none);
}

function InitiateWeaponSettingsContinued()
{
//////////////////////////////////////
// Bindings Settings
//////////////////////////////////////
	// Weapon List Binding
	frameWeapon[9] = UIFrameBox(FindChild('frameGoliathCannon', true));
	frameWeapon[10] = UIFrameBox(FindChild('frameRedeemer', true));
	frameWeapon[11] = UIFrameBox(FindChild('frameTrans', true));
	
	// Goliath Cannon Settings Binding
	Config_GoliathCannon.FireInterval = UINumericEditBox(FindChild('oilGoliathFireInterval', true));
	Config_GoliathCannon.ZoomFOV = UTUISlider(FindChild('sliGoliathZoomFOV', true));
	Config_GoliathCannon.ZoomRate = UTUISlider(FindChild('sliGoliathZoomRate', true));
	Config_GoliathCannon.Damage = UTUISlider(FindChild('sliGoliathShellDmg', true));
	Config_GoliathCannon.DmgRadius = UTUISlider(FindChild('sliGoliathShellDmgRadius', true));
	Config_GoliathCannon.Momentum = UTUISlider(FindChild('sliGoliathShellMomentum', true));
	Config_GoliathCannon.Speed = UTUISlider(FindChild('sliGoliathShellSpeed', true));
	Config_GoliathCannon.AmmoCount = UTUISlider(FindChild('sliGoliathAmmoCount', true));
	Config_GoliathCannon.MaxAmmo = UTUISlider(FindChild('sliGoliathMaxAmmo', true));
	Config_GoliathCannon.RespawnTime = UTUISlider(FindChild('sliGoliathRespawnTime', true));
	Config_GoliathCannon.VehicleDamageScaling = UINumericEditBox(FindChild('oilGoliathDamageScaling', true));
	Config_GoliathCannon.VehicleMomentumScaling = UINumericEditBox(FindChild('oilGoliathMomentumScaling', true));
	Config_GoliathCannon.NodeDamageScaling = UINumericEditBox(FindChild('oilGoliathNodeScaling', true));
   Config_GoliathCannon.ShotCost = UTUISlider(FindChild('sliGoliathShotCost', true));
   Config_GoliathCannon.GoliathRecoil = UTUISlider(FindChild('sliGoliathRecoil', true));
   Config_GoliathCannon.AIRating = UINumericEditBox(FindChild('oilGoliathAIRating', true));
   Config_GoliathCannon.FireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fFireInterval);
   Config_GoliathCannon.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleDamageScaling);
   Config_GoliathCannon.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleMomentumScaling);
   Config_GoliathCannon.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fNodeDamageScaling);
   Config_GoliathCannon.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fAIRating);

	// Redeemer Settings Binding
	Config_RedeemMachine.Damage = UTUISlider(FindChild('sliRedeemerRocketDmg', true));
	Config_RedeemMachine.Momentum = UTUISlider(FindChild('sliRedeemerMomentum', true));
	Config_RedeemMachine.RocketSpeed = UTUISlider(FindChild('sliRedeemerRocketSpeed', true));
	Config_RedeemMachine.AmmoCount = UTUISlider(FindChild('sliRedeemerAmmoCount', true));
	Config_RedeemMachine.MaxAmmo = UTUISlider(FindChild('sliRedeemerMaxAmmo', true));
	Config_RedeemMachine.RespawnTime = UTUISlider(FindChild('sliRedeemerRespawnTime', true));
	Config_RedeemMachine.ZoomFOV = UTUISlider(FindChild('sliRedeemerZoomFOV', true));
	Config_RedeemMachine.ZoomRate = UTUISlider(FindChild('sliRedeemerZoomRate', true));
	Config_RedeemMachine.ShotCost = UTUISlider(FindChild('sliRedeemerShotCost', true));
	Config_RedeemMachine.DeemerRecoil = UTUISlider(FindChild('sliDeemerRecoil', true));
	Config_RedeemMachine.AIRating = UINumericEditBox(FindChild('oilRedeemerAIRating', true));
	Config_RedeemMachine.NodeDamageScaling = UINumericEditBox(FindChild('oilRedeemerNodeScaling', true));
	Config_RedeemMachine.VehicleDamageScaling = UINumericEditBox(FindChild('oilRedeemerVehicleScaling', true));
	Config_RedeemMachine.VehicleMomentumScaling = UINumericEditBox(FindChild('oilRedeemerVehicleMomentum', true));
   Config_RedeemMachine.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fAIRating);
   Config_RedeemMachine.NodeDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fNodeDamageScaling);
   Config_RedeemMachine.VehicleDamageScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleDamageScaling);
   Config_RedeemMachine.VehicleMomentumScaling.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleMomentumScaling);

	// Trans Settings Binding
	Config_TransElite.bUseTrans = UTUICollectionCheckBox(FindChild('cbUseTrans', true));
	Config_TransElite.RechargeRate = UTUISlider(FindChild('sliTransRechargeRate', true));
	Config_TransElite.TossZ = UTUISlider(FindChild('sliTransiTossZ', true));
	Config_TransElite.Speed = UTUISlider(FindChild('sliTransSpeed', true));
	Config_TransElite.MaxAmmo = UTUISlider(FindChild('sliTransMaxAmmo', true));
   Config_TransElite.Buoyancy = UTUISlider(FindChild('sliTransBuoyancy', true));
   Config_TransElite.MomentumTransfer = UTUISlider(FindChild('sliTransMomentumTransfer', true));
   Config_TransElite.GibPerterbation = UTUISlider(FindChild('sliTransGibPerterbation', true));
   Config_TransElite.AIRating = UTUINumericEditBox(FindChild('numTransAIRating', true));
   Config_TransElite.FireInterval = UINumericEditBox(FindChild('numTransFireInterval', true));
   Config_TransElite.AIRating.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_TransElite.fAIRating);
   Config_TransElite.FireInterval.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_TransElite.fFireInterval);
   
   
//////////////////////////////////////
// Initiate Settings
//////////////////////////////////////
	// Goliath Cannon Settings Initiate
	Config_GoliathCannon.FireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fFireInterval;
	Config_GoliathCannon.FireInterval.NumericValue.NudgeValue = 0.01;
   Config_GoliathCannon.FireInterval.NumericValue.MinValue = 0.01;
	Config_GoliathCannon.FireInterval.NumericValue.MaxValue = 2;
	Config_GoliathCannon.FireInterval.DecimalPlaces = 2;
	Config_GoliathCannon.ZoomFOV.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fZoomFOV;
	Config_GoliathCannon.ZoomFOV.SliderValue.NudgeValue = 1;
   Config_GoliathCannon.ZoomFOV.SliderValue.MinValue = 1;
	Config_GoliathCannon.ZoomFOV.SliderValue.MaxValue = 40;
	Config_GoliathCannon.ZoomFOV.SliderValue.bIntRange = true;
   Config_GoliathCannon.ZoomFOV.UpdateCaption();
	Config_GoliathCannon.ZoomRate.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iZoomRate;
	Config_GoliathCannon.ZoomRate.SliderValue.NudgeValue = 10;
   Config_GoliathCannon.ZoomRate.SliderValue.MinValue = 50;
	Config_GoliathCannon.ZoomRate.SliderValue.MaxValue = 500;
	Config_GoliathCannon.ZoomRate.SliderValue.bIntRange = true;
   Config_GoliathCannon.ZoomRate.UpdateCaption();
	Config_GoliathCannon.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iDamage;
	Config_GoliathCannon.Damage.SliderValue.NudgeValue = 5;
   Config_GoliathCannon.Damage.SliderValue.MinValue = 10;
	Config_GoliathCannon.Damage.SliderValue.MaxValue = 1000;
	Config_GoliathCannon.Damage.SliderValue.bIntRange = true;
   Config_GoliathCannon.Damage.UpdateCaption();
	Config_GoliathCannon.DmgRadius.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iDmgRadius;
	Config_GoliathCannon.DmgRadius.SliderValue.NudgeValue = 25;
   Config_GoliathCannon.DmgRadius.SliderValue.MinValue = 0;
	Config_GoliathCannon.DmgRadius.SliderValue.MaxValue = 1000;
	Config_GoliathCannon.DmgRadius.SliderValue.bIntRange = true;
   Config_GoliathCannon.DmgRadius.UpdateCaption();
   Config_GoliathCannon.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iMomentum;
	Config_GoliathCannon.Momentum.SliderValue.NudgeValue = 1000;
   Config_GoliathCannon.Momentum.SliderValue.MinValue = 0;
	Config_GoliathCannon.Momentum.SliderValue.MaxValue = 200000;
	Config_GoliathCannon.Momentum.SliderValue.bIntRange = true;
   Config_GoliathCannon.Momentum.UpdateCaption();
	Config_GoliathCannon.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iSpeed;
	Config_GoliathCannon.Speed.SliderValue.NudgeValue = 50;
   Config_GoliathCannon.Speed.SliderValue.MinValue = 500;
	Config_GoliathCannon.Speed.SliderValue.MaxValue = 12000;
	Config_GoliathCannon.Speed.SliderValue.bIntRange = true;
   Config_GoliathCannon.Speed.UpdateCaption();
	Config_GoliathCannon.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iAmmoCount;
	Config_GoliathCannon.AmmoCount.SliderValue.NudgeValue = 1;
   Config_GoliathCannon.AmmoCount.SliderValue.MinValue = 1;
	Config_GoliathCannon.AmmoCount.SliderValue.MaxValue = 100;
	Config_GoliathCannon.AmmoCount.SliderValue.bIntRange = true;
   Config_GoliathCannon.AmmoCount.UpdateCaption();
	Config_GoliathCannon.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iMaxAmmo;
	Config_GoliathCannon.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_GoliathCannon.MaxAmmo.SliderValue.MinValue = 1;
	Config_GoliathCannon.MaxAmmo.SliderValue.MaxValue = 100;
	Config_GoliathCannon.MaxAmmo.SliderValue.bIntRange = true;
   Config_GoliathCannon.MaxAmmo.UpdateCaption();
   Config_GoliathCannon.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fNodeDamageScaling;
	Config_GoliathCannon.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_GoliathCannon.NodeDamageScaling.NumericValue.MinValue = 0.1;
	Config_GoliathCannon.NodeDamageScaling.NumericValue.MaxValue = 5;
	Config_GoliathCannon.NodeDamageScaling.DecimalPlaces = 2;
	Config_GoliathCannon.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleDamageScaling;
	Config_GoliathCannon.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_GoliathCannon.VehicleDamageScaling.NumericValue.MinValue = 0.1;
	Config_GoliathCannon.VehicleDamageScaling.NumericValue.MaxValue = 5;
	Config_GoliathCannon.VehicleDamageScaling.DecimalPlaces = 2;
	Config_GoliathCannon.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleMomentumScaling;
	Config_GoliathCannon.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_GoliathCannon.VehicleMomentumScaling.NumericValue.MinValue = 0.1;
	Config_GoliathCannon.VehicleMomentumScaling.NumericValue.MaxValue = 5;
	Config_GoliathCannon.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_GoliathCannon.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iShotCost;
	Config_GoliathCannon.ShotCost.SliderValue.NudgeValue = 1;
   Config_GoliathCannon.ShotCost.SliderValue.MinValue = 0;
	Config_GoliathCannon.ShotCost.SliderValue.MaxValue = 1;
	Config_GoliathCannon.ShotCost.SliderValue.bIntRange = true;
   Config_GoliathCannon.ShotCost.UpdateCaption();
	Config_GoliathCannon.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fAIRating;
	Config_GoliathCannon.AIRating.NumericValue.NudgeValue = 0.01;
   Config_GoliathCannon.AIRating.NumericValue.MinValue = 0;
	Config_GoliathCannon.AIRating.NumericValue.MaxValue = 2.00;
	Config_GoliathCannon.AIRating.DecimalPlaces = 2;
	Config_GoliathCannon.GoliathRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iGoliathRecoil;
	Config_GoliathCannon.GoliathRecoil.SliderValue.NudgeValue = 1000;
   Config_GoliathCannon.GoliathRecoil.SliderValue.MinValue = 0;
	Config_GoliathCannon.GoliathRecoil.SliderValue.MaxValue = 20000;
	Config_GoliathCannon.GoliathRecoil.SliderValue.bIntRange = true;
   Config_GoliathCannon.GoliathRecoil.UpdateCaption();

	// Redeemer Settings Initiate
	Config_RedeemMachine.Damage.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iDamage;
	Config_RedeemMachine.Damage.SliderValue.NudgeValue = 50;
   Config_RedeemMachine.Damage.SliderValue.MinValue = 100;
	Config_RedeemMachine.Damage.SliderValue.MaxValue = 1000;
	Config_RedeemMachine.Damage.SliderValue.bIntRange = true;
   Config_RedeemMachine.Damage.UpdateCaption();
	Config_RedeemMachine.Momentum.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iMomentum;
	Config_RedeemMachine.Momentum.SliderValue.NudgeValue = 1000;
   Config_RedeemMachine.Momentum.SliderValue.MinValue = 0;
	Config_RedeemMachine.Momentum.SliderValue.MaxValue = 200000;
	Config_RedeemMachine.Momentum.SliderValue.bIntRange = true;
   Config_RedeemMachine.Momentum.UpdateCaption();
	Config_RedeemMachine.RocketSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iRocketSpeed;
	Config_RedeemMachine.RocketSpeed.SliderValue.NudgeValue = 50;
   Config_RedeemMachine.RocketSpeed.SliderValue.MinValue = 500;
	Config_RedeemMachine.RocketSpeed.SliderValue.MaxValue = 12000;
	Config_RedeemMachine.RocketSpeed.SliderValue.bIntRange = true;
   Config_RedeemMachine.RocketSpeed.UpdateCaption();
	Config_RedeemMachine.AmmoCount.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iAmmoCount;
	Config_RedeemMachine.AmmoCount.SliderValue.NudgeValue = 1;
   Config_RedeemMachine.AmmoCount.SliderValue.MinValue = 1;
	Config_RedeemMachine.AmmoCount.SliderValue.MaxValue = 100;
	Config_RedeemMachine.AmmoCount.SliderValue.bIntRange = true;
   Config_RedeemMachine.AmmoCount.UpdateCaption();
	Config_RedeemMachine.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iMaxAmmo;
	Config_RedeemMachine.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_RedeemMachine.MaxAmmo.SliderValue.MinValue = 1;
	Config_RedeemMachine.MaxAmmo.SliderValue.MaxValue = 100;
	Config_RedeemMachine.MaxAmmo.SliderValue.bIntRange = true;
   Config_RedeemMachine.MaxAmmo.UpdateCaption();
	Config_RedeemMachine.ZoomFOV.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iZoomFOV;
	Config_RedeemMachine.ZoomFOV.SliderValue.NudgeValue = 1;
   Config_RedeemMachine.ZoomFOV.SliderValue.MinValue = 1;
	Config_RedeemMachine.ZoomFOV.SliderValue.MaxValue = 40;
	Config_RedeemMachine.ZoomFOV.SliderValue.bIntRange = true;
   Config_RedeemMachine.ZoomFOV.UpdateCaption();
	Config_RedeemMachine.ZoomRate.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iZoomRate;
	Config_RedeemMachine.ZoomRate.SliderValue.NudgeValue = 10;
   Config_RedeemMachine.ZoomRate.SliderValue.MinValue = 50;
	Config_RedeemMachine.ZoomRate.SliderValue.MaxValue = 500;
	Config_RedeemMachine.ZoomRate.SliderValue.bIntRange = true;
   Config_RedeemMachine.ZoomRate.UpdateCaption();
	Config_RedeemMachine.ShotCost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iShotCost;
	Config_RedeemMachine.ShotCost.SliderValue.NudgeValue = 1;
   Config_RedeemMachine.ShotCost.SliderValue.MinValue = 0;
	Config_RedeemMachine.ShotCost.SliderValue.MaxValue = 1;
	Config_RedeemMachine.ShotCost.SliderValue.bIntRange = true;
   Config_RedeemMachine.ShotCost.UpdateCaption();
	Config_RedeemMachine.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fAIRating;
	Config_RedeemMachine.AIRating.NumericValue.NudgeValue = 0.01;
   Config_RedeemMachine.AIRating.NumericValue.MinValue = 0;
	Config_RedeemMachine.AIRating.NumericValue.MaxValue = 2.00;
	Config_RedeemMachine.AIRating.DecimalPlaces = 2;
	Config_RedeemMachine.NodeDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fNodeDamageScaling;
	Config_RedeemMachine.NodeDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_RedeemMachine.NodeDamageScaling.NumericValue.MinValue = 0.01;
	Config_RedeemMachine.NodeDamageScaling.NumericValue.MaxValue = 5.00;
	Config_RedeemMachine.NodeDamageScaling.DecimalPlaces = 2;
	Config_RedeemMachine.VehicleDamageScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleDamageScaling;
	Config_RedeemMachine.VehicleDamageScaling.NumericValue.NudgeValue = 0.01;
   Config_RedeemMachine.VehicleDamageScaling.NumericValue.MinValue = 0.1;
	Config_RedeemMachine.VehicleDamageScaling.NumericValue.MaxValue = 5.00;
	Config_RedeemMachine.VehicleDamageScaling.DecimalPlaces = 2;
	Config_RedeemMachine.VehicleMomentumScaling.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleMomentumScaling;
	Config_RedeemMachine.VehicleMomentumScaling.NumericValue.NudgeValue = 0.01;
   Config_RedeemMachine.VehicleMomentumScaling.NumericValue.MinValue = 0.1;
	Config_RedeemMachine.VehicleMomentumScaling.NumericValue.MaxValue = 5.00;
	Config_RedeemMachine.VehicleMomentumScaling.DecimalPlaces = 2;
	Config_RedeemMachine.DeemerRecoil.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iDeemerRecoil;
	Config_RedeemMachine.DeemerRecoil.SliderValue.NudgeValue = 1000;
   Config_RedeemMachine.DeemerRecoil.SliderValue.MinValue = 0;
	Config_RedeemMachine.DeemerRecoil.SliderValue.MaxValue = 40000;
	Config_RedeemMachine.DeemerRecoil.SliderValue.bIntRange = true;
   Config_RedeemMachine.DeemerRecoil.UpdateCaption();

	// Trans Settings Initiate
   Config_TransElite.bUseTrans.SetValue(class'EM_XX.MutEM_XX'.default.Config_TransElite.bUseTrans);
   Config_TransElite.FireInterval.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.fFireInterval;
   Config_TransElite.FireInterval.NumericValue.NudgeValue = 0.01;
   Config_TransElite.FireInterval.NumericValue.MinValue = 0.01;
   Config_TransElite.FireInterval.NumericValue.MaxValue = 5;
   Config_TransElite.FireInterval.DecimalPlaces = 2;
	Config_TransElite.RechargeRate.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iRechargeRate;
	Config_TransElite.RechargeRate.SliderValue.NudgeValue = 1;
   Config_TransElite.RechargeRate.SliderValue.MinValue = 0;
	Config_TransElite.RechargeRate.SliderValue.MaxValue = 10;
   Config_TransElite.RechargeRate.SliderValue.bIntRange = true;
   Config_TransElite.RechargeRate.UpdateCaption();
	Config_TransElite.TossZ.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iTossZ;
	Config_TransElite.TossZ.SliderValue.NudgeValue = 20;
   Config_TransElite.TossZ.SliderValue.MinValue = 0;
	Config_TransElite.TossZ.SliderValue.MaxValue = 800;
   Config_TransElite.TossZ.SliderValue.bIntRange = true;
   Config_TransElite.TossZ.UpdateCaption();
	Config_TransElite.Speed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iSpeed;
	Config_TransElite.Speed.SliderValue.NudgeValue = 50;
   Config_TransElite.Speed.SliderValue.MinValue = 1200;
	Config_TransElite.Speed.SliderValue.MaxValue = 12000;
   Config_TransElite.Speed.SliderValue.bIntRange = true;
   Config_TransElite.Speed.UpdateCaption();
	Config_TransElite.MaxAmmo.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iMaxAmmo;
	Config_TransElite.MaxAmmo.SliderValue.NudgeValue = 1;
   Config_TransElite.MaxAmmo.SliderValue.MinValue = 1;
	Config_TransElite.MaxAmmo.SliderValue.MaxValue = 50;
   Config_TransElite.MaxAmmo.SliderValue.bIntRange = true;
   Config_TransElite.MaxAmmo.UpdateCaption();
	Config_TransElite.Buoyancy.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iBuoyancy;
	Config_TransElite.Buoyancy.SliderValue.NudgeValue = 1;
   Config_TransElite.Buoyancy.SliderValue.MinValue = 0;
	Config_TransElite.Buoyancy.SliderValue.MaxValue = 2;
   Config_TransElite.Buoyancy.SliderValue.bIntRange = true;
   Config_TransElite.Buoyancy.UpdateCaption();
	Config_TransElite.MomentumTransfer.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iMomentumTransfer;
	Config_TransElite.MomentumTransfer.SliderValue.NudgeValue = 5000;
   Config_TransElite.MomentumTransfer.SliderValue.MinValue = 0;
	Config_TransElite.MomentumTransfer.SliderValue.MaxValue = 200000;
   Config_TransElite.MomentumTransfer.SliderValue.bIntRange = true;
   Config_TransElite.MomentumTransfer.UpdateCaption();
	Config_TransElite.AIRating.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.fAIRating;
	Config_TransElite.AIRating.NumericValue.NudgeValue = 0.01;
   Config_TransElite.AIRating.NumericValue.MinValue = 0;
	Config_TransElite.AIRating.NumericValue.MaxValue = 2.00;
	Config_TransElite.AIRating.DecimalPlaces = 2;
	Config_TransElite.GibPerterbation.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_TransElite.iGibPerterbation;
	Config_TransElite.GibPerterbation.SliderValue.NudgeValue = 1;
   Config_TransElite.GibPerterbation.SliderValue.MinValue = 0;
	Config_TransElite.GibPerterbation.SliderValue.MaxValue = 100;
	Config_TransElite.GibPerterbation.SliderValue.bIntRange = true;
   Config_TransElite.GibPerterbation.UpdateCaption();

	// Weapon List Initiate
	MyWeaponList.Selection = 0;
	MyWeaponList.OnSelectionChange=OnSelectionChange;
	UpdateWeaponStatDisplay(MyWeaponList.Selection);
}

function InitiateMutationSettings()
{
   // Frame
	frameMutators = UIFrameBox(FindChild('frame_Mutators', true));

	// Custom Content Settings Binding
	Config_Content.bStartIn3rdPerson = UTUICollectionCheckBox(FindChild('cbStartIn3rdPerson', true));
	Config_Content.bHitSounds = UTUICollectionCheckBox(FindChild('cbHitSounds', true));
	Config_Content.bShowDMG = UTUICollectionCheckBox(FindChild('cbShowDMG', true));
	Config_Content.bHeadshotSounds = UTUICollectionCheckBox(FindChild('cbHeadshotSounds', true));
	Config_Content.bHeadshotMessage = UTUICollectionCheckBox(FindChild('cbHeadshotMessage', true));
   Config_Content.bVampirism = UTUICollectionCheckBox(FindChild('cbVampirism', true));
	Config_Content.VampHealth = UTUISlider(FindChild('sliVampHealth', true));
   Config_Content.bInventoryDrop = UTUICollectionCheckBox(FindChild('cbInventoryDrop', true));
   Config_Content.bDodgeJumping = UTUICollectionCheckBox(FindChild('cbDodgeJumping', true));
	Config_Content.bHeater = UTUICollectionCheckBox(FindChild('cbHeater', true));
	Config_Content.Heater = UTUISlider(FindChild('sliHeater', true));
	Config_Content.HeaterSeconds = UTUISlider(FindChild('sliHeaterSeconds', true));
	Config_Content.HeaterHealthLimit = UTUISlider(FindChild('sliHeaterHealthLimit', true));
	Config_Content.bCooler = UTUICollectionCheckBox(FindChild('cbCooler', true));
	Config_Content.Cooler = UTUISlider(FindChild('sliCooler', true));
	Config_Content.CoolerSeconds = UTUISlider(FindChild('sliCoolerSeconds', true));
	Config_Content.CoolerHealthLimit = UTUISlider(FindChild('sliCoolerHealthLimit', true));
	Config_Content.MaxNumJumps = UTUISlider(FindChild('sliMaxNumJumps', true));
	Config_Content.MaxJumpBoost = UTUISlider(FindChild('sliMaxJumpBoost', true));
	Config_Content.jumpZ = UTUISlider(FindChild('slijumpZ', true));
	Config_Content.DodgeSpeed = UTUISlider(FindChild('sliDodgeSpeed', true));
	Config_Content.DodgeSpeedZ = UTUISlider(FindChild('sliDodgeSpeedZ', true));
	Config_Content.GroundSpeed = UTUISlider(FindChild('sliGroundSpeed', true));
	Config_Content.MaxHoverTime = UTUISlider(FindChild('sliMaxHoverTime', true));
	Config_Content.MaxAirDodges = UTUISlider(FindChild('sliMaxAirDodges', true));
	Config_Content.CrouchJumpBoost = UTUISlider(FindChild('sliCrouchJumpBoost', true));
	Config_Content.bNoSelfDamage = UTUICollectionCheckBox(FindChild('cbselfdamage', true));
 	Config_Content.AirControl = UINumericEditBox(FindChild('oilAirControl', true));
   Config_Content.AirControl.SetNumericValue(class'EM_XX.MutEM_XX'.default.Config_Content.fAirControl);

	// Custom Content Settings Initiate
	Config_Content.bStartIn3rdPerson.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bStartIn3rdPerson);
	Config_Content.bNoSelfDamage.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bNoSelfDamage);
	Config_Content.bHitSounds.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bHitSounds);
	Config_Content.bShowDMG.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bShowDMG);
	Config_Content.bHeadshotSounds.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotSounds);
	Config_Content.bHeadshotMessage.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotMessage);
	Config_Content.bVampirism.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bVampirism);
	Config_Content.VampHealth.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iVampHealth;
	Config_Content.VampHealth.SliderValue.NudgeValue = 1;
   Config_Content.VampHealth.SliderValue.MinValue = 1;
	Config_Content.VampHealth.SliderValue.MaxValue = 5;
   Config_Content.VampHealth.SliderValue.bIntRange = true;
   Config_Content.VampHealth.UpdateCaption();
	Config_Content.bInventoryDrop.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bInventoryDrop);
	Config_Content.bDodgeJumping.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bDodgeJumping);
	Config_Content.bHeater.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bHeater);
	Config_Content.bCooler.SetValue(class'EM_XX.MutEM_XX'.default.Config_Content.bCooler);
	Config_Content.Heater.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iHeater;
	Config_Content.Heater.SliderValue.NudgeValue = 1;
   Config_Content.Heater.SliderValue.MinValue = 1;
	Config_Content.Heater.SliderValue.MaxValue = 5;
   Config_Content.Heater.SliderValue.bIntRange = true;
   Config_Content.Heater.UpdateCaption();
	Config_Content.HeaterSeconds.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iHeaterSeconds;
	Config_Content.HeaterSeconds.SliderValue.NudgeValue = 1;
   Config_Content.HeaterSeconds.SliderValue.MinValue = 1;
	Config_Content.HeaterSeconds.SliderValue.MaxValue = 5;
   Config_Content.HeaterSeconds.SliderValue.bIntRange = true;
   Config_Content.HeaterSeconds.UpdateCaption();
	Config_Content.HeaterHealthLimit.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iHeaterHealthLimit;
	Config_Content.HeaterHealthLimit.SliderValue.NudgeValue = 1;
   Config_Content.HeaterHealthLimit.SliderValue.MinValue = 0;
	Config_Content.HeaterHealthLimit.SliderValue.MaxValue = 500;
   Config_Content.HeaterHealthLimit.SliderValue.bIntRange = true;
   Config_Content.HeaterHealthLimit.UpdateCaption();
	Config_Content.Cooler.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iCooler;
	Config_Content.Cooler.SliderValue.NudgeValue = 1;
   Config_Content.Cooler.SliderValue.MinValue = -5;
	Config_Content.Cooler.SliderValue.MaxValue = -1;
   Config_Content.Cooler.SliderValue.bIntRange = true;
   Config_Content.Cooler.UpdateCaption();
	Config_Content.CoolerSeconds.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iCoolerSeconds;
	Config_Content.CoolerSeconds.SliderValue.NudgeValue = 1;
   Config_Content.CoolerSeconds.SliderValue.MinValue = 1;
	Config_Content.CoolerSeconds.SliderValue.MaxValue = 5;
   Config_Content.CoolerSeconds.SliderValue.bIntRange = true;
   Config_Content.CoolerSeconds.UpdateCaption();
	Config_Content.CoolerHealthLimit.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iCoolerHealthLimit;
	Config_Content.CoolerHealthLimit.SliderValue.NudgeValue = 1;
   Config_Content.CoolerHealthLimit.SliderValue.MinValue = 0;
	Config_Content.CoolerHealthLimit.SliderValue.MaxValue = 199;
   Config_Content.CoolerHealthLimit.SliderValue.bIntRange = true;
   Config_Content.CoolerHealthLimit.UpdateCaption();
	Config_Content.MaxNumJumps.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iMaxNumJumps;
	Config_Content.MaxNumJumps.SliderValue.NudgeValue = 1;
   Config_Content.MaxNumJumps.SliderValue.MinValue = 0;
	Config_Content.MaxNumJumps.SliderValue.MaxValue = 99;
   Config_Content.MaxNumJumps.SliderValue.bIntRange = true;
   Config_Content.MaxNumJumps.UpdateCaption();
	Config_Content.MaxJumpBoost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iMaxJumpBoost;
	Config_Content.MaxJumpBoost.SliderValue.NudgeValue = 5;
   Config_Content.MaxJumpBoost.SliderValue.MinValue = -100;
	Config_Content.MaxJumpBoost.SliderValue.MaxValue = 200;
   Config_Content.MaxJumpBoost.SliderValue.bIntRange = true;
   Config_Content.MaxJumpBoost.UpdateCaption();
	Config_Content.jumpZ.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.ijumpZ;
	Config_Content.jumpZ.SliderValue.NudgeValue = 20;
   Config_Content.jumpZ.SliderValue.MinValue = 0;
	Config_Content.jumpZ.SliderValue.MaxValue = 2000;
   Config_Content.jumpZ.SliderValue.bIntRange = true;
   Config_Content.jumpZ.UpdateCaption();
	Config_Content.DodgeSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iDodgeSpeed;
	Config_Content.DodgeSpeed.SliderValue.NudgeValue = 20;
   Config_Content.DodgeSpeed.SliderValue.MinValue = 0;
	Config_Content.DodgeSpeed.SliderValue.MaxValue = 2000;
   Config_Content.DodgeSpeed.SliderValue.bIntRange = true;
   Config_Content.DodgeSpeed.UpdateCaption();
	Config_Content.DodgeSpeedZ.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iDodgeSpeedZ;
	Config_Content.DodgeSpeedZ.SliderValue.NudgeValue = 20;
   Config_Content.DodgeSpeedZ.SliderValue.MinValue = 0;
	Config_Content.DodgeSpeedZ.SliderValue.MaxValue = 2000;
   Config_Content.DodgeSpeedZ.SliderValue.bIntRange = true;
   Config_Content.DodgeSpeedZ.UpdateCaption();
	Config_Content.GroundSpeed.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iGroundSpeed;
	Config_Content.GroundSpeed.SliderValue.NudgeValue = 20;
   Config_Content.GroundSpeed.SliderValue.MinValue = 0;
	Config_Content.GroundSpeed.SliderValue.MaxValue = 2000;
   Config_Content.GroundSpeed.SliderValue.bIntRange = true;
   Config_Content.GroundSpeed.UpdateCaption();
	Config_Content.MaxHoverTime.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iMaxHoverTime;
	Config_Content.MaxHoverTime.SliderValue.NudgeValue = 1;
   Config_Content.MaxHoverTime.SliderValue.MinValue = 0;
	Config_Content.MaxHoverTime.SliderValue.MaxValue = 100;
   Config_Content.MaxHoverTime.SliderValue.bIntRange = true;
   Config_Content.MaxHoverTime.UpdateCaption();
	Config_Content.MaxAirDodges.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iMaxAirDodges;
	Config_Content.MaxAirDodges.SliderValue.NudgeValue = 1;
   Config_Content.MaxAirDodges.SliderValue.MinValue = 0;
	Config_Content.MaxAirDodges.SliderValue.MaxValue = 99;
   Config_Content.MaxAirDodges.SliderValue.bIntRange = true;
   Config_Content.MaxAirDodges.UpdateCaption();
	Config_Content.CrouchJumpBoost.SliderValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.iCrouchJumpBoost;
	Config_Content.CrouchJumpBoost.SliderValue.NudgeValue = 50;
   Config_Content.CrouchJumpBoost.SliderValue.MinValue = 50;
	Config_Content.CrouchJumpBoost.SliderValue.MaxValue = 1000;
   Config_Content.CrouchJumpBoost.SliderValue.bIntRange = true;
   Config_Content.CrouchJumpBoost.UpdateCaption();
	Config_Content.AirControl.NumericValue.CurrentValue = class'EM_XX.MutEM_XX'.default.Config_Content.fAirControl;
	Config_Content.AirControl.NumericValue.NudgeValue = 0.1;
   Config_Content.AirControl.NumericValue.MinValue = 0;
	Config_Content.AirControl.NumericValue.MaxValue = 10.0;
	Config_Content.AirControl.DecimalPlaces = 1;
}

/** Callback for when the user accepts the changes. */
function OnAccept()
{
	local int WeaponIdx;
	local string ClassPath;
	local int SelectedIdx;

	WeaponsToReplace.length=0;
	AmmoToReplace.length=0;

	for(WeaponIdx=0; WeaponIdx<WeaponClassNames.length; WeaponIdx++)
	{
		ClassPath=GetClassFieldName(WeaponClassNames[WeaponIdx]);
		SelectedIdx=StringListDataStore.GetCurrentValueIndex(name(ClassPath));
		if(SelectedIdx!=WeaponIdx)
		{
			WeaponsToReplace.length=WeaponsToReplace.length+1;
			WeaponsToReplace[WeaponsToReplace.length-1].NewClassPath = WeaponProviders[SelectedIdx].ClassName;
			WeaponsToReplace[WeaponsToReplace.length-1].OldClassName = name(Right(WeaponProviders[WeaponIdx].ClassName, Len(WeaponProviders[WeaponIdx].ClassName) - InStr(WeaponProviders[WeaponIdx].ClassName, ".") - 1));
			
			AmmoToReplace.length=AmmoToReplace.length+1;
			AmmoToReplace[AmmoToReplace.length-1].NewClassPath = WeaponProviders[SelectedIdx].AmmoClassPath;
			AmmoToReplace[AmmoToReplace.length-1].OldClassName = name(Right(WeaponProviders[WeaponIdx].AmmoClassPath, Len(WeaponProviders[WeaponIdx].AmmoClassPath) - InStr(WeaponProviders[WeaponIdx].AmmoClassPath, ".") - 1));
		}
	}

	class'EM_XX.MutEM_XX'.default.WeaponsToReplace = WeaponsToReplace;
	class'EM_XX.MutEM_XX'.default.AmmoToReplace = AmmoToReplace;

	// Bio Rifle
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.bAmmoRegeneration = Config_Bio_Rifle.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.bDoubles = Config_Bio_Rifle.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fPriFireInterval = Config_Bio_Rifle.PriFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fAIRating = Config_Bio_Rifle.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDripTime = Config_Bio_Rifle.DripTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fDamageOverlayTime = Config_Bio_Rifle.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleMomentumScaling = Config_Bio_Rifle.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fVehicleDamageScaling = Config_Bio_Rifle.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fNodeDamageScaling = Config_Bio_Rifle.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iDamage = Config_Bio_Rifle.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMomentum = Config_Bio_Rifle.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iAmmoCount = Config_Bio_Rifle.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMaxAmmo = Config_Bio_Rifle.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iMaxResting = Config_Bio_Rifle.MaxResting.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iGlobStrength = Config_Bio_Rifle.GlobStrength.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iGloblingSpeed = Config_Bio_Rifle.GloblingSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iDamageRadius = Config_Bio_Rifle.DamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iHelpRadius = Config_Bio_Rifle.HelpRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iAimError = Config_Bio_Rifle.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iShotCost = Config_Bio_Rifle.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSpeed = Config_Bio_Rifle.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iBioRecoil = Config_Bio_Rifle.BioRecoil.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.fSecFireInterval= Config_Bio_Rifle.SecFireInterval.GetNumericValue();
   class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecSpeed = Config_Bio_Rifle.SecSpeed.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecDamage = Config_Bio_Rifle.SecDamage.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Bio_Rifle.iSecDamageRadius = Config_Bio_Rifle.SecDamageRadius.GetValue();

	// Enforcer
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.bAmmoRegeneration = Config_Enforcer.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.bDoubles = Config_Enforcer.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriFireInterval = Config_Enforcer.PriFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecFireInterval = Config_Enforcer.SecFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fPriSpread = Config_Enforcer.PriSpread.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fSecSpread = Config_Enforcer.SecSpread.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iPriDamage = Config_Enforcer.PriDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iSecDamage = Config_Enforcer.SecDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iMomentum = Config_Enforcer.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iAmmoCount = Config_Enforcer.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iMaxAmmo = Config_Enforcer.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iShotCost = Config_Enforcer.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iHelpRadius = Config_Enforcer.HelpRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iAimError = Config_Enforcer.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAkimboTime = Config_Enforcer.AkimboTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iBurstMax = Config_Enforcer.BurstMax.GetValue();	
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fAIRating = Config_Enforcer.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fDamageOverlayTime = Config_Enforcer.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleDamageScaling = Config_Enforcer.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fVehicleMomentumScaling = Config_Enforcer.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fNodeDamageScaling = Config_Enforcer.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.fBurstCoolDownTime = Config_Enforcer.BurstCoolDownTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Enforcer.iEnforcerRecoil = Config_Enforcer.EnforcerRecoil.GetValue();

	// Flak Cannon
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.bAmmoRegeneration = Config_FlakCannon.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.bDoubles = Config_FlakCannon.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fAIRating = Config_FlakCannon.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fPriFireRate = Config_FlakCannon.PriFireRate.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSecFireRate = Config_FlakCannon.SecFireRate.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fSpread = Config_FlakCannon.Spread.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fMaxBonusTime = Config_FlakCannon.MaxBonusTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fCustomGravityScaling = Config_FlakCannon.CustomGravityScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fDamageOverlayTime = Config_FlakCannon.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fNodeDamageScaling = Config_FlakCannon.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleDamageScaling = Config_FlakCannon.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_FlakCannon.fVehicleMomentumScaling = Config_FlakCannon.VehicleMomentumScaling.GetNumericValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iFlakRecoil = Config_FlakCannon.FlakRecoil.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iAmmoCount = Config_FlakCannon.AmmoCount.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMaxAmmo = Config_FlakCannon.MaxAmmo.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iShotCost = Config_FlakCannon.ShotCost.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.ispeed = Config_FlakCannon.speed.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iDamage = Config_FlakCannon.Damage.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iDamageRadius = Config_FlakCannon.DamageRadius.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMomentum = Config_FlakCannon.Momentum.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iShardBounces = Config_FlakCannon.ShardBounces.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iCenteredDamageBonus = Config_FlakCannon.CenteredDamageBonus.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iMainBounces = Config_FlakCannon.MainBounces.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecDamageRadius = Config_FlakCannon.SecDamageRadius.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecDamage = Config_FlakCannon.SecDamage.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iSecspeed = Config_FlakCannon.Secspeed.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_FlakCannon.iTossZ = Config_FlakCannon.TossZ.GetValue();

	// Impact Hammer
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinDmg = Config_ImpactHammer.MinDmg.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxDmg = Config_ImpactHammer.MaxDmg.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinForce = Config_ImpactHammer.MinForce.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxForce = Config_ImpactHammer.MaxForce.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinSelfDmg = Config_ImpactHammer.MinSelfDmg.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fEMPDmg = Config_ImpactHammer.EMPDmg.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fSelfDmgScale = Config_ImpactHammer.SelfDmgScale.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fSelfForceScale = Config_ImpactHammer.SelfForceScale.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.bUseHammer = Config_ImpactHammer.bUseHammer.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fAIRating = Config_ImpactHammer.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMaxChargeTime = Config_ImpactHammer.MaxChargeTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_ImpactHammer.fMinChargeTime = Config_ImpactHammer.MinChargeTime.GetNumericValue();

	// Link Gun
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.bAmmoRegeneration = Config_LinkGun.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.bDoubles = Config_LinkGun.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fPriFireInterval = Config_LinkGun.PriFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fNodeDamageScaling = Config_LinkGun.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleDamageScaling = Config_LinkGun.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fVehicleMomentumScaling = Config_LinkGun.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime = Config_LinkGun.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fLinkFlexibility = Config_LinkGun.LinkFlexibility.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.fAIRating = Config_LinkGun.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iPriDamage = Config_LinkGun.PriDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iProJSpeed = Config_LinkGun.ProJSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iSecDamage = Config_LinkGun.SecDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iMomentum = Config_LinkGun.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iAmmoCount = Config_LinkGun.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iMaxAmmo = Config_LinkGun.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iDamageRadius = Config_LinkGun.DamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iBeamAmmoSec = Config_LinkGun.BeamAmmoSec.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iWeaponLinkDistance = Config_LinkGun.WeaponLinkDistance.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iShotCost = Config_LinkGun.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iBeamRange = Config_LinkGun.BeamRange.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_LinkGun.iLucyRecoil = Config_LinkGun.LucyRecoil.GetValue();

	// Rocket Launcher
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.bAmmoRegeneration = Config_RL_BFG.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.bDoubles = Config_RL_BFG.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fPriFireInterval = Config_RL_BFG.PriFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fSecFireInterval = Config_RL_BFG.SecFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAIRating = Config_RL_BFG.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fDamageOverlayTime = Config_RL_BFG.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fNodeDamageScaling = Config_RL_BFG.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleDamageScaling = Config_RL_BFG.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fVehicleMomentumScaling = Config_RL_BFG.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iDamage = Config_RL_BFG.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iMomentum = Config_RL_BFG.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iAmmoCount = Config_RL_BFG.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockCurlForce = Config_RL_BFG.FlockCurlForce.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iMaxAmmo = Config_RL_BFG.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iHelpRadius = Config_RL_BFG.HelpRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iAimError = Config_RL_BFG.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iShotCost = Config_RL_BFG.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iSpeed = Config_RL_BFG.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockStiffness = Config_RL_BFG.FlockStiffness.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iGrenadeSpeed = Config_RL_BFG.GrenadeSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iDamageRadius = Config_RL_BFG.DamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.fAcquireTime = Config_RL_BFG.LockAcquireTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.ispreaddist = Config_RL_BFG.spreaddist.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.igrenadespreaddist = Config_RL_BFG.grenadespreaddist.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iLockRange = Config_RL_BFG.LockRange.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iFlockRadius = Config_RL_BFG.FlockRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RL_BFG.iRocketRecoil = Config_RL_BFG.RocketRecoil.GetValue();

	// Shock Rifle
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bAmmoRegeneration = Config_Shock_Rifle.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bDoubles = Config_Shock_Rifle.bDoubles.IsChecked();
//	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.bUseCombo = Config_Shock_Rifle.bUseCombo.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fFireInterval = Config_Shock_Rifle.FireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSecFireInterval = Config_Shock_Rifle.SecFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fAIRating = Config_Shock_Rifle.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fDamageOverlayTime = Config_Shock_Rifle.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fNodeDamageScaling = Config_Shock_Rifle.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleDamageScaling = Config_Shock_Rifle.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVehicleMomentumScaling = Config_Shock_Rifle.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamage = Config_Shock_Rifle.Damage.GetValue();
//	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboDamage = Config_Shock_Rifle.ComboDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamageImpulse = Config_Shock_Rifle.DamageImpulse.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iInstaDamage = Config_Shock_Rifle.InstaDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iMomentum = Config_Shock_Rifle.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iAmmoCount = Config_Shock_Rifle.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iMaxAmmo = Config_Shock_Rifle.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fHeadShotDmgMult = Config_Shock_Rifle.HeadShotDmgMult.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fSlowHeadshotScale = Config_Shock_Rifle.SlowHeadshotScale.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fRunningHeadshotScale = Config_Shock_Rifle.RunningHeadshotScale.GetNumericValue();
//	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iPriHelpRadius = Config_Shock_Rifle.PriHelpRadius.GetValue();
//	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iAimError = Config_Shock_Rifle.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iShotCost = Config_Shock_Rifle.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboAmmoCost = Config_Shock_Rifle.ComboAmmoCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iSpeed = Config_Shock_Rifle.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iDamageRadius = Config_Shock_Rifle.DamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iImpulseRadius = Config_Shock_Rifle.ImpulseRadius.GetValue();
//	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iComboDamageRadius = Config_Shock_Rifle.ComboDamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iInstaRecoil = Config_Shock_Rifle.InstaRecoil.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iVortexRadius = Config_Shock_Rifle.VortexRadius.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.iVortexForcePerSecond = Config_Shock_Rifle.VortexForcePerSecond.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Shock_Rifle.fVortexDuration = Config_Shock_Rifle.VortexDuration.GetNumericValue();

	// Sniper Rifle
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.bAmmoRegeneration = Config_Sniper_Rifle.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.bDoubles = Config_Sniper_Rifle.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fFireInterval = Config_Sniper_Rifle.FireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fAIRating = Config_Sniper_Rifle.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fSlowHeadshotScale = Config_Sniper_Rifle.SlowHeadshotScale.GetNumericValue();;
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fRunningHeadshotScale = Config_Sniper_Rifle.RunningHeadshotScale.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fHeadShotDmgMult = Config_Sniper_Rifle.HeadShotDmgMult.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fDamageOverlayTime = Config_Sniper_Rifle.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fNodeDamageScaling = Config_Sniper_Rifle.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleDamageScaling = Config_Sniper_Rifle.VehicleDamageScaling.GetNumericValue();
   class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.fVehicleMomentumScaling = Config_Sniper_Rifle.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iDamage = Config_Sniper_Rifle.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iMomentum = Config_Sniper_Rifle.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iAmmoCount = Config_Sniper_Rifle.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iMaxAmmo = Config_Sniper_Rifle.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iZoomFOV = Config_Sniper_Rifle.ZoomFOV.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iZoomRate = Config_Sniper_Rifle.ZoomRate.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iPriHelpRadius = Config_Sniper_Rifle.PriHelpRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iAimError = Config_Sniper_Rifle.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iShotCost = Config_Sniper_Rifle.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Sniper_Rifle.iSniperRecoil = Config_Sniper_Rifle.SniperRecoil.GetValue();

	// Stinger
	class'EM_XX.MutEM_XX'.default.Config_Stinger.bAmmoRegeneration = Config_Stinger.bAmmoRegeneration.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.bDoubles = Config_Stinger.bDoubles.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriFireInterval = Config_Stinger.PriFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fAIRating = Config_Stinger.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecFireInterval = Config_Stinger.SecFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fPriSpread = Config_Stinger.PriSpread.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecSpread = Config_Stinger.SecSpread.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iDamage = Config_Stinger.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iMomentumTransfer = Config_Stinger.MomentumTransfer.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fSecFireInterval = Config_Stinger.SecFireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iAmmoCount = Config_Stinger.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iMaxAmmoCount = Config_Stinger.MaxAmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iAimingHelpRadius = Config_Stinger.AimingHelpRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iAimError = Config_Stinger.AimError.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iShotCost = Config_Stinger.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iSpeed = Config_Stinger.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iDamageRadius = Config_Stinger.DamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iStingerRecoil = Config_Stinger.StingerRecoil.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fNodeDamageScaling = Config_Stinger.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleDamageScaling = Config_Stinger.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fVehicleMomentumScaling = Config_Stinger.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.fDamageOverlayTime = Config_Stinger.DamageOverlayTime.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecSpeed = Config_Stinger.SecSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecDamage = Config_Stinger.SecDamage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecDamageRadius = Config_Stinger.SecDamageRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Stinger.iSecBounces = Config_Stinger.SecBounces.GetValue();

	// Goliath Cannon
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fNodeDamageScaling = Config_GoliathCannon.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleDamageScaling = Config_GoliathCannon.VehicleDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fVehicleMomentumScaling = Config_GoliathCannon.VehicleMomentumScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fFireInterval = Config_GoliathCannon.FireInterval.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fZoomFOV = Config_GoliathCannon.ZoomFOV.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iZoomRate = Config_GoliathCannon.ZoomRate.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iDamage = Config_GoliathCannon.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iDmgRadius = Config_GoliathCannon.DmgRadius.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iMomentum = Config_GoliathCannon.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iSpeed = Config_GoliathCannon.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iAmmoCount = Config_GoliathCannon.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iMaxAmmo = Config_GoliathCannon.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iShotCost = Config_GoliathCannon.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.fAIRating = Config_GoliathCannon.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_GoliathCannon.iGoliathRecoil = Config_GoliathCannon.GoliathRecoil.GetValue();

	// Redeemer
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iDamage = Config_RedeemMachine.Damage.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iMomentum = Config_RedeemMachine.Momentum.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iRocketSpeed = Config_RedeemMachine.RocketSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iAmmoCount = Config_RedeemMachine.AmmoCount.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iMaxAmmo = Config_RedeemMachine.MaxAmmo.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iDeemerRecoil = Config_RedeemMachine.DeemerRecoil.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iZoomFOV = Config_RedeemMachine.ZoomFOV.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iZoomRate = Config_RedeemMachine.ZoomRate.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.iShotCost = Config_RedeemMachine.ShotCost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fAIRating = Config_RedeemMachine.AIRating.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fNodeDamageScaling = Config_RedeemMachine.NodeDamageScaling.GetNumericValue();
	class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleDamageScaling = Config_RedeemMachine.VehicleDamageScaling.GetNumericValue();
   class'EM_XX.MutEM_XX'.default.Config_RedeemMachine.fVehicleMomentumScaling = Config_RedeemMachine.VehicleMomentumScaling.GetNumericValue();

	// Trans
	class'EM_XX.MutEM_XX'.default.Config_TransElite.bUseTrans = Config_TransElite.bUseTrans.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_TransElite.iRechargeRate = Config_TransElite.RechargeRate.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_TransElite.iTossZ = Config_TransElite.TossZ.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_TransElite.iSpeed = Config_TransElite.Speed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_TransElite.iMaxAmmo = Config_TransElite.MaxAmmo.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_TransElite.iBuoyancy = Config_TransElite.Buoyancy.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_TransElite.iMomentumTransfer = Config_TransElite.MomentumTransfer.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_TransElite.iGibPerterbation = Config_TransElite.GibPerterbation.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_TransElite.fAIRating = Config_TransElite.AIRating.GetNumericValue();
   class'EM_XX.MutEM_XX'.default.Config_TransElite.fFireInterval = Config_TransElite.FireInterval.GetNumericValue();

   // Mutators
   class'EM_XX.MutEM_XX'.default.Config_Content.bStartIn3rdPerson = Config_Content.bStartIn3rdPerson.IsChecked();
   class'EM_XX.MutEM_XX'.default.Config_Content.bNoSelfDamage = Config_Content.bNoSelfDamage.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bHitSounds = Config_Content.bHitSounds.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bShowDMG = Config_Content.bShowDMG.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotSounds = Config_Content.bHeadshotSounds.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotMessage = Config_Content.bHeadshotMessage.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bVampirism = Config_Content.bVampirism.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.iVampHealth = Config_Content.VampHealth.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.bInventoryDrop = Config_Content.bInventoryDrop.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bDodgeJumping = Config_Content.bDodgeJumping.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.bHeater = Config_Content.bHeater.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.iHeater = Config_Content.Heater.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iHeaterSeconds = Config_Content.HeaterSeconds.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iHeaterHealthLimit = Config_Content.HeaterHealthLimit.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.bCooler = Config_Content.bCooler.IsChecked();
	class'EM_XX.MutEM_XX'.default.Config_Content.iCooler = Config_Content.Cooler.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iCoolerSeconds = Config_Content.CoolerSeconds.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iCoolerHealthLimit = Config_Content.CoolerHealthLimit.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iMaxNumJumps = Config_Content.MaxNumJumps.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iMaxJumpBoost = Config_Content.MaxJumpBoost.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.ijumpZ = Config_Content.jumpZ.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iDodgeSpeed = Config_Content.DodgeSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iDodgeSpeedZ = Config_Content.DodgeSpeedZ.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iGroundSpeed = Config_Content.GroundSpeed.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iMaxHoverTime = Config_Content.MaxHoverTime.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iMaxAirDodges = Config_Content.MaxAirDodges.GetValue();
	class'EM_XX.MutEM_XX'.default.Config_Content.iCrouchJumpBoost = Config_Content.CrouchJumpBoost.GetValue();
   class'EM_XX.MutEM_XX'.default.Config_Content.fAirControl = Config_Content.AirControl.GetNumericValue();

	class'EM_XX.MutEM_XX'.static.StaticSaveConfig();

	CloseScene(self);
}

/** Buttonbar Callbacks. */
function bool OnButtonBar_Back(UIScreenObject InButton, int InPlayerIndex)
{
	OnBack();

	return true;
}

function bool OnButtonBar_Accept(UIScreenObject InButton, int InPlayerIndex)
{
	OnAccept();

	return true;
}

defaultproperties
{
   Name="UIFrontEnd_EM_Menu"
   MutatorClass=Class'EM_XX.MutEM_XX'
}