/*
 * TransElite:  TransElite  Weapon
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class TransElite extends UTWeap_Translocator_Content
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	AmmoCount=class'MutEM_XX'.default.Config_TransElite.iMaxAmmo;
	MaxAmmoCount=class'MutEM_XX'.default.Config_TransElite.iMaxAmmo;
   RechargeRate=class'MutEM_XX'.default.Config_TransElite.iRechargeRate;
   AIRating=class'MutEM_XX'.default.Config_TransElite.fAIRating;
	MaxDesireability=class'MutEM_XX'.default.Config_TransElite.fAIRating;
	CurrentRating=class'MutEM_XX'.default.Config_TransElite.fAIRating;
}


/*
simulated function bool HasAmmo(byte FireModeNum, optional int Amount)
{
	AmmoCount = 1;
	return super.HasAmmo(FireModeNum, Amount);
}
*/
simulated function ModifyPlayer(Pawn Other)
{
  local UTPawn P;
  
  if (Other != None) 
  {
    P = UTPawn (Other);
    if (P != None) 
    {
      P.MaxFallSpeed = 2500.0;
    }
  }
}

simulated event SetPosition(UTPawn Holder)
{
      FireOffset.X = 0;
      FireOffset.Y = 0;
      FireOffset.Z = 0;

	Super.SetPosition(Holder);
}

defaultproperties
{
	Begin Object class=AnimNodeSequence Name=MeshSequenceA
	End Object

	Begin Object Name=FirstPersonMesh
		SkeletalMesh=SkeletalMesh'WP_Translocator.Mesh.SK_WP_Translocator_1P'
		PhysicsAsset=None
		AnimSets(0)=AnimSet'WP_Translocator.Anims.K_WP_Translocator_1P_Base'
		Materials(0)=MaterialInterface'WP_Translocator.Materials.M_Gun_Ark'
		Materials(1)=Material'EM_XX_Content.Trans_Blue_Final'
		Animations=MeshSequenceA
		Scale=1.65
		FOV=55.0
	End Object

	Begin Object Name=PickupMesh
		SkeletalMesh=SkeletalMesh'EM_XX_Content.Mesh.Trans_3P'
		Materials(0)=MaterialInterface'WP_Translocator.Materials.M_Gun_Ark'
		Materials(1)=Material'EM_XX_Content.Trans_Blue_Final'		
	End Object

   AttachmentClass=class'EM_XX.TransElite_Attach'
   FireInterval(0)=.1
   FireInterval(1)=.1
	SkinColors(0)=(R=.5,G=0.5,B=0.5)  //(R=3.4,G=0.5,B=0.1)
	SkinColors(1)=(R=0.2,G=0.5,B=3.4)

   FireOffset=(X=0,Y=0,Z=0)  //

   TeamSkins(0)=Material'EM_XX_Content.Trans_Final'
   TeamSkins(1)=Material'EM_XX_Content.Trans_Blue_Final'

	WeaponFireSnd[0]=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_Fire_Cue'
	WeaponFireSnd[1]=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_Teleport_Cue'
	WeaponEquipSnd=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_Raise_Cue'
	WeaponPutDownSnd=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_Lower_Cue'
	TransRecalledSound=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_Recall_Cue'

   WeaponFireTypes(0)=EWFT_Projectile
   WeaponFireTypes(1)=EWFT_Custom
   WeaponProjectiles(0)=Class'EM_XX.TransElite_ContentRed'
   WeaponProjectiles(1)=Class'EM_XX.TransElite_ContentBlue'
	FiringStatesArray(1)=RecallFire

	ArmsAnimSet=AnimSet'WP_Translocator.Anims.K_WP_Translocator_1P_Arms'
	FailedTranslocationDamageClass=class'EM_XX.TransElite_DMG_Fail'
	
	EmptyIdleAnim=WeaponIdleEmpty
	WeaponFireAnim(0)=WeaponFire
	WeaponFireAnim(1)=none
	ArmFireAnim(0)=WeaponFire
	ArmFireAnim(1)=none
        
	MuzzleFlashSocket=MuzzleFlash
	DisruptionDeath=SoundCue'A_Weapon_Translocator.Translocator.A_Weapon_Translocator_DisruptedTeleport_Cue'

   AmmoCount=1
   MaxAmmoCount=1
   InventoryGroup=0
   EquipTime=0.3
   PutDownTime=0.3
   RechargeRate=10
   bExportMenuData=True
   DroppedPickupMesh=PickupMesh
   PickupFactoryMesh=PickupMesh
   Priority=1000.9
   ItemName="Trans Elite"
   Name="Elite Translocator"
}
