/*
 * Weapon:  Redeem Machine DMG
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class RedeemMachine_DMG extends UTDmgType_Burning
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   NodeDamageScaling=class'MutEM_XX'.default.Config_RedeemMachine.fNodeDamageScaling;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_RedeemMachine.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_RedeemMachine.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

static function SpawnHitEffect(Pawn P, float Damage, vector Momentum, name BoneName, vector HitLocation)
{
	local UTEmit_VehicleHit BF;

	if ( Vehicle(P) != None )
	{
		BF = P.spawn(class'UTEmit_VehicleHit',P,, HitLocation, rotator(Momentum));
		BF.AttachTo(P, BoneName);
	}
	else
	{
		Super.SpawnHitEffect(P, Damage, Momentum, BoneName, HitLocation);
	}
}

defaultproperties
{
	RewardCount=5
	RewardEvent=REWARD_BIGGAMEHUNTER
	RewardAnnouncementSwitch=8

   DamageBodyMatColor=(R=10)
   DamageOverlayTime=1
   DeathOverlayTime=1

   DamageWeaponClass=Class'EM_XX.RedeemMachine'

   KillStatsName="KILLS_REDEEM_MACHINE"
   DeathStatsName="DEATHS_REDEEM_MACHINE"
   SuicideStatsName="SUICIDES_REDEEM_MACHINE"

   VehicleDamageScaling=1
   NodeDamageScaling=1

   DeathString="`k Ovliverated `o with the Redeem M@chine."
   FemaleSuicide="`o Obliverated her Body."
   MaleSuicide="`o Obliverated his Body."

   bAlwaysGibs=True
   bNeverGibs=False
   GibPerterbation=0.01
}