/*
 * Weapon:  RedeemMachine
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class RedeemMachine extends UTWeap_SniperRifle
	dependson(MutEM_XX);

/** Used for Range Display */
var float TargetRange;

/** Regulates the amount of recoil the weapon has */
var() int DeemerRecoil;

var Texture2D SideMaterial;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

   AmmoCount=class'MutEM_XX'.default.Config_RedeemMachine.iAmmoCount;
   LockerAmmoCount=class'MutEM_XX'.default.Config_RedeemMachine.iAmmoCount;
   MaxAmmoCount=class'MutEM_XX'.default.Config_RedeemMachine.iMaxAmmo;

   ZoomedTargetFOV=class'MutEM_XX'.default.Config_RedeemMachine.iZoomFOV;
   ZoomedRate=class'MutEM_XX'.default.Config_RedeemMachine.iZoomRate;

   CurrentRating=class'MutEM_XX'.default.Config_RedeemMachine.fAIRating;
   AIRating=class'MutEM_XX'.default.Config_RedeemMachine.fAIRating;
	MaxDesireability=class'MutEM_XX'.default.Config_RedeemMachine.fAIRating;
	
	ShotCost[0]=class'MutEM_XX'.default.Config_RedeemMachine.iShotCost;

	DeemerRecoil=class'MutEM_XX'.default.Config_RedeemMachine.iDeemerRecoil;
}

simulated function PlayFireEffects( byte FireModeNum, optional vector HitLocation )
{
	// Play Weapon fire animation

	if ( FireModeNum < WeaponFireAnim.Length && WeaponFireAnim[FireModeNum] != '' )
		PlayWeaponAnimation( WeaponFireAnim[FireModeNum], GetFireInterval(FireModeNum) );
	if ( FireModeNum < ArmFireAnim.Length && ArmFireAnim[FireModeNum] != '' && ArmsAnimSet != none)
		PlayArmAnimation( ArmFireAnim[FireModeNum], GetFireInterval(FireModeNum) );

	// Start muzzle flash effect
	CauseMuzzleFlash();
   ProcessRecoil();
	ShakeView();
}

simulated function ProcessInstantHit( byte FiringMode, ImpactInfo Impact )
{
}

/* I'm making the recoil being handled in this function */
simulated function ProcessRecoil()
{
   if (Instigator != None)
   {	// Recoil will knock the player back
      Instigator.AddVelocity( Normal(vector(Rotation) * -1 ) * class'MutEM_XX'.default.Config_RedeemMachine.iDeemerRecoil / Instigator.Mass,
	   Instigator.Location,
	   InstantHitDamageTypes[0] );
   }
}

//////////////////////////////////////
// Zoom Display
//////////////////////////////////////
simulated function DrawZoomedOverlay( HUD H )
{
//Crosshair
	local float ScaleX, ScaleY, StartX;
	local float OldOrgX, OldOrgY, OldClipX, OldClipY;
   local Vector X,Y,Z;
   local vector HitLocation, HitNormal;
   local float Scale;

	// ... They ignore the safe region.
	OldOrgX = H.Canvas.OrgX;
	OldOrgY = H.Canvas.OrgY;
	OldClipX = H.Canvas.ClipX;
	OldClipY = H.Canvas.ClipY;
	H.Canvas.OrgX = 0.0;
	H.Canvas.OrgY = 0.0;
	H.Canvas.ClipX = H.Canvas.SizeX;
	H.Canvas.ClipY = H.Canvas.SizeY;

	bDisplayCrosshair = false;  // whether to display the crosshair while zooming - for aligning crosshairs

	ScaleY = H.Canvas.ClipY/768.0;
	ScaleX = ScaleY;
	StartX = 0.5*H.Canvas.ClipX - 512.0*ScaleX;

//Display Different color if damage can hurt you or out of range
   if (TargetRange >= 1100 && TargetRange < 100000)
   {
   H.Canvas.DrawColor.R = 255;
	H.Canvas.DrawColor.G = 255;
	H.Canvas.DrawColor.B = 255;
   }

   else
   {
   H.Canvas.DrawColor.R = 255; //Red
	H.Canvas.DrawColor.G = 0;
	H.Canvas.DrawColor.B = 0;
   }

//Random Numbers
   H.Canvas.SetPos(10,60);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));
   H.Canvas.SetPos(30,80);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));

//Side Text
	H.Canvas.SetPos(10,100);
        H.Canvas.DrawText("2008 Elite Machines");

	H.Canvas.SetPos(10,120);
        H.Canvas.DrawText("Redeem Machine");

//Side Image
   H.Canvas.SetPos(10,140);
        H.Canvas.DrawTexture(SideMaterial, 1);

//Zoom Multiplier Display
   scale = PlayerController(Instigator.Controller).DefaultFOV/PlayerController(Instigator.Controller).DesiredFOV;
   H.Canvas.SetPos(10,195);
        H.Canvas.DrawText("X"$int(Scale)$"."$int(10 * scale - 10 * int(Scale)));

//Multi-Color Range Display - Measure in Unreal Units
   H.Canvas.SetPos(10,215);
      GetViewAxes(X,Y,Z);
      Trace(HitLocation, HitNormal, Instigator.Location + (X * 100001), Instigator.Location, true);
      TargetRange = VSize(Instigator.Location + Instigator.BaseEyeHeight * vect(0,0,1) - HitLocation);

   if (TargetRange > 100000)
   {
   TargetRange = 0;
   H.Canvas.DrawText("Range:"@TargetRange$" UU ");
   }
   else
   {
   H.Canvas.DrawText("Range:"@TargetRange$" UU ");
   }

// More Random Numbers
   H.Canvas.SetPos(30,235);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));
   H.Canvas.SetPos(10,255);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));

//Display Different color if damage can hurt you or out of range
   if (TargetRange >= 1100 && TargetRange < 100000)
   {
   H.Canvas.DrawColor.R = 0;
	H.Canvas.DrawColor.G = 255;
	H.Canvas.DrawColor.B = 0;
   }

   else
   {
   H.Canvas.DrawColor.R = 255; //Red
	H.Canvas.DrawColor.G = 0;
	H.Canvas.DrawColor.B = 0;
   }

	// Draw the crosshair
	// Draw the 4 corners
	H.Canvas.SetPos(StartX, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 0, 510, 383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 0, -510, 383);

	H.Canvas.SetPos(StartX, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 383, 510, -383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 383, -510, -383);

	if ( StartX > 0 )
	{
		// Draw the Horizontal Borders
		H.Canvas.SetPos(0.0, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 0, 3, 383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 0, -3, 383);

		H.Canvas.SetPos(0.0, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 383, 3, -383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 383, -3, -383);
	}

	// restore the canvas parameters
	H.Canvas.OrgX = OldOrgX;
	H.Canvas.OrgY = OldOrgY;
	H.Canvas.ClipX = OldClipX;
	H.Canvas.ClipY = OldClipY;

}

simulated function PreloadTextures(bool bForcePreload)
{
	Super.PreloadTextures(bForcePreload);

	if (HUDMaterial != None)
	{
		HUDMaterial.bForceMiplevelsToBeResident = bForcePreload;
	}
	if (SideMaterial != None)
	{
		SideMaterial.bForceMiplevelsToBeResident = bForcePreload;
	}
}

// Take away the weapon after using up ammo
simulated function bool AllowSwitchTo(Weapon NewWeapon)
{
	local UTGameReplicationInfo GRI;

	GRI = UTGameReplicationInfo(WorldInfo.GRI);
	return ( (AmmoCount <= 0 || GRI == None || !GRI.bConsoleServer || (UTInventoryManager(InvManager) != None && UTInventoryManager(InvManager).bInfiniteAmmo))
		&& Super.AllowSwitchTo(NewWeapon) );
}

auto state Inactive
{
	simulated function BeginState(name PreviousStateName)
	{
		Super.BeginState(PreviousStateName);

		// destroy if we're out of ammo, since there are no Redeemer ammo pickups
		if (Role == ROLE_Authority && !HasAnyAmmo())
		{
			Destroy();
		}
	}
}

/*********************************************************************************************
 * AI Interface
 *********************************************************************************************/

function float SuggestAttackStyle()
{
	local float EnemyDist;

	if (Instigator.Controller.Enemy != None)
	{
		// recommend backing off if target is too close
		EnemyDist = VSize(Instigator.Controller.Enemy.Location - Owner.Location);
		if ( EnemyDist < 750 )
		{
			return (EnemyDist < 1020) ? -1.5 : -0.7;
		}
		else if (EnemyDist > 3600)
		{
			return 0.5;
		}
	}

	return -0.1;
}

// tell bot how valuable this weapon would be to use, based on the bot's combat situation
// also suggest whether to use regular or alternate fire mode
function float GetAIRating()
{
	local UTBot B;
	local float EnemyDist, Rating, ZDiff;
	local vector EnemyDir;

	B = UTBot(Instigator.Controller);
	if ( (B == None) || (B.Enemy == None) )
		return AIRating;

	// if standing on a lift, make sure not about to go around a corner and lose sight of target
	// (don't want to blow up a rocket in bot's face)
	if ( (Instigator.Base != None) && (Instigator.Base.Velocity != vect(0,0,0))
		&& !B.CheckFutureSight(0.1) )
		return 0.1;

	EnemyDir = B.Enemy.Location - Instigator.Location;
	EnemyDist = VSize(EnemyDir);
	Rating = AIRating;

	// don't pick rocket launcher if enemy is too close
	if ( EnemyDist < 1000 )
	{
		if ( Instigator.Weapon == self )
		{
			// don't switch away from rocket launcher unless really bad tactical situation
			if ( (EnemyDist > 650) || ((Instigator.Health < 80) && (Instigator.Health < B.Enemy.Health - 30)) )
				return Rating;
		}
		return 0.05 + EnemyDist * 0.001;
	}

	// rockets are good if higher than target, bad if lower than target
	ZDiff = Instigator.Location.Z - B.Enemy.Location.Z;
	if ( ZDiff > 120 )
		Rating += 0.25;
	else if ( ZDiff < -160 )
		Rating -= 0.35;
	else if ( ZDiff < -80 )
		Rating -= 0.05;
	if ( (B.Enemy.Weapon != None) && B.Enemy.Weapon.bMeleeWeapon && (EnemyDist < 8500) )
		Rating += 0.25;

	return Rating;
}

/* BestMode()
choose between regular or alt-fire
*/
function byte BestMode()
{
	return 0;
}

defaultproperties
{
   bSuperWeapon=True
	bDelayedSpawn=True
	RespawnTime=90.0

	// Weapon SkeletalMesh
	Begin Object Name=FirstPersonMesh
	    SkeletalMesh=SkeletalMesh'WP_SniperRifle.Mesh.SK_WP_SniperRifle_1P'
	        Materials(0)=Material'EM_XX_Content.Tiger_Final'  //Material'EM_XX_Content.Deemer_Final'
		AnimSets(0)=AnimSet'WP_SniperRifle.Anims.K_WP_SniperRifle_1P_Base'
		Animations=MeshSequenceA
		Scale=1.5
		bForceUpdateAttachmentsInTick=true
		FOV=65
	End Object

	// Pickup staticmesh
	Components.Remove(PickupMesh)
	Begin Object Name=PickupMesh
		SkeletalMesh=SkeletalMesh'EM_XX_Content.Mesh.Deemer_3P'
		Materials(0)=Material'EM_XX_Content.Tiger_Final'  //Material'EM_XX_Content.Deemer_Final'
	End Object

   TeamSkins(0)=Material'EM_XX_Content.Tiger_Final'
   TeamSkins(1)=Material'EM_XX_Content.Tiger_Final'

	CrossHairCoordinates=(U=320,V=64,UL=64,VL=64)

   bRecommendSplashDamage=True
   WeaponFireTypes(0)=EWFT_Projectile
   WeaponProjectiles(0)=Class'EM_XX.RedeemMachine_ProJ'
   
   HudMaterial=Texture2D'EM_XX_Content.Scope512'
   SideMaterial=Texture2D'EM_XX_Content.steeldev'

   WeaponFireSnd(0)=SoundCue'EM_XX_Content.Deemer_fireCue'
   ZoomLoopCue=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ZoomLoop_Cue'
   WeaponFireAnim(0)="WeaponFire"
   WeaponFireAnim(1)="WeaponIdle"
   WeaponRange=100000.000000
   AmmoCount=1
   LockerAmmoCount=1
   MaxAmmoCount=3
   ZoomedTargetFOV=40.000000
   ZoomedRate=0.5000000
   AttachmentClass=Class'EM_XX.RedeemMachine_Attach'
   ArmsAnimSet=none
   WeaponPutDownSnd=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_Lower_Cue'
   WeaponEquipSnd=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_Raise_Cue'  //SoundCue'EM_XX_Content.Deemer_fearmeCue'
   PickupSound=SoundCue'EM_XX_Content.Deemer_fearmeCue'
   WeaponColor=(B=0,G=0,R=155)
   MuzzleFlashPSCTemplate=ParticleSystem'WP_RocketLauncher.Effects.P_WP_RockerLauncher_Muzzle_Flash'
   MuzzleFlashLightClass=Class'UTGame.UTRocketMuzzleFlashLight'

   FireInterval(0)=2
   FireInterval(1)=2
   EquipTime=0.3
   PutDownTime=0.3
   ItemName="Redeem Machine"
   PickupMessage="Redeem M@chine"
   Name="Redeem M@chine"

   AIRating=+1.59
   Priority=1000.9
   bExportMenuData=True
   ObjectArchetype=UTWeapon'UTGame.Default__UTWeap_SniperRifle'
   InventoryGroup=10
}