Class MultiJump_Info Extends Info
	dependson(MutEM_XX);

var UTPlayerController PC;

var() int riMaxNumJumps;
var() int riMaxJumpBoost;

Replication
{
	if( bNetDirty && ( Role == ROLE_Authority ) && bNetInitial )
		riMaxNumJumps, riMaxJumpBoost, PC;
} 

simulated function Tick( float dt )
{
	local UTPawn PlayerPawn;

	if( WorldInfo.NetMode != NM_Client && PC == None )
	{
		PC = UTPlayerController( Owner );

        // Still none clean up
		if( PC == None )
		{
			Destroy();
			return;
		}
	}

	// If we have the player controller
	if( PC != None )
	{
		// Grab the pawn
		PlayerPawn = UTPawn( PC.Pawn );
		if( PlayerPawn != None && PlayerPawn.MaxMultiJump != riMaxNumJumps )
		{
			// Set the various values
			PlayerPawn.MaxMultiJump = riMaxNumJumps;
			PlayerPawn.MultiJumpBoost = riMaxJumpBoost;
			PlayerPawn.MultiJumpRemaining = riMaxNumJumps;
		}
	}
}

defaultproperties
{
   RemoteRole=ROLE_SimulatedProxy
   bAlwaysRelevant=True
}
