/*
 * Weapon:  Goliath Cannon
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class Goliath_Cannon_ProJ extends UTProj_TankShell
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	DamageRadius=class'MutEM_XX'.default.Config_GoliathCannon.iDmgRadius;
	Damage=class'MutEM_XX'.default.Config_GoliathCannon.iDamage;
	MomentumTransfer=class'MutEM_XX'.default.Config_GoliathCannon.iMomentum;
	speed=class'MutEM_XX'.default.Config_GoliathCannon.iSpeed;
	MaxSpeed=class'MutEM_XX'.default.Config_GoliathCannon.iSpeed;
}

defaultproperties
{
	ProjFlightTemplate=ParticleSystem'VH_Goliath.Effects.PS_Goliath_Cannon_Trail'

	DistanceExplosionTemplates[0]=(Template=ParticleSystem'VH_Goliath.Effects.PS_Goliath_Cannon_Impact_FAR',MinDistance=3000.0)
	DistanceExplosionTemplates[1]=(Template=ParticleSystem'VH_Goliath.Effects.PS_Goliath_Cannon_Impact_MID',MinDistance=400.0)
	DistanceExplosionTemplates[2]=(Template=ParticleSystem'VH_Goliath.Effects.PS_Goliath_Cannon_Impact_Close',MinDistance=0.0)

	MaxExplosionLightDistance=+7000.0
	speed=15000
//	AccelRate=12000
	MaxSpeed=15000.0
	Damage=360
	DamageRadius=600
	MomentumTransfer=150000
	MyDamageType=class'EM_XX.Goliath_Cannon_DMG'
	LifeSpan=4
	AmbientSound=SoundCue'A_Weapon_RocketLauncher.Cue.A_Weapon_RL_Travel_Cue'
	ExplosionSound=SoundCue'A_Vehicle_Goliath.SoundCues.A_Vehicle_Goliath_Explode'
	RotationRate=(Roll=50000)
	DesiredRotation=(Roll=30000)
	bCollideWorld=true
	ExplosionLightClass=class'UTGame.UTTankShellExplosionLight'
	ExplosionDecal=MaterialInterface'VH_Goliath.Materials.DM_Goliath_Cannon_Decal'
	DecalWidth=350
	DecalHeight=350

	bWaitForEffects=true
	bAttachExplosionToVehicles=false
}