/*
 * Weapon:  Goliath Cannon
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class Goliath_Cannon_DMG extends UTDmgType_AvrilRocket
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	VehicleDamageScaling=class'MutEM_XX'.default.Config_GoliathCannon.fVehicleDamageScaling;
	VehicleMomentumScaling=class'MutEM_XX'.default.Config_GoliathCannon.fVehicleMomentumScaling;
	NodeDamageScaling=class'MutEM_XX'.default.Config_GoliathCannon.fNodeDamageScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

static function int IncrementKills(UTPlayerReplicationInfo KillerPRI)
{
	if ( PlayerController(KillerPRI.Owner) != None )
	{
		PlayerController(KillerPRI.Owner).ReceiveLocalizedMessage( class'UTWeaponKillRewardMessage', 1 );
	}
	return super.IncrementKills(KillerPRI);
}

defaultproperties
{
	KillStatsName=KILLS_Goliath_Cannon
	DeathStatsName=DEATHS_Goliath_Cannon
	SuicideStatsName=SUICIDES_Goliath_Cannon

   DeathString="`o caught `k's Tank Shell"
   FemaleSuicide="`o fired her Goliath Cannon a little to close."
   MaleSuicide="`o fired his Goliath Cannon a little to close."

	RewardCount=10
	RewardEvent=REWARD_BIGGAMEHUNTER
	RewardAnnouncementSwitch=8

	DamageWeaponClass=class'EM_XX.Goliath_Cannon'
	DamageWeaponFireMode=0

	VehicleDamageScaling=1
	VehicleMomentumScaling=1

	bKRadialImpulse=true
   KDamageImpulse=3000
	KImpulseRadius=100.0

   bAlwaysGibs=True
   bNeverGibs=False
   GibPerterbation=2
}