/*
 * Weapon:  Goliath Cannon
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class Goliath_Cannon extends UTWeapon
	dependson(MutEM_XX);

/////////////////////////////// Main Weap Stuff /////////////////////////

/** Regulates the amount of recoil the weapon has */
var() int GoliathRecoil;

/** If you shortcircut the reload, the time will get deferred until you bring the weapon back up */
var float DeferredReloadTime;

/** How long the reload sequence takes*/
var float ReloadTime;

/** How long the fire sequence takes*/
var float FireTime;

/** Animation to play when there is no ammo*/
var name NoAmmoWeaponPutDownAnim;

/** Anim to play while reloading */
var name WeaponReloadAnim;
var AudioComponent ReloadSound;
var SoundCue ReloadCue;

/** The speed of a deferred reload */
var float ReloadAnimSpeed;

/////////////////////////////// Sniper Stuff ////////////////////////////

/** Used for loading 2D Textures*/
var Texture2D SideMaterial;
var Texture2D HudMaterial;

/** Used for Range Display*/
var float	FadeTime;
var float   TargetRange;
 
/** Misc from Sniper Rifle*/
var audiocomponent ZoomLoop;
var soundcue ZoomLoopCue;
var bool bDisplayCrosshair;
var bool bAbortZoom;
var int ZoomCount;

////////////////////////////////////////////// Main Weapon Stuff ////////////////////////////////////

replication
{
	if (bNetDirty)
		DeferredReloadTime;
}

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	AmmoCount=class'MutEM_XX'.default.Config_GoliathCannon.iAmmoCount;
	LockerAmmoCount=class'MutEM_XX'.default.Config_GoliathCannon.iAmmoCount;
	MaxAmmoCount=class'MutEM_XX'.default.Config_GoliathCannon.iMaxAmmo;

	FireInterval[0]=class'MutEM_XX'.default.Config_GoliathCannon.fFireInterval;

	ZoomedTargetFOV=class'MutEM_XX'.default.Config_GoliathCannon.fZoomFOV;
	ZoomedRate=class'MutEM_XX'.default.Config_GoliathCannon.iZoomRate;

	ShotCost[0]=class'MutEM_XX'.default.Config_GoliathCannon.iShotCost;

	AIRating=class'MutEM_XX'.default.Config_GoliathCannon.fAIRating;
	MaxDesireability=class'MutEM_XX'.default.Config_GoliathCannon.fAIRating;
	CurrentRating=class'MutEM_XX'.default.Config_GoliathCannon.fAIRating;

	GoliathRecoil=class'MutEM_XX'.default.Config_GoliathCannon.iGoliathRecoil;
}

/**
 * We override TryPutDown so that we can store the deferred amount of time.
 */
simulated function bool TryPutDown()
{
	local float MinTimerTarget;
	local float TimerRate;
	local float TimerCount;

	bWeaponPutDown = true;

	TimerRate = GetTimerRate('RefireCheckTimer');
	if ( TimerRate > 0 )
	{
		MinTimerTarget = TimerRate * MinReloadPct[CurrentFireMode];
		TimerCount = GetTimerCount('RefireCheckTimer');

		if (TimerCount > MinTimerTarget)
		{
			DeferredReloadTime = TimerRate - TimerCount;
			PutDownWeapon();
			return true;
		}
		else
		{
			// Shorten the wait time
			SetTimer( MinTimerTarget - TimerCount , false, 'RefireCheckTimer');
			DeferredReloadTime = TimerRate - MinTimerTarget - (MinTimerTarget - TimerCount);
			return true;
		}
	}
	else
	{
		DeferredReloadTime = 0;
		return true;
	}

	return false;
}

simulated function float GetEquipTime()
{
	local float NewEquipTime;
	NewEquipTime = Super.GetEquipTime();

	if (DeferredReloadTime > NewEquipTime)
	{
		NewEquipTime = DeferredReloadTime;
	}

	DeferredReloadTime = 0;

	return NewEquipTime;
}

simulated function PlayWeaponEquip()
{
	ReloadAnimSpeed =GetTimerRate('WeaponEquipped') - GetTimerCount('WeaponEquipped') - super.GetEquipTime();
	super.PlayWeaponEquip();
	if(ReloadAnimSpeed > 0)
	{
		setTimer(EquipTime,false,'FastReload');
	}
}
simulated function FastReload()
{
	PlayReloadAnim(ReloadAnimSpeed);
	ReloadAnimSpeed=0.0f;
}

// AI Interface

function float SuggestDefenseStyle()
{
	return 0.5;
}

function byte BestMode()
{
	return 0;
}

function bool RecommendRangedAttack()
{
	local UTBot B;

	B = UTBot(Instigator.Controller);
	if (B == None || B.Enemy == None)
	{
		return true;
	}

	return (VSize(B.Enemy.Location - Instigator.Location) > 2000.0 * (1.0 + FRand()));
}
// end AI Interface

simulated function WeaponEmpty()
{
	// If we were firing, stop
	if (IsFiring())
	{
		GotoState('Active');
	}

	if ( Instigator != none && Instigator.IsLocallyControlled())
	{
		Instigator.InvManager.SwitchToBestWeapon( true );
	}
}

simulated function PlayFireEffects( byte FireModeNum, optional vector HitLocation )
{
	local float TotalFireTime;

	if (IsZero(HitLocation))
	{
		// rocket fired

		// Play Weapon fire animation
		if ( FireModeNum < WeaponFireAnim.Length && WeaponFireAnim[FireModeNum] != '' )
		{
			TotalFireTime = FireTime*((UTPawn(Owner)!= None) ? UTPawn(Owner).FireRateMultiplier : 1.0);
			PlayWeaponAnimation( WeaponFireAnim[FireModeNum], TotalFireTime);
			PlayArmAnimation(WeaponFireAnim[FireModeNum], TotalFireTime, false);
			SetTimer(TotalFireTime,false,'PlayReloadAnim');
		}

		// Start muzzle flash effect & recoil
		CauseMuzzleFlash();
      ProcessRecoil();
		ShakeView();
	}
}

/* I'm making the recoil being handled in this function */
simulated function ProcessRecoil()
{
	// Not supposed to happen!
	if (CurrentFireMode == 1)
		return;

		if (Instigator != None)
		{	// Recoil will knock the player back
			Instigator.AddVelocity( Normal(vector(Rotation) * -1 ) * class'MutEM_XX'.default.Config_GoliathCannon.iGoliathRecoil / Instigator.Mass,
				Instigator.Location,
	   InstantHitDamageTypes[0] );
		}
}

simulated function PlayReloadAnim(optional float ReloadOverrideTime)
{
	local float ReloadFinal;
	if(AmmoCount > 0)
	{
		if (ReloadOverrideTime != 0.0)
		{
			ReloadFinal = ReloadOverrideTime;
		}
		else
		{
			ReloadFinal = ReloadTime;
			if (UTPawn(Owner) != None)
			{
				ReloadFinal *= UTPawn(Owner).FireRateMultiplier;
			}
		}
		PlayWeaponAnimation(WeaponReloadAnim,ReloadFinal);
		PlayArmAnimation(WeaponReloadAnim,ReloadFinal);
		if(ReloadSound == none)
		{
			ReloadSound = CreateAudioComponent(ReloadCue, false, true);
		}
		if(ReloadSound != none)
		{
			ReloadSound.PitchMultiplier = ReloadTime/ReloadFinal;
			ReloadSound.Play();
		}
	}
}

simulated function PlayWeaponPutDown()
{
	if(ReloadSound != none)
	{
		ReloadSound.FadeOut(0.1,0.0);
		ReloadSound = none;
	}
	if(AmmoCount > 0)
		WeaponPutDownAnim = default.WeaponPutDownAnim;
	else
		WeaponPutDownAnim = NoAmmoWeaponPutDownAnim;
	super.PlayWeaponPutDown();
}

simulated state WeaponFiring
{
	simulated event EndState( Name NextStateName )
	{
		// do not call ClearFlashLocation() here as that is for the beam which may still be firing

		// Set weapon as not firing
		ClearFlashCount();
		ClearTimer('RefireCheckTimer');

		if (Instigator != none && AIController(Instigator.Controller) != None)
		{
			AIController(Instigator.Controller).NotifyWeaponFinishedFiring(self,CurrentFireMode);
		}
	}
}

simulated state WeaponPuttingDown
{
	simulated function float GetAbortPutDownTime()
	{
		local float Time;

		Time = GetAbortPutDownTime();  //Super.GetAbortPutDownTime();

		if (DeferredReloadTime > Time)
		{
			Time = DeferredReloadTime;
		}
		DeferredReloadTime = 0;

		return Time;
	}
}

simulated state WeaponEquipping
{
	simulated function bool TryPutDown()
	{
		local float EquipTimeRemaining;

		// make sure aborting an equip won't cancel any extra time due to reloading
		EquipTimeRemaining = GetTimerRate('WeaponEquipped') - GetTimerCount('WeaponEquipped');
		if (EquipTimeRemaining > EquipTime)
		{
			DeferredReloadTime = EquipTimeRemaining;
		}

		return Super.TryPutDown();
	}
}

auto state Inactive
{
	simulated function BeginState(name PreviousStateName)
	{
		Super.BeginState(PreviousStateName);

		// destroy if we're out of ammo, since there are no Goliath Cannon ammo pickups
		if (Role == ROLE_Authority && !HasAnyAmmo())
		{
			Destroy();
		}
	}
}

simulated event Destroyed()
{
	// make sure client finishes any in-progress switch away from this weapon
	if (Instigator != None && Instigator.Weapon == self && InvManager != None && InvManager.PendingWeapon != None)
	{
		Instigator.InvManager.ChangedWeapon();
	}

	Super.Destroyed();
}

///////////////////////////////////////////  SNIPER STUFF  ///////////////////////////////////

//////////////////////////////////////
// Zoom Display
//////////////////////////////////////
simulated function DrawZoomedOverlay( HUD H )
{
//Crosshair
	local float ScaleX, ScaleY, StartX;
	local float OldOrgX, OldOrgY, OldClipX, OldClipY;
   local Vector X,Y,Z;
   local vector HitLocation, HitNormal;
   local float Scale;

	// ... They ignore the safe region.
	OldOrgX = H.Canvas.OrgX;
	OldOrgY = H.Canvas.OrgY;
	OldClipX = H.Canvas.ClipX;
	OldClipY = H.Canvas.ClipY;
	H.Canvas.OrgX = 0.0;
	H.Canvas.OrgY = 0.0;
	H.Canvas.ClipX = H.Canvas.SizeX;
	H.Canvas.ClipY = H.Canvas.SizeY;

	bDisplayCrosshair = false;  // whether to display the crosshair while zooming - for aligning crosshairs

	ScaleY = H.Canvas.ClipY/768.0;
	ScaleX = ScaleY;
	StartX = 0.5*H.Canvas.ClipX - 512.0*ScaleX;

//Display Different color if damage can hurt you or out of range
   if (TargetRange >= class'MutEM_XX'.default.Config_GoliathCannon.iDmgRadius && TargetRange < 100000)
   {
   H.Canvas.DrawColor.R = 0;
	H.Canvas.DrawColor.G = 0;
	H.Canvas.DrawColor.B = 0;
   }

   else  //if (TargetRange <= class'MutEM_XX'.default.Config_BioMod.iDamageRadius)
   {
   H.Canvas.DrawColor.R = 255; //Red
	H.Canvas.DrawColor.G = 0;
	H.Canvas.DrawColor.B = 0;
   }

//Random Numbers
   H.Canvas.SetPos(10,60);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));
   H.Canvas.SetPos(30,80);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));

//Side Text
	H.Canvas.SetPos(10,100);
        H.Canvas.DrawText("2008 Elite Machines");

	H.Canvas.SetPos(10,120);
        H.Canvas.DrawText("Goliath Cannon");

//Side Image
   H.Canvas.SetPos(10,140);
        H.Canvas.DrawTexture(SideMaterial, 1);

//Zoom Multiplier Display
   scale = PlayerController(Instigator.Controller).DefaultFOV/PlayerController(Instigator.Controller).DesiredFOV;
   H.Canvas.SetPos(10,195);
        H.Canvas.DrawText("X"$int(Scale)$"."$int(10 * scale - 10 * int(Scale)));

//Multi-Color Range Display - Measure in Unreal Units
   H.Canvas.SetPos(10,215);
      GetViewAxes(X,Y,Z);
      Trace(HitLocation, HitNormal, Instigator.Location + (X * 100001), Instigator.Location, true);
      TargetRange = VSize(Instigator.Location + Instigator.BaseEyeHeight * vect(0,0,1) - HitLocation);

   if (TargetRange > 100000)
   {
   TargetRange = 0;
   H.Canvas.DrawText("Range:"@TargetRange$" UU ");
   }
   else
   {
   H.Canvas.DrawText("Range:"@TargetRange$" UU ");
   }

// More Random Numbers
   H.Canvas.SetPos(30,235);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));
   H.Canvas.SetPos(10,255);
      H.Canvas.DrawText(""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19)$""$Rand(19));

//Display Different color if damage can hurt you or out of range
   if (TargetRange >= 0.5 * class'MutEM_XX'.default.Config_GoliathCannon.iDmgRadius && TargetRange < 100000)
   {
   H.Canvas.DrawColor.R = 197;
	H.Canvas.DrawColor.G = 197;
	H.Canvas.DrawColor.B = 197;
   }

   else  //if (TargetRange <= class'MutEM_XX'.default.Config_BioMod.iDamageRadius)
   {
   H.Canvas.DrawColor.R = 255; //Red
	H.Canvas.DrawColor.G = 0;
	H.Canvas.DrawColor.B = 0;
   }


	// Draw the crosshair
	// Draw the 4 corners
	H.Canvas.SetPos(StartX, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 0, 510, 383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 0, -510, 383);

	H.Canvas.SetPos(StartX, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 383, 510, -383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 383, -510, -383);

	if ( StartX > 0 )
	{
		// Draw the Horizontal Borders
		H.Canvas.SetPos(0.0, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 0, 3, 383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 0, -3, 383);

		H.Canvas.SetPos(0.0, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 383, 3, -383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 383, -3, -383);
	}

	// restore the canvas parameters
	H.Canvas.OrgX = OldOrgX;
	H.Canvas.OrgY = OldOrgY;
	H.Canvas.ClipX = OldClipX;
	H.Canvas.ClipY = OldClipY;

}


// Draw the crosshair
simulated function DrawWeaponCrosshair( Hud HUD )
{
	local EZoomState ZoomState;
	local float FadeValue;
	local UTPlayerController PC;

	ZoomState = GetZoomedState();

	if ( ZoomState != ZST_NotZoomed )
	{
		if ( ZoomState > ZST_ZoomingOut )
		{
			DrawZoomedOverlay(HUD);
		}
		else
		{
			FadeValue = 255 * ( 1.0 - (WorldInfo.TimeSeconds - ZoomFadeTime)/FadeTime);
			HUD.Canvas.DrawColor.A = FadeValue;
			HUD.Canvas.SetPos(0,0);
			HUD.Canvas.DrawTile( Texture2D 'EngineResources.Black', HUD.Canvas.SizeX, HUD.Canvas.SizeY, 0.0, 0.0, 16, 16);
		}
	}
	if( bDisplayCrosshair )
	{
		PC = UTPlayerController(Instigator.Controller);
		if ( (PC == None) || PC.bNoCrosshair )
		{
			return;
		}
		super.DrawWeaponCrosshair(HUD);
	}
}

// Must preload textures
simulated function PreloadTextures(bool bForcePreload)
{
	Super.PreloadTextures(bForcePreload);

	if (HUDMaterial != None)
	{
		HUDMaterial.bForceMiplevelsToBeResident = bForcePreload;
	}
	if (SideMaterial != None)
	{
		SideMaterial.bForceMiplevelsToBeResident = bForcePreload;
	}
}

/** Called when zooming starts
 * @param PC - cast of Instigator.Controller for convenience
 */
simulated function StartZoom(UTPlayerController PC)
{
	ZoomCount++;
	if (ZoomCount == 1 && !IsTimerActive('Gotozoom') && IsActiveWeapon() && HasAmmo(0) && Instigator.IsFirstPerson())
	{
		bDisplayCrosshair = false;
		bAbortZoom = false;
		SetTimer(0.2, false, 'Gotozoom');
	}
}

simulated function EndFire(Byte FireModeNum)
{
	local UTPlayerController PC;

	// Don't bother performing if this is a dedicated server

	if (WorldInfo.NetMode != NM_DedicatedServer)
	{
		PC = UTPlayerController(Instigator.Controller);
		if (PC != None && LocalPlayer(PC.Player) != none && FireModeNum < bZoomedFireMode.Length && bZoomedFireMode[FireModeNum] != 0 )
		{
			if(GetZoomedState() == ZST_NotZoomed && ZoomCount != 0)
			{
				if(bAbortZoom)
				{
					ClearTimer('Gotozoom');
					LeaveZoom();
				}
				else
				{
					bAbortZoom=true;
				}
			}
			if(ZoomLoop != none)
			{
				ZoomLoop.Stop();
				ZoomLoop = none;
			}
		}
	}
	super.EndFire(FireModeNum);
}

/** Called when zooming ends
 * @param PC - cast of Instigator.Controller for convenience
 */
simulated function EndZoom(UTPlayerController PC)
{
	PlaySound(ZoomOutSound, true);
	bAbortZoom = false;
	if (IsTimerActive('Gotozoom'))
	{
		ClearTimer('Gotozoom');
	}
	SetTimer(0.001,false,'LeaveZoom');

}
simulated function LeaveZoom()
{
	local UTPlayerController PC;

	bAbortZoom = false;
	PC = UTPlayerController(Instigator.Controller);
	if (PC != none)
	{
		PC.EndZoom();
	}
	ZoomCount = 0;
	if(Instigator.IsFirstPerson())
	{
		ChangeVisibility(true);
	}

	PlayWeaponAnimation('WeaponZoomOut',0.3);
	SetTimer(0.3,false,'RestartCrosshair');

}

simulated function RestartCrosshair()
{
	bDisplayCrosshair = true;
}

simulated function PutDownWeapon()
{
	ClearTimer('GotoZoom');
	ClearTimer('StopZoom');
	LeaveZoom();
	super.PutDownWeapon();
}

simulated function bool DenyClientWeaponSet()
{
	// don't autoswitch while zoomed
	return (GetZoomedState() != ZST_NotZoomed);
}

simulated function HolderEnteredVehicle()
{
	// clear timers
	ClearTimer('GotoZoom');
	ClearTimer('StopZoom');
}

simulated function Gotozoom()
{
	local UTPlayerController PC;

	PC = UTPlayerController(Instigator.Controller);
	if (GetZoomedState() == ZST_NotZoomed)
	{
		PC.FOVAngle = 40;
		Super.StartZoom(PC);
		ChangeVisibility(false);
		if (bAbortZoom) // stop the zoom after 1 tick
		{
			SetTimer(0.0001, false, 'StopZoom');
		}
		else
		{
			if(ZoomLoop == none)
			{
				ZoomLoop = CreateAudioComponent(ZoomLoopCue, false, true);
			}
			if(ZoomLoop != none)
			{
				ZoomLoop.Play();
			}
		}
	}
}

simulated function StopZoom()
{
	local UTPlayerController PC;

	if (WorldInfo.NetMode != NM_DedicatedServer)
	{
		PC = UTPlayerController(Instigator.Controller);
		if (PC != None && LocalPlayer(PC.Player) != none)
		{
			PC.StopZoom();
		}
	}
}

simulated event SetPosition(UTPawn Holder)
{
      FireOffset.X = 0;
      FireOffset.Y = 0;
      FireOffset.Z = 0;

	Super.SetPosition(Holder);
}

/*********************************************************************************************
 * AI Interface
 *********************************************************************************************/

function float SuggestAttackStyle()
{
	local float EnemyDist;

	if (Instigator.Controller.Enemy != None)
	{
		// recommend backing off if target is too close
		EnemyDist = VSize(Instigator.Controller.Enemy.Location - Owner.Location);
		if ( EnemyDist < 350 )
		{
			return (EnemyDist < 520) ? -1.5 : -0.7;
		}
		else if (EnemyDist > 800)
		{
			return 0.5;
		}
	}

	return -0.1;
}

// tell bot how valuable this weapon would be to use, based on the bot's combat situation
// also suggest whether to use regular or alternate fire mode
function float GetAIRating()
{
	local UTBot B;
	local float EnemyDist, Rating, ZDiff;
	local vector EnemyDir;

	B = UTBot(Instigator.Controller);
	if ( (B == None) || (B.Enemy == None) )
		return AIRating;

	// if standing on a lift, make sure not about to go around a corner and lose sight of target
	// (don't want to blow up a rocket in bot's face)
	if ( (Instigator.Base != None) && (Instigator.Base.Velocity != vect(0,0,0))
		&& !B.CheckFutureSight(0.1) )
		return 0.1;

	EnemyDir = B.Enemy.Location - Instigator.Location;
	EnemyDist = VSize(EnemyDir);
	Rating = AIRating;

	// don't pick rocket launcher if enemy is too close
	if ( EnemyDist < 1000 )
	{
		if ( Instigator.Weapon == self )
		{
			// don't switch away from rocket launcher unless really bad tactical situation
			if ( (EnemyDist > 350) || ((Instigator.Health < 80) && (Instigator.Health < B.Enemy.Health - 30)) )
				return Rating;
		}
		return 0.05 + EnemyDist * 0.001;
	}

	// rockets are good if higher than target, bad if lower than target
	ZDiff = Instigator.Location.Z - B.Enemy.Location.Z;
	if ( ZDiff > 120 )
		Rating += 0.25;
	else if ( ZDiff < -160 )
		Rating -= 0.35;
	else if ( ZDiff < -80 )
		Rating -= 0.05;
	if ( (B.Enemy.Weapon != None) && B.Enemy.Weapon.bMeleeWeapon && (EnemyDist < 8500) )
		Rating += 0.25;

	return Rating;
}

defaultproperties
{
	Begin Object class=AnimNodeSequence Name=MeshSequenceA
	End Object

	// Weapon SkeletalMesh
	Begin Object Name=FirstPersonMesh
		SkeletalMesh=SkeletalMesh'WP_AVRiL.Mesh.SK_WP_Avril_1P'
		PhysicsAsset=None
		AnimSets(0)=AnimSet'WP_AVRiL.Anims.K_WP_Avril_1P_Base'
		Animations=MeshSequenceA
		Materials(0)=Material'EM_XX_Content.Goliath_Final'
		Scale=1.0
		FoV=65
	End Object

	End Object

	// Pickup staticmesh
//	Components.Remove(PickupMesh)
	Begin Object Name=PickupMesh
		SkeletalMesh=SkeletalMesh'EM_XX_Content.Mesh.Goliath_3P'
		Materials(0)=Material'EM_XX_Content.Goliath_Final'
	End Object

	NoAmmoWeaponPutDownAnim=WeaponPutDownEmpty
   WeaponReloadAnim=WeaponReload
	WeaponFireAnim[1]=None
	FiringStatesArray(1)=Active
	ArmsAnimSet=AnimSet'WP_AVRiL.Anims.K_WP_Avril_1P_Arms'

   AttachmentClass=Class'EM_XX.Goliath_Cannon_Attach'

   WeaponPutDownSnd=SoundCue'A_Weapon_Avril.Weapons.A_Avril_LowerCue'
	PickupSound=SoundCue'A_Pickups.Weapons.Cue.A_Pickup_Weapons_AVRiL_Cue'
   WeaponEquipSnd=SoundCue'A_Weapon_Avril.Weapons.A_Avril_RaiseCue'
   WeaponFireSnd(0)=SoundCue'A_Vehicle_Goliath.SoundCues.A_Vehicle_Goliath_Fire'
	ReloadCue=SoundCue'A_Weapon_Avril.WAV.A_Weapon_AVRiL_Reload01Cue'
   ZoomOutSound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ZoomOut_Cue'
	ZoomInSound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ZoomIn_Cue'

   HudMaterial=Texture2D'EM_XX_Content.Scope512'
   SideMaterial=Texture2D'EM_XX_Content.steeldev'

   MuzzleFlashLightClass=class'UTGame.UTRocketMuzzleFlashLight'

   WeaponFireTypes(0)=EWFT_Projectile

   WeaponProjectiles(0)=Class'EM_XX.Goliath_Cannon_ProJ'

   ItemName="Goliath Cannon"
   PickupMessage="Goliath Cannon"

   FireInterval(0)=2
   ReloadTime=1.5
   FireTime=0.5
	RespawnTime=90.0

   GoliathRecoil=70000
   bSuperWeapon=True
	bDelayedSpawn=True
	bInstantHit=True
	bSniping=true
   bSplashJump=false
   bRecommendSplashDamage=false
   bWarnIfInLocker=true

   ShotCost(1)=0
	ShouldFireOnRelease(0)=1
	GroupWeight=0.6
   AmmoCount=3

	AimError=600
	FadeTime=0.3
   EquipTime=0.3
	PutDownTime=0.3
	MinReloadPct(0)=0.15
	MinReloadPct(1)=0.15
	bZoomedFireMode(0)=0
	bZoomedFireMode(1)=1
	ZoomedTargetFOV=26.5
	ZoomedRate=5000

	IconX=460
	IconY=343
	IconWidth=29
	IconHeight=47
	IconCoordinates=(U=728,V=427,UL=145,VL=52)

   MaxAmmoCount=8
   LockerAmmoCount=3
	LockerRotation=(pitch=0,yaw=0,roll=-16384)
   PlayerViewOffset=(X=0.0,Y=-10.0,Z=-0.0)
   FireOffset=(X=0,Y=0,Z=0)  //      FireOffset=(X=16,Y=8,Z=-5)
	CrossHairCoordinates=(U=384,V=64,UL=64,VL=64)

	WeaponColor=(B=155,G=155,R=155)
	MaxPitchLag=300
	MaxYawLag=400

	InventoryGroup=7
	QuickPickGroup=4
	QuickPickWeight=0.9
   bExportMenuData=True
	MaxDesireability=0.7
	AIRating=+1.58
	CurrentRating=+0.55
   Priority=1000.8
	TickGroup=TG_PostAsyncWork

   bDisplaycrosshair = true;
}