/*
 * Class:  Elite_Stinger_S_Shard
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Stinger_S_Shard extends UTProj_StingerShard
	dependson(MutEM_XX);

/** # of times they can bounce */
var int Bounces;

/** reference to impact effect we created; we wait for this before being destroyed */
var array<ParticleSystemComponent> ImpactEffects;
var ParticleSystem BounceTemplate;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	Speed=class'MutEM_XX'.default.Config_Stinger.iSpeed;
	MaxSpeed=class'MutEM_XX'.default.Config_Stinger.iSpeed;
	Damage=class'MutEM_XX'.default.Config_Stinger.iDamage;
	DamageRadius=class'MutEM_XX'.default.Config_Stinger.iDamageRadius;
	MomentumTransfer=class'MutEM_XX'.default.Config_Stinger.iMomentumTransfer;
	LifeSpan=class'MutEM_XX'.default.Config_Stinger.iLifeSpan;
	Bounces=class'MutEM_XX'.default.Config_Stinger.iSecBounces;
}

simulated function Landed(vector HitNormal, Actor FloorActor)
{
	HitWall(HitNormal, FloorActor, None);
}

simulated function MyOnParticleSystemFinished(ParticleSystemComponent PSC)
{
	local int i;

	if (ImpactEffects.length == 1)
	{
		Destroy();
	}
	else
	{
		i = ImpactEffects.Find(PSC);
		if (i != -1)
		{
			ImpactEffects.Remove(i, 1);
		}
		DetachComponent(PSC);
	}
}

simulated event HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
	local ParticleSystemComponent ImpactEffect;

	bBlockedByInstigator = true;
	Acceleration = vect(0,0,0);

	if (!Wall.bStatic && !Wall.bWorldGeometry)
	{
		Wall.TakeDamage(Damage, InstigatorController, Location, MomentumTransfer * Normal(Velocity), MyDamageType,, self);
		Shutdown();
	}
	else
	{
		// spawn impact effect
		if (EffectIsRelevant(Location, false, MaxEffectDistance))
		{
			ImpactEffect = new(Outer) class'UTParticleSystemComponent';
			ImpactEffect.SetAbsolute(true, true, true);
			ImpactEffect.SetTranslation(Location);
			ImpactEffect.SetRotation(rotator(HitNormal));
			ImpactEffect.SetTemplate(BounceTemplate);
			ImpactEffect.OnSystemFinished = MyOnParticleSystemFinished;
			AttachComponent(ImpactEffect);
			ImpactEffects[ImpactEffects.length] = ImpactEffect;
		}

		SetPhysics(PHYS_Falling);
		if (Bounces > 0)
		{
			// @todo play impact sound
			PlaySound(ExplosionSound);
			Velocity = 0.8 * (Velocity - 2.0 * HitNormal * (Velocity dot HitNormal));
			Bounces = Bounces - 1;
		}
		else
		{
			bBounce = false;
			SetPhysics(PHYS_None);
			Explode(Location, HitNormal);
		}
	}
}

defaultproperties
{
	DrawScale=1.0
	ImpactSound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactGlass_Cue'		

	ProjExplosionTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_AltFire_Surface_Impact'
	MaxEffectDistance=7000.0

//	SpikeVictimVelFactor=0.5
   ExplosionSound=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_AltFireImpactCue'  //SoundCue'A_Weapon_FlakCannon.Weapons.A_FlakCannon_FireAltImpactExplodeCue'

	Speed=4000
	MaxSpeed=4000
//	AccelRate=9000

	Damage=38
	DamageRadius=0
	MomentumTransfer=70000
	CheckRadius=30.0

	Bounces=0
	bBounce=true
   BounceTemplate=ParticleSystem'VH_NecrisManta.Effects.PS_Viper_Gun_Impact'

	MyDamageType=class'EM_XX.Elite_Stinger_DMG_Sec'
	LifeSpan=10.0

	bCollideWorld=true
	bProjTarget=false
	bNetTemporary=true

   Name="Elite_Stinger_S_Shard"
}
