/*
 * Class:  Elite_Stinger_DMG_Sec
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Stinger_DMG_Sec extends UTDmgType_StingerShard
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   NodeDamageScaling=class'MutEM_XX'.default.Config_Stinger.fNodeDamageScaling;
   DamageOverlayTime=class'MutEM_XX'.default.Config_Stinger.fDamageOverlayTime;
   DeathOverlayTime=class'MutEM_XX'.default.Config_Stinger.fDamageOverlayTime;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_Stinger.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_Stinger.fVehicleMomentumScaling;
}

static function PawnTornOff(UTPawn DeadPawn)
{
	if ( !class'GameInfo'.Static.UseLowGore(DeadPawn.WorldInfo) )
	{
	 	class'EM_XX.Elite_Stinger_S_Shard'.static.CreateSpike(DeadPawn, DeadPawn.TakeHitLocation, DeadPawn.Normal(DeadPawn.TearOffMomentum));
	}
}

defaultproperties
{
	KillStatsName=KILLS_Stinger
	DeathStatsName=DEATHS_Stinger
	SuicideStatsName=SUICIDES_Stinger

	DamageBodyMatColor=(R=0.5,B=0.5,G=0.5)

   DamageWeaponClass=Class'EM_XX.Elite_Stinger'
   Name="Elite_Stinger_DMG_Sec"
}
