/*
 * Class:  Elite_Stinger_Attach
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Stinger_Attach extends Elite_Sniper_Attach;

var array<DistanceBasedParticleTemplate> PrimaryImpactTemplates;

defaultproperties
{
	// Weapon SkeletalMesh
	Begin Object Name=SkeletalMeshComponent0
		SkeletalMesh=SkeletalMesh'WP_Stinger.Mesh.SK_WP_Stinger_3P_Mid'
		Materials(0)=Material'EM_XX_Content.Slinger_Final_Mat'
		Translation=(X=0,Y=0)
		AnimSets[0]=AnimSet'WP_Stinger.Anims.K_WP_Stinger_3P_Base'
	End Object

	Begin Object Class=ParticleSystemComponent Name=TracerComp
		Template=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_tracer_constant'
		bAutoActivate=false
		AbsoluteTranslation=true
		AbsoluteRotation=true
	End Object
	Components.Add(TracerComp)

   PrimaryImpactTemplates(0)=(Template=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Far',MinDistance=2250.000000)
   PrimaryImpactTemplates(1)=(Template=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Mid',MinDistance=600.000000)
   PrimaryImpactTemplates(2)=(Template=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')

   MuzzleFlashSocket="MF"
   MuzzleFlashPSCTemplate=ParticleSystem'WP_Stinger.Particles.P_Stinger_3P_MF_Primary'
   MuzzleFlashAltPSCTemplate=ParticleSystem'WP_Stinger.Particles.P_Stinger_3P_MF_Alt_Fire'
   bMakeSplash=True
   MuzzleFlashLightClass=Class'UTGame.UTStingerMuzzleFlashLight'
   DefaultImpactEffect=(Sound=SoundCue'A_Weapon_Stinger.Weapons.A_Weapon_Stinger_FireImpactCue')
   BulletWhip=SoundCue'A_Weapon.Enforcers.Cue.A_Weapon_Enforcers_BulletWhizz_Cue'
   WeaponClass=Class'EM_XX.Elite_Stinger'
   WeapAnimType=EWAT_Stinger
   FireAnim="WeaponFire"

   Name="Elite_Stinger_Attach"
}
