/*
 * Class:  Elite_Sniper_HeadShot
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Sniper_HeadShot extends UTDmgType_Rocket
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   DamageOverlayTime=class'MutEM_XX'.default.Config_Sniper_Rifle.fDamageOverlayTime;
   NodeDamageScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fNodeDamageScaling;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

static function int IncrementKills(UTPlayerReplicationInfo KillerPRI)
{
	if ( PlayerController(KillerPRI.Owner) != None )
	{
		PlayerController(KillerPRI.Owner).ReceiveLocalizedMessage( class'UTWeaponKillRewardMessage', 0 );
	}
	return super.IncrementKills(KillerPRI);
}

defaultproperties
{
   RewardCount=15
   RewardEvent="REWARD_HEADHUNTER"
   CustomTauntIndex=3
   RewardAnnouncementSwitch=2

   bAlwaysGibs=True
   bNeverGibs=False
   GibPerterbation=2

   DamageBodyMatColor=(R=20,G=5)
   DamageOverlayTime=1
   DeathOverlayTime=1

   KillStatsName="KILLS_ELITETIGERHEAD"
   DeathStatsName="DEATHS_ELITETIGERHEAD"
   SuicideStatsName="SUICIDES_ELITETIGERHEAD"

   DeathString="`o was Killed by `k."
   FemaleSuicide="`o Committed Suicide."
   MaleSuicide="`o Committed Suicide."

   VehicleDamageScaling=1
   NodeDamageScaling=1

   DamageWeaponClass=Class'EM_XX.Elite_Sniper_Rifle'
   Name="Elite_Sniper_HeadShot"
}
