/*
 * Class:  Elite_Sniper_BodyShot
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Sniper_BodyShot extends UTDmgType_Burning
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   DamageOverlayTime=class'MutEM_XX'.default.Config_Sniper_Rifle.fDamageOverlayTime;
   NodeDamageScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fNodeDamageScaling;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_Sniper_Rifle.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

static function SpawnHitEffect(Pawn P, float Damage, vector Momentum, name BoneName, vector HitLocation)
{
	local UTEmit_VehicleHit BF;

	if ( Vehicle(P) != None )
	{
		BF = P.spawn(class'UTEmit_VehicleHit',P,, HitLocation, rotator(Momentum));
		BF.AttachTo(P, BoneName);
	}
	else
	{
		Super.SpawnHitEffect(P, Damage, Momentum, BoneName, HitLocation);
	}
}

defaultproperties
{
   DamageOverlayTime=1
   DeathOverlayTime=1
   DamageBodyMatColor=(R=40,G=10)

   KillStatsName="KILLS_ELITETIGER"
   DeathStatsName="DEATHS_ELITETIGER"
   SuicideStatsName="SUICIDES_ELITETIGER"

   DeathString="`o was Killed by `k."
   FemaleSuicide="`o Committed Suicide."
   MaleSuicide="`o Committed Suicide."

   bAlwaysGibs=True
   bNeverGibs=False
   GibPerterbation=2

   VehicleDamageScaling=1
   NodeDamageScaling=1

   DamageWeaponClass=Class'EM_XX.Elite_Sniper_Rifle'
   Name="Elite_Sniper_BodyShot"
}
