/*
 * Class:  Elite_Sniper_Attach
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Sniper_Attach extends UTWeaponAttachment;

/** second mesh for dual-wielding, constructed by duplicating Mesh if no default */
var SkeletalMeshComponent DualMesh;
var SkeletalMeshComponent DualOverlayMesh;

var ParticleSystemComponent DualMuzzleFlashPSC;
var UTExplosionLight DualMuzzleFlashLight;

/** toggled on each fire effect in the dual wielding case to alternate which gun effects get played on */
var bool bFlashDual;

var ParticleSystem TracerTemplate;

function SetSkin(Material NewMaterial)
{
	local int i;

	Super.SetSkin(NewMaterial);

	if (DualMesh != None)
	{
		for (i = 0; i < Mesh.Materials.length; i++)
		{
			DualMesh.SetMaterial(i, Mesh.GetMaterial(i));
		}
	}
}

simulated function SetDualWielding(bool bNowDual)
{
	local UTPawn P;
	local vector LeftScale;

	P = UTPawn(Instigator);
	if (P != None)
	{
		if (bNowDual)
		{
			if (DualMesh == None && Mesh != None)
			{
				DualMesh = new(self) Mesh.Class(Mesh);

				// reverse the mesh, like we do in 1st person
				LeftScale = DualMesh.Scale3D;
				LeftScale.X *= -1;
				DualMesh.SetScale3D(LeftScale);
			}
			if (DualMesh != None)
			{
				P.Mesh.AttachComponentToSocket(DualMesh, P.WeaponSocket2);

				// Weapon Mesh Shadow
				DualMesh.SetShadowParent(P.Mesh);
				DualMesh.SetLightEnvironment(P.LightEnvironment);

				if (P.ReplicatedBodyMaterial != None)
				{
					SetSkin(P.ReplicatedBodyMaterial);
				}
				if ( MuzzleFlashSocket != 'None' &&
					(MuzzleFlashPSCTemplate != None || MuzzleFlashAltPSCTemplate != None) )
				{
					DualMuzzleFlashPSC = new(self) class'UTParticleSystemComponent';
					DualMuzzleFlashPSC.bAutoActivate = false;
					DualMuzzleFlashPSC.SetOwnerNoSee(true);
					DualMesh.AttachComponentToSocket(DualMuzzleFlashPSC, MuzzleFlashSocket);
				}
				P.SetWeapAnimType(EWAT_DualPistols);

				if (OverlayMesh != None && DualOverlayMesh == None)
				{
					DualOverlayMesh = new(self) OverlayMesh.Class(OverlayMesh);
					DualOverlayMesh.SetParentAnimComponent(DualMesh);
					DualOverlayMesh.SetScale3D(DualMesh.Scale3D);
				}
				if (DualOverlayMesh != None && OverlayMesh.bAttached)
				{
					P.Mesh.AttachComponentToSocket(DualOverlayMesh, P.WeaponSocket2);
				}
			}
		}
		else
		{
			if (DualMesh != None && DualMesh.bAttached)
			{
				P.Mesh.DetachComponent(DualMesh);
				P.SetWeapAnimType(WeapAnimType);
			}
			if (DualOverlayMesh != None && DualOverlayMesh.bAttached)
			{
				P.Mesh.DetachComponent(DualOverlayMesh);
			}
			bFlashDual = false;
		}
	}
}

simulated function CreateOverlayMesh()
{
	Super.CreateOverlayMesh();

	if (DualMesh != None)
	{
		DualOverlayMesh = new(self) OverlayMesh.Class(OverlayMesh);
		DualOverlayMesh.SetParentAnimComponent(DualMesh);
		DualOverlayMesh.SetScale3D(DualMesh.Scale3D);
	}
}

simulated function SetWeaponOverlayFlags(UTPawn OwnerPawn)
{
	local int i;

	Super.SetWeaponOverlayFlags(OwnerPawn);

	if (OverlayMesh != None && DualOverlayMesh != None)
	{
		if (OverlayMesh.bAttached)
		{
			if (!DualOverlayMesh.bAttached)
			{
				OwnerPawn.Mesh.AttachComponentToSocket(DualOverlayMesh, OwnerPawn.WeaponSocket2);
			}

			for (i = 0; i < DualOverlayMesh.GetNumElements(); i++)
			{
				DualOverlayMesh.SetMaterial(i, OverlayMesh.GetMaterial(i));
			}
		}
		else
		{
			OwnerPawn.Mesh.DetachComponent(DualOverlayMesh);
		}
	}
}

simulated function DetachFrom(SkeletalMeshComponent MeshCpnt)
{
	if (MeshCpnt != None)
	{
		if (DualMesh != None && DualMesh.bAttached)
		{
			MeshCpnt.DetachComponent(DualMesh);
		}
		if (DualOverlayMesh != None && DualOverlayMesh.bAttached)
		{
			MeshCpnt.DetachComponent(DualOverlayMesh);
		}
	}
	Super.DetachFrom(MeshCpnt);
}

simulated function ThirdPersonFireEffects(vector HitLocation)
{
	local UTPawn P;

	Super.ThirdPersonFireEffects(HitLocation);

	P = UTPawn(Instigator);
	if (P != None && P.bDualWielding)
	{
		// override recoil and play only on hand that's firing
		P.GunRecoilNode.bPlayRecoil = false;
		if (bFlashDual)
		{
			P.LeftRecoilNode.bPlayRecoil = true;
		}
		else
		{
			P.RightRecoilNode.bPlayRecoil = true;
		}

		bFlashDual = !bFlashDual;
	}
}

simulated function MuzzleFlashTimer()
{
	Super.MuzzleFlashTimer();

	if (DualMuzzleFlashLight != None)
	{
		DualMuzzleFlashLight.SetEnabled(false);
	}
	if (DualMuzzleFlashPSC != None && !bMuzzleFlashPSCLoops)
	{
		DualMuzzleFlashPSC.DeactivateSystem();
	}
}

simulated function CauseMuzzleFlash()
{
	if (!bFlashDual)
	{
		Super.CauseMuzzleFlash();
	}
	else
	{
		// only enable muzzleflash light if performance is high enough
		if (!WorldInfo.bDropDetail && !class'Engine'.static.IsSplitScreen() )
		{
			if (DualMuzzleFlashLight == None)
			{
				if (MuzzleFlashLightClass != None)
				{
					DualMuzzleFlashLight = new(self) MuzzleFlashLightClass;
					if (DualMesh != None && DualMesh.GetSocketByName(MuzzleFlashSocket) != None)
					{
						DualMesh.AttachComponentToSocket(DualMuzzleFlashLight, MuzzleFlashSocket);
					}
					else if (OwnerMesh != None)
					{
						OwnerMesh.AttachComponentToSocket(DualMuzzleFlashLight, UTPawn(OwnerMesh.Owner).WeaponSocket2);
					}
				}
			}
			else
			{
				DualMuzzleFlashLight.ResetLight();
			}
		}

		if (DualMuzzleFlashPSC != None)
		{
			if (!bMuzzleFlashPSCLoops || !DualMuzzleFlashPSC.bIsActive)
			{
				if (Instigator != None && Instigator.FiringMode == 1 && MuzzleFlashAltPSCTemplate != None)
				{
					DualMuzzleFlashPSC.SetTemplate(MuzzleFlashAltPSCTemplate);
				}
				else
				{
					DualMuzzleFlashPSC.SetTemplate(MuzzleFlashPSCTemplate);
				}

				SetMuzzleFlashParams(DualMuzzleFlashPSC);
				DualMuzzleFlashPSC.ActivateSystem();
			}
		}

		// Set when to turn it off.
		SetTimer(MuzzleFlashDuration,false,'MuzzleFlashTimer');
	}
}

simulated function StopMuzzleFlash()
{
	Super.StopMuzzleFlash();

	if (DualMuzzleFlashPSC != None)
	{
		DualMuzzleFlashPSC.DeactivateSystem();
	}
}

simulated function FirstPersonFireEffects(Weapon PawnWeapon, vector HitLocation)
{
	Super.FirstPersonFireEffects(PawnWeapon, HitLocation);
}

simulated function vector GetEffectLocation()
{
	local SkeletalMeshComponent RealMesh;
	local vector Result;

	// swap to the dual mesh if necessary
	RealMesh = Mesh;
	Mesh = (bFlashDual && DualMesh != None) ? DualMesh : Mesh;
	Result = Super.GetEffectLocation();
	Mesh = RealMesh;

	return Result;
}

simulated function ChangeVisibility(bool bIsVisible)
{
	Super.ChangeVisibility(bIsVisible);

	if (DualMesh != None)
	{
		DualMesh.SetHidden(!bIsVisible);
	}
}

defaultproperties
{
	// Weapon SkeletalMesh
	Begin Object Name=SkeletalMeshComponent0
	    SkeletalMesh=SkeletalMesh'EM_XX_Content.Mesh.Tiger_3P'
	    Materials(0)=Material'EM_XX_Content.Deemer_Final'  //Material'EM_XX_Content.Tiger_Final'
	End Object
	
   MuzzleFlashSocket="MuzzleFlashSocket"
   MuzzleFlashPSCTemplate=EM_XX_Content.Tiger_Muz
   MuzzleFlashLightClass=Class'UTGame.UTRocketMuzzleFlashLight'
   MuzzleFlashDuration=0.330000
   ImpactEffects(0)=(MaterialType="Dirt",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactDirt_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(1)=(MaterialType="Gravel",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactDirt_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(2)=(MaterialType="Sand",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactDirt_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(3)=(MaterialType="Dirt_Wet",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactMud_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(4)=(MaterialType="Energy",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactEnergy_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(5)=(MaterialType="WorldBoundary",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactEnergy_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(6)=(MaterialType="Flesh",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactFlesh_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(7)=(MaterialType="Flesh_Human",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactFlesh_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(8)=(MaterialType="Kraal",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactFlesh_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(9)=(MaterialType="Necris",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactFlesh_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(10)=(MaterialType="Robot",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactMetal_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(11)=(MaterialType="Foliage",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactFoliage_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(12)=(MaterialType="Glass",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactGlass_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(13)=(MaterialType="Liquid",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWater_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(14)=(MaterialType="Water",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWater_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(15)=(MaterialType="ShallowWater",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWater_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(16)=(MaterialType="Lava",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWater_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(17)=(MaterialType="Slime",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWater_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(18)=(MaterialType="Metal",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactMetal_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(19)=(MaterialType="Snow",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactSnow_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(20)=(MaterialType="Wood",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactWood_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   ImpactEffects(21)=(MaterialType="NecrisVehicle",Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactMetal_Cue',DurationOfDecal=4.000000,DecalDissolveParamName="DissolveAmount",DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   DefaultImpactEffect=(Sound=SoundCue'A_Weapon_Sniper.Sniper.A_Weapon_Sniper_ImpactDirt_Cue',DecalWidth=16.000000,DecalHeight=16.000000,ParticleTemplate=ParticleSystem'WP_Stinger.Particles.P_WP_Stinger_Surface_Impact_Near')
   WeaponClass=Class'EM_XX.Elite_Sniper_Rifle'
   Name="Elite_Sniper_Attach"
}
