/*
 * Class:  Elite_Shock_ProJ
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Shock_ProJ extends UTProj_ShockBall
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	Speed=class'MutEM_XX'.default.Config_Shock_Rifle.iSpeed;
	MaxSpeed=class'MutEM_XX'.default.Config_Shock_Rifle.iSpeed;

	Damage=class'MutEM_XX'.default.Config_Shock_Rifle.iDamage;
	DamageRadius=class'MutEM_XX'.default.Config_Shock_Rifle.iDamageRadius;

	MomentumTransfer=class'MutEM_XX'.default.Config_Shock_Rifle.iMomentum;
	ComboAmmoCost=class'MutEM_XX'.default.Config_Shock_Rifle.iShotCost;

	ComboDamage=class'MutEM_XX'.default.Config_Shock_Rifle.iDamage;
	ComboRadius=class'MutEM_XX'.default.Config_Shock_Rifle.iDamageRadius;

//	bComboed=class'MutEM_XX'.default.Config_Shock_Rifle.bUseCombo;
/*
  if ( class'MutEM_XX'.default.Config_Shock_Rifle.bUseCombo )
    {
     bComboed=True;
    }
  else
    {
     bComboed=True;
    } */
}

simulated function ProcessTouch(Actor Other, vector HitLocation, vector HitNormal)
{
	local Elite_Shock_ProJ ShockProj;

	Super.ProcessTouch(Other, HitLocation, HitNormal);

	// when shock projectiles collide, make sure they both blow up
	ShockProj = Elite_Shock_ProJ(Other);
	if (ShockProj != None)
	{
		ShockProj.Explode(HitLocation, -HitNormal);
	}
}

state WaitForCombo
{
	function Tick(float DeltaTime)
	{
		local float Dist;
		local UTBot B;

		if ( (ComboTarget == None) || ComboTarget.bDeleteMe
			|| (Instigator == None) || (Elite_Shock(Instigator.Weapon) == None) )
		{
			if (Instigator != None && Elite_Shock(Instigator.Weapon) != None)
			{
				Elite_Shock(Instigator.Weapon).ClearCombo();
			}
			GotoState('');
			return;
		}

		// if I'm close enough or have passed target, do combo
		Dist = VSize(ComboTarget.Location - Location);
		if ( Dist <= 0.5 * ComboRadius + ComboTarget.GetCollisionRadius()
			|| (Velocity Dot (ComboTarget.Location - Location)) <= 0.0 )
		{
			Elite_Shock(Instigator.Weapon).DoCombo();
			GotoState('');
			return;
		}
		else if (Dist <= ComboRadius + ComboTarget.GetCollisionRadius())
		{
			// if close to combo time, make bot look at me
			B = UTBot(Instigator.Controller);
			if (B != None)
			{
				B.TemporaryFocus = self;
			}
		}

		if ( PointDistToLine(ComboTarget.Location, Normal(Velocity), Location) > ComboRadius + FMax(ComboTarget.GroundSpeed,VSize(ComboTarget.Velocity)) )
		{
			Elite_Shock(Instigator.Weapon).ClearCombo();
			GotoState('');
			return;
		}
	}

	event EndState(name NextStateName)
	{
		local UTBot B;

		if (Instigator != None)
		{
			B = UTBot(Instigator.Controller);
			if (B != None && B.TemporaryFocus == self)
			{
				B.TemporaryFocus = None;
			}
		}
	}
}

defaultproperties
{
   ComboDamageType=Class'EM_XX.Elite_Shock_Combo_DMG'
   ComboTriggerType=Class'EM_XX.Elite_Shock_DMG'

//   ComboTemplate==ParticleSystem'EM_XX_Content.Particles.Shock_Explo'   

   MyDamageType=Class'EM_XX.Elite_Shock_Combo_DMG'
   ProjExplosionTemplate=ParticleSystem'EM_XX_Content.Shock_Explo'
   ComboExplosionEffect=class'EM_XX.Elite_Shock_Emit'  //Class'UTGame.UTEmit_ShockCombo'   //  //
   ProjFlightTemplate=ParticleSystem'EM_XX_Content.Shock_Ball'
   ExplosionSound=SoundCue'A_Weapon_ShockRifle.Cue.A_Weapon_SR_ComboExplosionCue'
   ProjectileLightClass=class'UTGame.UTRocketLight'
   ComboAmmoCost=3
//   bComboed=True
	ComboDamage=215
	ComboRadius=275

   Name="Elite_Shock_ProJ"
}
