/*
 * Weapon:
 * By: *PingFre@K*
 * Copyright 1998-2007 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Shock_Emit extends UTEmit_ShockCombo;  //UTReplicatedEmitter;

//var class<UTExplosionLight> ExplosionLightClass;

/** increase in vortex force per second */
//var float VortexForcePerSecond;
/** radius in which ragdolls have the force applied */
//var float VortexRadius;
/** duration in seconds of the physics effect, or zero for it to be the same as the emitter */
//var float VortexDuration;
/** damage type passed to SpawnGibs() when blowing up a ragdoll */
//var class<UTDamageType> VortexDamageType;

simulated function PostBeginPlay()
{
   VortexRadius=class'MutEM_XX'.default.Config_Shock_Rifle.iVortexRadius;
   VortexForcePerSecond=class'MutEM_XX'.default.Config_Shock_Rifle.iVortexForcePerSecond;
   VortexDuration=class'MutEM_XX'.default.Config_Shock_Rifle.fVortexDuration;
}

simulated event SetInitialState()
{
	local PlayerController P;
	local float Dist;
	local bool bSpawnLight, bDoPhysicsVortex;

	Super.SetInitialState();

	if ( WorldInfo.NetMode != NM_DedicatedServer )
	{
		// decide whether to enable explosion light and/or vortex effect
		ForEach LocalPlayerControllers(class'PlayerController', P)
		{
			if (!WorldInfo.bDropDetail && !bSpawnLight)
			{
				Dist = VSize(P.ViewTarget.Location - Location);
				if ( (P.Pawn == Instigator) || (Dist < ExplosionLightClass.Default.Radius) || ((Dist < 6000) && ((vector(P.Rotation) dot (Location - P.ViewTarget.Location)) > 0)) )
				{
					bSpawnLight = true;
				}
			}
			if (!bDoPhysicsVortex && (Instigator == P.ViewTarget || FastTrace(Location, P.ViewTarget.Location)))
			{
				bDoPhysicsVortex = true;
			}
		}
		if (bSpawnLight)
		{
			AttachComponent(new(self) ExplosionLightClass);
		}
		if ( bDoPhysicsVortex && !class'GameInfo'.Static.UseLowGore(WorldInfo) )  //if (bDoPhysicsVortex)
		{
			GotoState('PhysicsVortex');
		}
	}
}

/** this state does the cool physics vortex effect */
state PhysicsVortex
{
	simulated event BeginState(name PreviousStateName)
	{
		if (VortexDuration > 0.0)
		{
//			SetTimer(VortexDuration, false, 'EndVortex');
			SetTimer(class'MutEM_XX'.default.Config_Shock_Rifle.fVortexDuration, false, 'EndVortex');
		}
	}

	simulated function EndVortex()
	{
		GotoState('');
	}

	simulated event Tick(float DeltaTime)
	{
		local float CurrentForce;
		local UTPawn P;
		local vector OtherLocation, Dir;

//		CurrentForce = VortexForcePerSecond * (WorldInfo.TimeSeconds - CreationTime);
		CurrentForce = class'MutEM_XX'.default.Config_Shock_Rifle.iVortexForcePerSecond * (WorldInfo.TimeSeconds - CreationTime);

		foreach CollidingActors(class'UTPawn', P, VortexRadius,, true)
		{
			if (P.Physics == PHYS_RigidBody && P.Health < 0 && P.IsInState('Dying'))
			{
				OtherLocation = P.Mesh.GetPosition();
				if (FastTrace(Location, OtherLocation))
				{
					// if it has reached the center, gib it
					Dir = Location - OtherLocation;
					if (VSize(Dir) < P.Mesh.Bounds.SphereRadius && Normal(P.Velocity) dot Dir > 0.0 && !class'GameInfo'.static.UseLowGore(WorldInfo) )
					{
						P.SpawnGibs(VortexDamageType, Location);
					}
					else
					{
						P.Mesh.AddForce(Normal(Dir) * CurrentForce);
					}
				}
			}
		}
	}
}

defaultproperties
{
	EmitterTemplate=ParticleSystem'EM_XX_Content.Particles.Shock_Explo'
	ExplosionLightClass=class'UTGame.UTRocketLight'  //class'EM_XX.Elite_ShockBallLight'  //class'UTShockComboExplosionLight'

	TickGroup=TG_PreAsyncWork

	VortexRadius=400.0
	VortexForcePerSecond=150.0
	VortexDuration=2.75
	VortexDamageType=Class'EM_XX.Elite_Shock_DMG'
}