/*
 * Class:  Elite_Shock_DMG
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Shock_DMG extends UTDmgType_ShockPrimary
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   DamageOverlayTime=class'MutEM_XX'.default.Config_Shock_Rifle.fDamageOverlayTime;
   NodeDamageScaling=class'MutEM_XX'.default.Config_Shock_Rifle.fNodeDamageScaling;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_Shock_Rifle.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_Shock_Rifle.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

defaultproperties
{
   DeathString="`k Vaporized `o"
   FemaleSuicide="`o Was Vaporized"
   MaleSuicide="`o Was Vaporized"

   DamageBodyMatColor=(R=50,G=50,B=50)
   
   bAlwaysGibs=False
   bNeverGibs=True

   DamageWeaponClass=Class'EM_XX.Elite_Shock'
   Name="Elite_Shock_DMG"
}
