/*
 * Class:  Elite_Rocket_ProJ
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Rocket_ProJ extends UTProj_Rocket
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();
	
	Speed=class'MutEM_XX'.default.Config_RL_BFG.iSpeed;
	MaxSpeed=class'MutEM_XX'.default.Config_RL_BFG.iSpeed;
	Damage=class'MutEM_XX'.default.Config_RL_BFG.iDamage;
	DamageRadius=class'MutEM_XX'.default.Config_RL_BFG.iDamageRadius;
	MomentumTransfer=class'MutEM_XX'.default.Config_RL_BFG.iMomentum;
//	LifeSpan=class'MutEM_XX'.default.Config_RL_BFG.iLifeSpan;
	
	// force ambient sound if not vehicle game mode
	bImportantAmbientSound = !WorldInfo.bDropDetail && (UTOnslaughtGRI(WorldInfo.GRI) == None);
}

defaultproperties
{
//   AccelRate=12000
//   speed=200000.0
//   MaxSpeed=200000.0
//   Damage=120.0
//   DamageRadius=275.0
//   MomentumTransfer=3000
   MyDamageType=Class'EM_XX.Elite_Rocket_BodyShot'
	ProjFlightTemplate=ParticleSystem'VH_Leviathan.Effects.P_VH_Leviathan_MissileTrailIgnited' //ParticleSystem'WP_RocketLauncher.Effects.P_WP_RocketLauncher_RocketTrail'
	ProjExplosionTemplate=ParticleSystem'WP_RocketLauncher.Effects.P_WP_RocketLauncher_RocketExplosion' //ParticleSystem'VH_Raptor.Effects.PS_Raptor_Gun_Impact'
	ExplosionDecal=MaterialInstanceTimeVarying'WP_RocketLauncher.Decals.MITV_WP_RocketLauncher_Impact_Decal01'
	DecalWidth=128.0
	DecalHeight=128.0
//	LifeSpan=0
	AmbientSound=SoundCue'A_Weapon_RocketLauncher.Cue.A_Weapon_RL_Travel_Cue'
	ExplosionSound=SoundCue'A_Weapon_RocketLauncher.Cue.A_Weapon_RL_Impact_Cue'
	RotationRate=(Roll=50000)
	DesiredRotation=(Roll=30000)
	bCollideWorld=true
	CheckRadius=40.0
	bCheckProjectileLight=true
	ProjectileLightClass=class'UTGame.UTRocketLight'
	ExplosionLightClass=class'UTGame.UTRocketExplosionLight'
	
	bWaitForEffects=true
	bAttachExplosionToVehicles=false
   Name="Elite_Rocket_ProJ"
}
