/*
 * Class:  Elite_Rocket_BodyShot
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Rocket_BodyShot extends UTDmgType_Rocket
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   DamageOverlayTime=class'MutEM_XX'.default.Config_RL_BFG.fDamageOverlayTime;
   NodeDamageScaling=class'MutEM_XX'.default.Config_RL_BFG.fNodeDamageScaling;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_RL_BFG.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_RL_BFG.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

defaultproperties
{
   DamageOverlayTime=0.500000
   DeathOverlayTime=1.000000
   DamageWeaponClass=Class'EM_XX.Elite_Rocket_Launcher'
   KillStatsName="KILLS_Elite_ROCKET"
   DeathStatsName="DEATHS_Elite_ROCKET"
   SuicideStatsName="SUICIDES_Elite_ROCKET"
   DeathString="`k Dismemberd `o .. Death by Explosion."
   Name="Elite_Rocket_BodyShot"
}
