/*
 * Class:  Elite_Link_ProJ
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Link_ProJ extends UTProjectile
	dependson(MutEM_XX);

var vector ColorLevel;
var vector ExplosionColor;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	Damage=class'MutEM_XX'.default.Config_LinkGun.iPriDamage;
	Speed=class'MutEM_XX'.default.Config_LinkGun.iProJSpeed;
	MaxSpeed=class'MutEM_XX'.default.Config_LinkGun.iProJSpeed;
	DamageRadius=class'MutEM_XX'.default.Config_LinkGun.iDamageRadius;
	MomentumTransfer=class'MutEM_XX'.default.Config_LinkGun.iMomentum;
//   LifeSpan=class'MutEM_XX'.default.Config_LinkGun.iLifeSpan;
}

simulated function ProcessTouch (Actor Other, vector HitLocation, vector HitNormal)
{
	if ( Other != Instigator )
	{
		if ( !Other.IsA('Projectile') || Other.bProjTarget )
		{
			MomentumTransfer = (UTPawn(Other) != None) ? 0.0 : 1.0;
			Other.TakeDamage(Damage, InstigatorController, HitLocation, MomentumTransfer * Normal(Velocity), MyDamageType,, self);
			Explode(HitLocation, HitNormal);
		}
	}
}

simulated event HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
	MomentumTransfer = 1.0;

	Super.HitWall(HitNormal, Wall, WallComp);
}

simulated function SpawnFlightEffects()
{
	Super.SpawnFlightEffects();
	if (ProjEffects != None)
	{
		ProjEffects.SetVectorParameter('LinkProjectileColor', ColorLevel);
	}
}


simulated function SetExplosionEffectParameters(ParticleSystemComponent ProjExplosion)
{
	Super.SetExplosionEffectParameters(ProjExplosion);
	ProjExplosion.SetVectorParameter('LinkImpactColor', ExplosionColor);
}

defaultproperties
{
	ProjFlightTemplate=ParticleSystem'EM_XX_Content.Lucifer_Projectile'  //ParticleSystem'VH_SPMA.Effects.P_VH_SPMA_MiniProjectile'   //ParticleSystem'VH_SPMA.Effects.P_VH_SPMA_Camera_Little_Jets'
	ProjExplosionTemplate=ParticleSystem'VH_Nemesis.Effects.PS_Nemesis_Gun_Impact'   //ParticleSystem'EM_XX_Content.Link_Impact_Red'
	MaxEffectDistance=7000.0

   speed=24000
	MaxSpeed=24000
//	AccelRate=12000

	Damage=32
	DamageRadius=200
	MomentumTransfer=5000
	CheckRadius=30.0

	MyDamageType=Class'EM_XX.Elite_Link_DMG'
//	LifeSpan=3.0
	NetCullDistanceSquared=+144000000.0

	bCollideWorld=true
	DrawScale=0.7

	ExplosionSound=SoundCue'A_Vehicle_Nightshade.Nightshade.A_Vehicle_Nightshade_Impact_Cue'
	ColorLevel=(X=1,Y=0,Z=0)
	ExplosionColor=(X=1,Y=0,Z=0);
}