/*
 * Class:  Elite_Link_DMG
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Link_DMG extends UTDmgType_LinkPlasma
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	DamageOverlayTime=class'MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime;
	DeathOverlayTime=class'MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_LinkGun.fVehicleDamageScaling;
   NodeDamageScaling=class'MutEM_XX'.default.Config_LinkGun.fNodeDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_LinkGun.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

defaultproperties
{
	RewardCount=15
	RewardEvent=REWARD_SHAFTMASTER
	RewardAnnouncementSwitch=6

   DamageBodyMatColor=(R=10)
   DamageOverlayTime=1
   DeathOverlayTime=1

   KillStatsName="KILLS_ELITE_Link"
   DeathStatsName="DEATHS_ELITE_Link"
   SuicideStatsName="SUICIDES_ELITE_Link"

   DeathString="`k Killed `o with an Exploding Bullet."
   FemaleSuicide="`o fired her Exploding Bullet prematurely."
   MaleSuicide="`o fired his Exploding Bullet prematurely."

   bAlwaysGibs=True
   bNeverGibs=False
   GibPerterbation=2

   VehicleDamageScaling=1.00
   NodeDamageScaling=1.00

   DamageWeaponClass=Class'EM_XX.Elite_Link'
   Name="Elite_Link_DMG"
}
