/*
 * Class:  Elite_Link_Beam_DMG
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

Class Elite_Link_Beam_DMG extends UTDmgType_LinkBeam
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	DamageOverlayTime=class'MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime;
	VehicleDamageScaling=class'MutEM_XX'.default.Config_LinkGun.fVehicleDamageScaling;
	NodeDamageScaling=class'MutEM_XX'.default.Config_LinkGun.fNodeDamageScaling;
	DeathOverlayTime=class'MutEM_XX'.default.Config_LinkGun.fDamageOverlayTime;
	VehicleMomentumScaling=class'MutEM_XX'.default.Config_LinkGun.fVehicleMomentumScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

defaultproperties
{
	KillStatsName=KILLS_LinkGUN
	DeathStatsName=DEATHS_LinkGUN
	SuicideStatsName=SUICIDES_LinkGUN
	RewardCount=15
	RewardEvent=REWARD_SHAFTMASTER
	RewardAnnouncementSwitch=6
	DamageWeaponFireMode=1

	DamageBodyMatColor=(R=1)
	DamageOverlayTime=0.5
	DeathOverlayTime=1.0

	bCausesBlood=false
	bLeaveBodyEffect=true
	bUseDamageBasedDeathEffects=true
	VehicleDamageScaling=0.8
	VehicleMomentumScaling=0.1

	KDamageImpulse=100
	
   DeathString="`k Killed `o  with an Mysterious Beam"
   bAlwaysGibs=False
   bNeverGibs=True
	DamageCameraAnim=CameraAnim'Camera_FX.LinkGun.C_WP_Link_Beam_Hit'

   DamageWeaponClass=Class'EM_XX.Elite_Link'
   Name="Elite_Link_Beam_DMG"
}
