/*
 * Class:  Elite_Impact_Hammer
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Impact_Hammer extends UTWeap_ImpactHammer
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	MinDamage=class'MutEM_XX'.default.Config_ImpactHammer.fMinDmg;
	MaxDamage=class'MutEM_XX'.default.Config_ImpactHammer.fMaxDmg;
	EMPDamage=class'MutEM_XX'.default.Config_ImpactHammer.fEMPDmg;

	MinForce=class'MutEM_XX'.default.Config_ImpactHammer.fMinForce;
	MaxForce=class'MutEM_XX'.default.Config_ImpactHammer.fMaxForce;

	MaxChargeTime=class'MutEM_XX'.default.Config_ImpactHammer.fMaxChargeTime;
	MinChargeTime=class'MutEM_XX'.default.Config_ImpactHammer.fMinChargeTime;

	MinSelfDamage=class'MutEM_XX'.default.Config_ImpactHammer.fMinSelfDmg;
	SelfDamageScale=class'MutEM_XX'.default.Config_ImpactHammer.fSelfDmgScale;
	SelfForceScale=class'MutEM_XX'.default.Config_ImpactHammer.fSelfForceScale;

	AIRating=class'MutEM_XX'.default.Config_ImpactHammer.fAIRating;
	MaxDesireability=class'MutEM_XX'.default.Config_ImpactHammer.fAIRating;
	CurrentRating=class'MutEM_XX'.default.Config_ImpactHammer.fAIRating;
}

simulated function ModifyPlayer(Pawn Other)
{
  local UTPawn P;
  
  if (Other != None) 
  {
    P = UTPawn (Other);
    if (P != None) 
    {
      P.MaxFallSpeed = 2500.0;
    }
  }
}

function GivenTo(Pawn ThisPawn, optional bool bDoNotActivate)
{
}

defaultproperties
{
	Begin Object Name=FirstPersonMesh
		SkeletalMesh=SkeletalMesh'WP_ImpactHammer.Mesh.SK_WP_Impact_1P'
		Materials(0)=Material'EM_XX_Content.Impact_Final'
		PhysicsAsset=None
		AnimSets(0)=AnimSet'WP_ImpactHammer.Anims.K_WP_Impact_1P_Base'
		Animations=MeshSequenceA
		FOV=75
	End Object
	AttachmentClass=class'EM_XX.Elite_Impact_Attach'

	Components.Remove(PickupMesh)

	WeaponChargeSnd=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_FireLoop_Cue'
	WeaponEMPChargeSnd=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_AltFireLoop_Cue'
	WeaponFireSnd[0]=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_AltFire_Cue'
	WeaponFireSnd[1]=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_AltImpact_Cue'
	WeaponPutDownSnd=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_Lower_Cue'
	WeaponEquipSnd=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_Raise_Cue'

	Spread(2)=0.0

	WeaponRange=110.0
	AutoFireRange=110.0

	FireInterval[0]=1.0//+0.1
	FireInterval[1]=1.0//+0.1
	FireInterval[2]=1.0
	FireInterval[3]=1.0

	InstantHitDamageTypes(0)=class'UTDmgType_ImpactHammer'
	InstantHitDamage(0)=20
	InstantHitDamageTypes(1)=class'UTDmgType_EMP'
	InstantHitDamage(1)=20
	InstantHitDamageTypes(2)=none
	InstantHitDamageTypes(3)=class'UTDmgType_ImpactHammer' // 3 is when bloody from firetype 0

	MuzzleFlashPSCTemplate=ParticleSystem'WP_ImpactHammer.Particles.P_WP_ImpactHammer_Primary_Hit'
	MuzzleFlashAltPSCTemplate=ParticleSystem'WP_ImpactHammer.Particles.P_WP_ImpactHammer_Secondary_Hit'

	ChargeEffect[0]=ParticleSystem'WP_ImpactHammer.Particles.P_WP_ImpactHammer_Charge_Primary'
	ChargeEffect[1]=ParticleSystem'WP_ImpactHammer.Particles.P_WP_Impact_Charge_Secondary'


	AIRating=+1.51

	InventoryGroup=1
	GroupWeight=0.7
   bExportMenuData=True
	MaxDamage=140.0
	MinDamage=20.0
	MinForce=40000.0
	MaxForce=100000.0
	MinSelfDamage=1
	SelfForceScale=-1.75
	SelfDamageScale=0.2

	MaxChargeTime=2
	MinChargeTime=0.5

	EquipTime=+0.2
	PutDownTime=+0.2

	EMPDamage=150.0

	ImpactJumpSound=SoundCue'A_Weapon_ImpactHammer.ImpactHammer.A_Weapon_ImpactHammer_FireBodyThrow_Cue'

	AltHitEffect=ParticleSystem'WP_ImpactHammer.Particles.P_WP_ImpactHammer_Secondary_Hit_Impact'

	ImpactKillCameraAnim=CameraAnim'Camera_FX.Gameplay.C_Impact_CharacterGib_Near'
   Priority=0
   ItemName="Elite Impact Hammer"
   Name="Elite Impact Hammer"
}
