/*
 * Class:  Elite_Flak_Shell
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Flak_Shell extends UTProj_FlakShell
	dependson(MutEM_XX);
	
simulated function PostBeginPlay()
{
	super.PostBeginPlay();
   
	DamageRadius=class'MutEM_XX'.default.Config_FlakCannon.iSecDamageRadius;
	speed=class'MutEM_XX'.default.Config_FlakCannon.iSecspeed;
	Damage=class'MutEM_XX'.default.Config_FlakCannon.iSecDamage;
   TossZ=class'MutEM_XX'.default.Config_FlakCannon.iTossZ;
	MomentumTransfer=class'MutEM_XX'.default.Config_FlakCannon.iMomentum;
	CustomGravityScaling=class'MutEM_XX'.default.Config_FlakCannon.fCustomGravityScaling;
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
	local vector SpawnPos, BaseChunkDir;
	local actor HitActor;
	local rotator rot;
	local int i;
	local Elite_Flak_Shard NewChunk;

	Super.Explode(HitLocation, HitNormal);

	SpawnPos = Location + 10 * HitNormal;

	HitActor = Trace(HitLocation, HitNormal, SpawnPos, Location, false);
	if (HitActor != None)
	{
		SpawnPos = HitLocation;
	}

	if ( (Role == ROLE_Authority) && (UTVehicle(ImpactedActor) == None) )
	{
		BaseChunkDir = Normal(HitNormal + 0.8 * Normal(Velocity));
		for (i = 0; i < 5; i++)
		{
			rot = rotator(4*BaseChunkDir + VRand());
			NewChunk = Spawn(class 'EM_XX.Elite_Flak_Shard',, '', SpawnPos, rot);
			if (NewChunk != None)
			{
				NewChunk.bCheckShortRangeKill = false;
				NewChunk.Init(vector(rot));
			}
		}
	}
}

defaultproperties
{
	DamageRadius=+200.0
	speed=1200.000000
	Damage=100.000000
	MomentumTransfer=75000
	MyDamageType=class'EM_XX.Elite_Flak_DMG'

	TossZ=+305.0

	ProjFlightTemplate=ParticleSystem'WP_FlakCannon.Effects.P_WP_Flak_Alt_Smoke_Trail'
	ProjExplosionTemplate=ParticleSystem'WP_FlakCannon.Effects.P_WP_Flak_Alt_Explosion'
	ExplosionLightClass=class'UTGame.UTRocketExplosionLight'
	ExplosionDecal=MaterialInstanceTimeVarying'WP_FlakCannon.Decals.MITV_WP_FlakCannon_Impact_Decal01' 

	CustomGravityScaling=1.0
}