/*
 * Class:  Elite_Flak_ShardMain
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Flak_ShardMain extends Elite_Flak_Shard
	dependson(MutEM_XX);

/** max bonus damage when (this) center flak shard hits enemy pawn */
var float CenteredDamageBonus;

/** max bonus momentum when (this) center flak shard hits enemy pawn */
var float CenteredMomentumBonus;

/** max time when any bonus still applies */
var float MaxBonusTime;

simulated function PostBeginPlay()
{
	super.PostBeginPlay();
   
	CenteredMomentumBonus=class'MutEM_XX'.default.Config_FlakCannon.iMomentum;
	CenteredDamageBonus=class'MutEM_XX'.default.Config_FlakCannon.iCenteredDamageBonus;
	MaxBonusTime=class'MutEM_XX'.default.Config_FlakCannon.fMaxBonusTime;

	Bounces=class'MutEM_XX'.default.Config_FlakCannon.iMainBounces;
}

/** 
  * Increase damage to UTPawns based on how centered this shard is on target.  If it is within the time MaxBonusTime time period.
  * e.g. point blank shot with the flak cannon you will do mega damage.  Once MaxBonusTime passes then this shard becomes a normal shard.
  */
simulated function float GetDamage(Actor Other, vector HitLocation)
{
	local float MaxRadius;

	if ( (LifeSpan < default.LifeSpan - MaxBonusTime) || (UTPawn(Other) == None) )
	{
		return Damage;
	}

	MaxRadius = Pawn(Other).CylinderComponent.CollisionRadius;
	return Damage + CenteredDamageBonus * (LifeSpan - Default.LifeSpan + MaxBonusTime) 
			* FMax(0, 2*MaxRadius - PointDistToLine(Other.Location, normal(Velocity), HitLocation))/MaxRadius;
}

/** 
  * Increase momentum imparted based on how recently this shard was fired
  */
simulated function float GetMomentumTransfer()
{
	if ( LifeSpan < default.LifeSpan - MaxBonusTime )
	{
		return MomentumTransfer;
	}
	return MomentumTransfer + CenteredMomentumBonus * (LifeSpan - Default.LifeSpan + MaxBonusTime);
}

defaultproperties
{
	CenteredMomentumBonus=90000
	CenteredDamageBonus=100.0
	MaxBonusTime=0.2
	Bounces=3
}