/*
 * Class:  Elite_Flak_Shard
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Flak_Shard extends UTProj_FlakShard
	dependson(MutEM_XX);
	
simulated function PostBeginPlay()
{
	super.PostBeginPlay();

	speed=class'MutEM_XX'.default.Config_FlakCannon.ispeed;
	MaxSpeed=class'MutEM_XX'.default.Config_FlakCannon.ispeed;

	Damage=class'MutEM_XX'.default.Config_FlakCannon.iDamage;
	DamageRadius=class'MutEM_XX'.default.Config_FlakCannon.iDamageRadius;

	MomentumTransfer=class'MutEM_XX'.default.Config_FlakCannon.iMomentum;
	Bounces=class'MutEM_XX'.default.Config_FlakCannon.iShardBounces;
}

simulated function ProcessTouch(Actor Other, Vector HitLocation, Vector HitNormal)
{
	local Vehicle V;
	local UTPlayerController PC;

	if ( (Elite_Flak_Shard(Other) == none) && (Physics == PHYS_Falling || Other != Instigator) )
	{
		speed = VSize(Velocity);
		if (Speed > 400)
		{
			Other.TakeDamage(GetDamage(Other, HitLocation), InstigatorController, HitLocation, GetMomentumTransfer() * Normal(Velocity), MyDamageType,, self);
			if ( Role == ROLE_Authority )
			{
				V = Vehicle(Other);
				if ( V != None)
				{
					if ( PlayerController(V.Controller) != None )
					{
						PlayerController(V.Controller).ClientPlaySound(DefaultHitSound.Sound);
					}
					bWaitForEffects = SpawnImpactEffect(HitLocation, HitNormal);
				}
				else if (Pawn(Other) != None)
				{
					PlaySound(HitPawnSound, true);

					// play camera anim if short range kill
					if ( bCheckShortRangeKill && Pawn(Other).Health < 0 && Physics == PHYS_Projectile && Instigator != None &&
						VSize(Instigator.Location - Other.Location) < 150.0 )
					{
						PC = UTPlayerController(InstigatorController);
						if (PC != None)
						{
							PC.ClientPlayCameraAnim(ShortRangeKillAnim);
						}
					}
				}
				else if ( UTDeployedActor(Other) != None )
				{
					bWaitForEffects = SpawnImpactEffect(HitLocation, HitNormal);
				}
			}
		}
		Shutdown();
	}
}

defaultproperties
{
   MyDamageType=class'EM_XX.Elite_Flak_DMG'
	speed=3500.000000
	MaxSpeed=3500.000000
	Damage=18
	DamageRadius=+0.0
	MomentumTransfer=14000
	Bounces=2
}