/*
 * Class:  Elite_Enforcer_DMG
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Enforcer_DMG extends UTDmgType_Burning
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
   DamageOverlayTime=class'MutEM_XX'.default.Config_Enforcer.fDamageOverlayTime;
   DeathOverlayTime=class'MutEM_XX'.default.Config_Enforcer.fDamageOverlayTime;
   VehicleDamageScaling=class'MutEM_XX'.default.Config_Enforcer.fVehicleDamageScaling;
   VehicleMomentumScaling=class'MutEM_XX'.default.Config_Enforcer.fVehicleMomentumScaling;
   NodeDamageScaling=class'MutEM_XX'.default.Config_Enforcer.fNodeDamageScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

static function SpawnHitEffect(Pawn P, float Damage, vector Momentum, name BoneName, vector HitLocation)
{
	local UTEmit_VehicleHit BF;

	if ( Vehicle(P) != None )
	{
		BF = P.spawn(class'UTEmit_VehicleHit',P,, HitLocation, rotator(Momentum));
		BF.AttachTo(P, BoneName);
	}
	else
	{
		Super.SpawnHitEffect(P, Damage, Momentum, BoneName, HitLocation);
	}
}

defaultproperties
{
   DamageBodyMatColor=(R=1.000000,G=1.000000,B=1.000000,A=1.000000)
   DamageOverlayTime=1.000000
   DeathOverlayTime=1.000000
   GibPerterbation=2.000000

   KillStatsName="KILLS_ELITE_ENFORCER"
   DeathStatsName="DEATHS_ELITE_ENFORCER"
   SuicideStatsName="SUICIDES_ELITE_ENFORCER"
   RewardAnnouncementSwitch=7
   RewardEvent="REWARD_GUNStinger"
   DeathString="`k Killed `o."
   bAlwaysGibs=True

   DamageWeaponClass=Class'EM_XX.Elite_Enforcer'
   Name="Elite_Enforcer_DMG"
}
