/*
 * Class:  Elite_Enforcer
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Enforcer extends UTWeap_Enforcer
	dependson(MutEM_XX);

var() int EnforcerRecoil;

simulated function PostBeginPlay()
{
	super.PostBeginPlay();
	
   if ( class'MutEM_XX'.default.Config_Enforcer.bDoubles )
   {
   BecomeDual();
   }

	if ( Role == ROLE_Authority )
		SetTimer(class'MutEM_XX'.default.Config_Enforcer.fPriFireInterval * 2, true, 'AmmoRegen');

	FireInterval[0]=class'MutEM_XX'.default.Config_Enforcer.fPriFireInterval;
	FireInterval[1]=class'MutEM_XX'.default.Config_Enforcer.fSecFireInterval;

	Spread[0]=class'MutEM_XX'.default.Config_Enforcer.fprispread;
	Spread[1]=class'MutEM_XX'.default.Config_Enforcer.fsecspread;

	AmmoCount=class'MutEM_XX'.default.Config_Enforcer.iAmmoCount;
	LockerAmmoCount=class'MutEM_XX'.default.Config_Enforcer.iAmmoCount;
	MaxAmmoCount=class'MutEM_XX'.default.Config_Enforcer.iMaxAmmo;

	InstantHitDamage[0]=class'MutEM_XX'.default.Config_Enforcer.iPriDamage;
	InstantHitMomentum[0]=class'MutEM_XX'.default.Config_Enforcer.iMomentum;

	InstantHitDamage[1]=class'MutEM_XX'.default.Config_Enforcer.iSecDamage;
	InstantHitMomentum[1]=class'MutEM_XX'.default.Config_Enforcer.iMomentum;

	ShotCost[0]=class'MutEM_XX'.default.Config_Enforcer.iShotCost;
	ShotCost[1]=class'MutEM_XX'.default.Config_Enforcer.iShotCost;

	AimingHelpRadius[0]=class'MutEM_XX'.default.Config_Enforcer.iHelpRadius;
	AimingHelpRadius[1]=class'MutEM_XX'.default.Config_Enforcer.iHelpRadius;
	AimError=class'MutEM_XX'.default.Config_Enforcer.iAimError;

	AkimboTime=class'MutEM_XX'.default.Config_Enforcer.fAkimboTime;
	BurstCoolDownTime=class'MutEM_XX'.default.Config_Enforcer.fBurstCoolDownTime;
	BurstMax=class'MutEM_XX'.default.Config_Enforcer.iBurstMax;

	AIRating=class'MutEM_XX'.default.Config_Enforcer.fAIRating;
	MaxDesireability=class'MutEM_XX'.default.Config_Enforcer.fAIRating;
	CurrentRating=class'MutEM_XX'.default.Config_Enforcer.fAIRating;
   EnforcerRecoil=class'MutEM_XX'.default.Config_Enforcer.iEnforcerRecoil;
}

/**
 * Detect that we are trying to pickup another link gun and switch in to dual mode.
 */
function bool DenyPickupQuery(class<Inventory> ItemClass, Actor Pickup)
{
	if (ItemClass==class && DualMode != EDM_Dual)
	{
      if ( class'MutEM_XX'.default.Config_Enforcer.bDoubles )
      {
		   DualMode = EDM_DualEquipping;
		   BecomeDual();			// Handle any animations/effects locally.
		}
	}
	return super.DenyPickupQuery(ItemClass, Pickup);
}

simulated function PlayFireEffects( byte FireModeNum, optional vector HitLocation )
{
	local float Rate;
	// Play Weapon fire animation

	Rate = GetFireInterval(FireModeNum);

	// If we are in dual mode, we want to back it out to the normal speed

	if (DualMode == EDM_Dual)
	{
		Rate *= 2;
	}

	if ( FireModeNum < WeaponFireAnim.Length && WeaponFireAnim[FireModeNum] != '' )
	{
		PlayWeaponAnimation( GetFireAnim(FireModeNum), Rate,, UseLeftBarrel() ? LeftMesh : None );
		PlayArmAnimation( GetFireAnim(FireModeNum), Rate, UseLeftBarrel(),, UseLeftBarrel() ? LeftMesh : None );
		bLastFiredLeft=UseLeftBarrel();
	}

	// Start muzzle flash effect
	CauseMuzzleFlash();

	ShakeView();

	TrackShotCount();
	
	ProcessRecoil();
}

/* I'm making the recoil being handled in this function */
simulated function ProcessRecoil()
{
   if (Instigator != None)
   {	// Recoil will knock the player back
	   Instigator.AddVelocity( Normal(vector(Rotation) * -1 ) * class'MutEM_XX'.default.Config_Enforcer.iEnforcerRecoil / Instigator.Mass,
	   Instigator.Location,
	   InstantHitDamageTypes[0] );
   }
}

function AmmoRegen()
{
   if ( class'MutEM_XX'.default.Config_Enforcer.bAmmoRegeneration )
   {
	   if ( Instigator != None && !IsFiring() && AmmoCount < class'MutEM_XX'.default.Config_Enforcer.iMaxAmmo )
	   {
		   AddAmmo(1);
	   }
   }
}

simulated function BecomeDual()
{
	local UTPawn P;

	IconCoordinates = (DualMode == EDM_SingleWeapon) ? default.IconCoordinates : DualIconCoordinates;
	if ( DualMode == EDM_DualEquipping )
	{
//		MaxAmmoCount = 2 * Default.MaxAmmoCount;
		if (LeftMesh == None)
		{
			LeftMesh = UTSkeletalMeshComponent(new(self) Mesh.Class(Mesh));
			LeftMesh.SetScale3D(Mesh.Scale3D * vect(1,-1,1));
			AttachComponent(LeftMesh);
		}
		P = UTPawn(Instigator);
		if (P != None)
		{
			if (P.WeaponOverlayFlags != 0)
			{
				CreateOverlayMesh();
			}
			SetWeaponOverlayFlags(P);
		}
		SetTimer(DualEquiptime, false, 'DualEquipDone');
		if (P != None)
		{
			if (!Mesh.HiddenGame)
			{
				LeftMesh.SetHidden(false);
				if (WorldInfo.NetMode != NM_DedicatedServer && P.ArmsMesh[1] != None && Instigator.Weapon == self)
				{
					bUsesOffhand = true;
					P.AttachComponent(P.ArmsMesh[1]);
					P.ArmsMesh[1].SetHidden(false);
				}
			}

			P.bDualWielding = true;
			if (P.CurrentWeaponAttachment != None)
			{
				P.CurrentWeaponAttachment.SetDualWielding(true);
			}
		}
		if (EnforcerMuzzleFlashPSC[1] != None)
		{
			EnforcerMuzzleFlashPSC[1].SetFOV(LeftMesh.FOV);
			LeftMesh.AttachComponentToSocket(EnforcerMuzzleFlashPSC[1], MuzzleFlashSocket);
		}

		PlayWeaponAnimation( WeaponDualEqipAnim, DualEquiptime,, LeftMesh );
		PlayArmAnimation( WeaponDualEqipAnim, DualEquiptime, true,, LeftMesh );
	}
}

/////////////////////////////////////////////////////////////////
// Adjusted Spread
/////////////////////////////////////////////////////////////////

simulated function rotator AddSpread(rotator BaseAim)
{
	return Super.AddSpread(BaseAim);
}

/** Function that determines holding guns sideways. */
simulated function AkimboCheck()
{
	local vector HitLocation, HitNormal;
	local pawn HitPawn;

	// Go akimbo if you are shooting a dead thing within 300000 units, or a live thing within 150000   ( Ha Ha Ha - Take.dat/Foo )
	HitPawn = Pawn( Trace(HitLocation, HitNormal, Location + ((300000 * vect(1,0,0)) >> Rotation), Location, TRUE) );
	if(HitPawn != None && (HitPawn.Health <= 0 || VSize(HitLocation - Location) < 150000.0)
		&& !WorldInfo.GRI.OnSameTeam(Instigator, HitPawn) )
	{
		SetAkimbo(TRUE, TRUE);
	}
	else
	{
		SetAkimbo(FALSE, TRUE);
	}
}

simulated event SetPosition(UTPawn Holder)
{
	local vector OldSmallWeaponsOffset;

	if (LeftMesh != None)
	{
		switch (GetHand())
		{
			case HAND_Left:
				LeftMesh.SetScale3D(default.Mesh.Scale3D);
            LeftMesh.SetRotation(default.Mesh.Rotation);
				break;
			case HAND_Right:
				LeftMesh.SetScale3D(default.Mesh.Scale3D * vect(1,-0,1));
				LeftMesh.SetRotation(default.Mesh.Rotation * -1);
				break;
			default:
				break;
		}
	}

	OldSmallWeaponsOffset = SmallWeaponsOffset;
	if (DualMode != EDM_SingleWeapon)
	{
      FireOffset.X = 0;//19;
      FireOffset.Y = 0;
      FireOffset.Z = 0;//-10;
	}

	Super.SetPosition(Holder);

	SmallWeaponsOffset = OldSmallWeaponsOffset;
}

defaultproperties
{
	// First Enforcer
	Begin Object class=AnimNodeSequence Name=MeshSequenceA
	End Object
	// Second Enforcer
	Begin Object class=AnimNodeSequence Name=MeshSequenceB
	End Object

	// Weapon SkeletalMesh
	Begin Object Name=FirstPersonMesh
		SkeletalMesh=SkeletalMesh'WP_Enforcers.Mesh.SK_WP_Enforcers_1P'
		PhysicsAsset=None
		AnimSets(0)=AnimSet'WP_Enforcers.Anims.K_WP_Enforcers_1P_Base'
		Materials(0)=Material'EM_XX_Content.Enforcer_Final'
		Animations=MeshSequenceA
		//Scale=1.1
		FOV=55.0
		bForceUpdateAttachmentsInTick=true
	End Object

	ArmsAnimSet=AnimSet'WP_Enforcers.Anims.K_WP_Enforcers_1P_Arms'
	LeftArmAnimSet=AnimSet'WP_Enforcers.Anims.K_WP_Enforcers_1P_Arms'  //Dude, Nix the other arms!

	// Pickup staticmesh
	Begin Object Name=PickupMesh
		SkeletalMesh=SkeletalMesh'EM_XX_Content.Mesh.Enforcer_3P'
		Translation=(X=0.0,Y=0.0,Z=0.0)
		Scale=1.0
		Materials(0)=Material'EM_XX_Content.Enforcer_Final'
	End Object

	WeaponColor=(R=255,G=255,B=255,A=255)
	FireInterval(0)=+0.36

	BurstMax=3
	BurstCoolDownTime=0.97
	FireInterval(1)=+0.12

	WeaponFireTypes(0)=EWFT_InstantHit
	WeaponFireTypes(1)=EWFT_InstantHit
	FiringStatesArray(1)=WeaponBursting
	ShotCost(1)=1
	Spread(1)=0.03
	PlayerViewOffset=(X=0.0,Y=0.0,Z=0.0)
	SmallWeaponsOffset=(X=18.0,Y=6.0,Z=-6.0)
	MaxPitchLag=600
	MaxYawLag=800
	RotChgSpeed=3.0
	ReturnChgSpeed=3.0

	InstantHitDamage(0)=20
	InstantHitDamage(1)=20

	InstantHitMomentum(0)=1000
	InstantHitMomentum(1)=1000

	WeaponFireSnd[0]=SoundCue'A_Weapon_Enforcer.Cue.A_Weapon_Enforcer_Fire_Cue'
	WeaponFireSnd[1]=SoundCue'A_Weapon_Enforcer.Cue.A_Weapon_Enforcer_Fire_Cue'

	WeaponPutDownSnd=SoundCue'A_Weapon_Enforcer.Cue.A_Weapon_Enforcer_Lower_Cue'
	WeaponEquipSnd=SoundCue'A_Weapon_Enforcer.Cue.A_Weapon_Enforcer_Raise_Cue'
	
	//WeaponReloadSnd=SoundCue'A_Weapon_Enforcer.Cue.A_Weapon_Enforcer_ReloadComposite_Cue' // We do this with an anim notify ATM.

	PickupSound=SoundCue'A_Pickups.Weapons.Cue.A_Pickup_Weapons_Enforcer_Cue'

	AimingHelpRadius[0]=20.0
	AimingHelpRadius[1]=12.0

	MaxDesireability=0.4
	AIRating=+0.4
	CurrentRating=0.4
	bFastRepeater=true
	bInstantHit=true
	bSplashJump=false
	bRecommendSplashDamage=false
	bSniping=false
	ShouldFireOnRelease(0)=0
	ShouldFireOnRelease(1)=0
	InventoryGroup=2
	GroupWeight=0.5
	AimError=600

	AmmoCount=50
	LockerAmmoCount=50
	MaxAmmoCount=420

	MuzzleFlashSocket=MuzzleFlashSocket
	MuzzleFlashPSCTemplate=ParticleSystem'WP_Enforcers.Effects.P_WP_Enforcers_MuzzleFlash'
	MuzzleFlashDuration=0.33
	MuzzleFlashLightClass=class'UTGame.UTEnforcerMuzzleFlashLight'

	IconX=335
	IconY=81
	IconWidth=43
	IconHeight=39

	EquipTime=+0.2
	PutDownTime=+0.2

	LeftIdleAnim=WeaponIdleB
	WeaponReloadAnim=Weaponequipempty
	ArmReloadAnim=WeaponEquipFirst

	WeaponDualEqipAnim=WeaponEquiplFancy
	ArmDualEquipAnim=WeaponEquiplFancy

	BurstFireAnimName=WeaponFireBurst
	ArmBurstFireAnimName=WeaponFireBurst

	ReloadTime=2.0
	DualEquiptime=1.0

	DualMode=EDM_DualEquipping
	
	JumpDamping=1.5
	CrossHairCoordinates=(U=128,V=0,UL=64,VL=64)

	QuickPickGroup=3
	QuickPickWeight=0.2

	DroppedPickupOffsetZ=12.0

	AkimboTime=0.35

	PivotTranslation=(Y=-10.0)
	DualIconCoordinates=(U=600,V=515,UL=126,VL=75)

// ********************

   FireOffset=(X=0,Y=0,Z=0)

	AttachmentClass=class'EM_XX.Elite_Enforcer_Attach'
   bExportMenuData=True
	InstantHitDamageTypes(0)=class'EM_XX.Elite_Enforcer_DMG'
	InstantHitDamageTypes(1)=class'EM_XX.Elite_Enforcer_DMG'
	DualEnforcerDamageType=class'EM_XX.Elite_Enforcer_DMG'

   EnforcerRecoil=0
   Priority=900.1

   ItemName="Elite Enforcers"
   PickupMessage="Elite Enforcers"
   Name="Elite Enforcers"
}
