/*
 * Class:  Elite_Bio_GooDMG
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_Bio_GooDMG extends UTDmgType_BioGoo
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	DamageOverlayTime=class'MutEM_XX'.default.Config_Bio_Rifle.fDamageOverlayTime;
	DeathOverlayTime=class'MutEM_XX'.default.Config_Bio_Rifle.fDamageOverlayTime;
	VehicleDamageScaling=class'MutEM_XX'.default.Config_Bio_Rifle.fVehicleDamageScaling;
	VehicleMomentumScaling=class'MutEM_XX'.default.Config_Bio_Rifle.fVehicleMomentumScaling;
	NodeDamageScaling=class'MutEM_XX'.default.Config_Bio_Rifle.fNodeDamageScaling;
}

static function float VehicleDamageScalingFor(Vehicle V)
{
	if ( (UTVehicle(V) != None) && UTVehicle(V).bLightArmor )
		return 1.5 * Default.VehicleDamageScaling;

	return Default.VehicleDamageScaling;
}

defaultproperties
{
   NodeDamageScaling=1
   DamageWeaponClass=Class'EM_XX.Elite_Bio_Rifle'
   Name="Elite_Bio_GooDMG"
}
