/*
 * Class:  Elite_BioGlobling
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class Elite_BioGlobling extends Elite_BioShot
	dependson(MutEM_XX);

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

	Damage=class'MutEM_XX'.default.Config_Bio_Rifle.iDamage;
	DamageRadius=class'MutEM_XX'.default.Config_Bio_Rifle.iDamageRadius;

	MomentumTransfer=class'MutEM_XX'.default.Config_Bio_Rifle.iMomentum;

   Speed=class'MutEM_XX'.default.Config_Bio_Rifle.iGloblingSpeed;
   maxSpeed=class'MutEM_XX'.default.Config_Bio_Rifle.iGloblingSpeed;

	DripTime=class'MutEM_XX'.default.Config_Bio_Rifle.fDripTime;
}

simulated function ProcessTouch(Actor Other, Vector HitLocation, Vector HitNormal)
{
	if ( Other.bProjTarget && (Elite_BioGlob(Other) == None) && !bExploded )
	{
		Other.TakeDamage(Damage, InstigatorController, Location, MomentumTransfer * Normal(Velocity), MyDamageType,, self);
		Explode( HitLocation, HitNormal );
	}
}

auto state Flying
{
	simulated function ProcessTouch(Actor Other, Vector HitLocation, Vector HitNormal)
	{
		Global.ProcessTouch(Other, HitLocation, HitNormal);
   	}
}

state OnGround
{
	simulated function ProcessTouch(Actor Other, Vector HitLocation, Vector HitNormal)
	{
		Global.ProcessTouch(Other, HitLocation, HitNormal);
	}
}

defaultproperties
{
   Name="Elite_BioGlobling"
}
