class ElitePlayer extends UTPlayerController //UTPlayerController
	dependson(MutEM_XX);

var vector HoldAccel,HoldVelocity,RollDir;
var bool bCanHover;
var float AirResistance,ThetaDone,NTime;
var float MaxHoverTime;
var bool bMMDebug;
var rotator InitRot;

simulated function PostBeginPlay()
{
	Super.PostBeginPlay();

   MaxHoverTime=class'MutEM_XX'.default.Config_Content.iMaxHoverTime;

}

//----------------------------------------------
//--------------- Default state ----------------
//----------------------------------------------

state PlayerWalking
{
   ignores SeePlayer, HearNoise;

	function bool NotifyLanded(vector HitNormal, Actor FloorActor)
	{
		bCanHover = true;
		return Super.NotifyLanded(HitNormal,FloorActor);
	}

	function ProcessMove(float DeltaTime, vector NewAccel, eDoubleClickDir DoubleClickMove, rotator DeltaRot)
      {
         if ( (DoubleClickMove != DCLICK_None) )
         {
            if ( DoubleClickMove < DCLICK_Active )
            {
				   ElitePawn(Pawn).Dodge(DoubleClickMove);
			   }
         }

         if ( Pawn == None )
            return;

         Pawn.Acceleration = NewAccel;

         if ( bDoubleJump && (bUpdating || ElitePawn(Pawn).CanDoubleJump()) )
            ElitePawn(Pawn).DoDoubleJump(bUpdating);
         else if ( bPressedJump )
		   {
            ElitePawn(Pawn).DoJump(bUpdating);
		   }

         if (Role == ROLE_Authority)
         {
            Pawn.SetRemoteViewPitch(Rotation.Pitch);
	 	   }

         if ( Pawn.Physics != PHYS_Falling )
         {
            if (bDuck == 0)
               Pawn.ShouldCrouch(false);
            else if ( Pawn.bCanCrouch )
               Pawn.ShouldCrouch(true);
         }

		   if ((Pawn.Physics == PHYS_Falling) && (bDuck == 1) && bCanHover && (MaxHoverTime > 0))
		   {
			   bCanHover = false;
			   GotoState('MMHovering');
		   }
      }

   function BeginState(Name PreviousStateName)
	{
		Super.BeginState(PreviousStateName);

		if (Pawn.Physics == PHYS_Walking)
		{
			bCanHover = true;
		}
	}
}


//----------------------------------------------
//------------ Crouch Hover state --------------
//----------------------------------------------

state MMHovering
{
   ignores SeePlayer, HearNoise, Bump;

	event Timer()
	{
		bDuck = 0;
	}

   function bool NotifyLanded(vector HitNormal, Actor FloorActor)
   {
	   bDuck = 0;
		return Global.NotifyLanded(HitNormal,FloorActor);
	}

	function ProcessMove(float DeltaTime, vector NewAccel, eDoubleClickDir DoubleClickMove, rotator DeltaRot)
   {
      if ( Pawn == None )
         return;

		if( VSize(NewAccel) == 0.0 )
         Pawn.Velocity /= 1 + DeltaTime * AirResistance;

	   if (Role == ROLE_Authority)
      {
         Pawn.SetRemoteViewPitch(Rotation.Pitch);
      }

		if (bDuck == 0)
		{
			Pawn.SetPhysics(PHYS_Falling);
			GotoState('PlayerWalking');
		}

   }

	function PlayerMove(float DeltaTime)
	{
		local vector X,Y,Z;
		
		GetAxes(Rotation,X,Y,Z);

		if ( VSize(Pawn.Acceleration) < 1.0 )
			Pawn.Acceleration = vect(0,0,0);
		if ( VSize(Pawn.Velocity) < 1.0 )
			Pawn.Velocity = vect(0,0,0);

		UpdateRotation(DeltaTime);

      if ( Role < ROLE_Authority ) // then save this move and replicate it
         ReplicateMove(DeltaTime, Pawn.Acceleration, DCLICK_None, rot(0,0,0));
      else
         ProcessMove(DeltaTime, Pawn.Acceleration, DCLICK_None, rot(0,0,0));
   }
	
	function BeginState(Name PreviousStateName)
	{
		HoldAccel = Pawn.Acceleration;
		HoldVelocity = Pawn.Velocity;
		Pawn.Acceleration = vect(0,0,0);
		Pawn.SetPhysics(PHYS_Flying);
//		Pawn.PlayVictoryAnimation();

		if ( bMMDebug ) ClientMessage("MaxHoverTime: "$string(MaxHoverTime));
		SetTimer(MaxHoverTime,false);
	}

	function EndState(Name NextStateName)
	{
		SetTimer(0,false);

		if ( Pawn != None )
		{
			Pawn.Acceleration = HoldAccel;
			Pawn.Velocity = HoldVelocity;
			if ( Pawn.Physics != PHYS_Walking ) bCanHover = false;
			else bCanHover = true;
			Pawn.ShouldCrouch(false);
		}
	}
}

defaultproperties
{
   bCanHover=True
   MaxHoverTime=7
   AirResistance=5
}
