/*
 * Class:  EliteMachine_GameRules
 * By: James Bishop A.K.A. *PingFre@K*
 * Copyright 1998-2009 Epic Games, Inc. All Rights Reserved.
*/

class EliteMachine_GameRules extends GameRules
      config(EM_XX);

   /*** Headshot Announcement Variables ***/
var soundcue      Killer_Sounds[49],
                  Killed_Sounds[12];

// My Content //
struct NewContent
{
	var config bool bHitSounds;
	var config bool bShowDMG;
	var config bool bHeadshotSounds;
	var config bool bHeadshotMessage;
};
var config NewContent Config_Content;

function NetDamage( int OriginalDamage, out int Damage, pawn injured, Controller instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
   local UTPawn InstigatorPawn, InjuredPawn;

   if((instigatedBy != None) && (instigatedBy.Pawn != None))
   {
   // Add Display Damage
		if (class'EM_XX.MutEM_XX'.default.Config_Content.bShowDMG)
		{
      playercontroller(instigatedby).ReceiveLocalizedMessage(class'EM_XX.DMGMsg', originaldamage);
      }

   // Add Hit Sound
		if (class'EM_XX.MutEM_XX'.default.Config_Content.bHitSounds)
		{
      PlayerController(InstigatedBy).ClientPlaySound(SoundCue'EM_XX_Content.Q_HitSoundCue');
      }
      
   // Add Vampirism
		if (class'EM_XX.MutEM_XX'.default.Config_Content.bVampirism)
		{
         if (InstigatedBy != None) InstigatorPawn = UTPawn(InstigatedBy.Pawn);
         InjuredPawn = UTPawn(Injured);

	      if (InjuredPawn != None && InstigatorPawn != None && InjuredPawn != InstigatorPawn && Damage < 5000)
         {
		      InstigatorPawn.GiveHealth(class'EM_XX.MutEM_XX'.default.Config_Content.iVampHealth,InstigatorPawn.HealthMax);
	      }
	   }
   }

   // Add No Self Damage
   if (class'EM_XX.MutEM_XX'.default.Config_Content.bNoSelfDamage)
   {
	   if ( instigatedBy != None && instigatedBy.Pawn != None && instigatedBy.Pawn == injured )
	   {
		   Damage = 0;
	   }
   }

	if(injured.Controller != None && PlayerController(InstigatedBy) != PlayerController(injured.Controller))
		Super.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
		
  	if (NextGameRules != None) NextGameRules.NetDamage (OriginalDamage, Damage, Injured, InstigatedBy, HitLocation, Momentum, DamageType);
}

function ScoreKill(Controller Killer, Controller Killed)
{
   local int num;
   local int amt;

   num = Rand(49);
   amt = Rand(12);

	if ( PlayerController(Killer) != None )
   {
      if (class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotSounds)
		{
	      playercontroller(killer).clientPlaySound(Killer_Sounds[num]);
	   }
      if (class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotMessage)
		{
	      Playercontroller(Killer).ReceiveLocalizedMessage(class'Killer_Message',num, Killer.PlayerReplicationInfo);
	   }
	}
	
	if ( PlayerController(Killed) != None )
   {
      if (class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotSounds)
		{
	      playercontroller(Killed).clientPlaySound(Killed_Sounds[amt]);
	   }
      if (class'EM_XX.MutEM_XX'.default.Config_Content.bHeadshotMessage)
		{
	      Playercontroller(Killed).ReceiveLocalizedMessage(class'Killed_Message',amt, Killed.PlayerReplicationInfo);
	   }
   }

	if ( NextGameRules != None )
	{
		NextGameRules.ScoreKill(Killer,Killed);
	}
}

// Inventory Drop //
function bool PreventDeath(Pawn Killed, Controller Killer, class<DamageType> damageType, vector HitLocation)
{
	local UTWeapon Weap;
	local vector DropAngle;
	local rotator DropRotation;

   if (class'EM_XX.MutEM_XX'.default.Config_Content.bInventoryDrop)
   {
      if ( (NextGameRules != None) && NextGameRules.PreventDeath(Killed,Killer, damageType,HitLocation) )
		return true;

      if (Killed != None)
      {
         if (Killed.InvManager != none )
    	   {
    		   ForEach Killed.InvManager.InventoryActors(class'UTWeapon', Weap)
    		   {
               if ( Weap != none && Weap.HasAnyAmmo() && Weap != Killed.Weapon)
    		      {
    		         DropRotation = Killed.Rotation;
                  DropRotation.Yaw = Rand(65536);
    		         DropAngle = Vector(DropRotation);
    		         DropAngle = DropAngle * ((Killed.Velocity Dot DropAngle) + 500) + Vect(0,0,200);

                  Killed.TossWeapon(Weap,DropAngle);
    		      }
    		   }
    	   }
      }
	return false;
	}
}

defaultproperties
{

    Killer_Sounds(0)=SoundCue'EM_XX_Content.DeathAnnounce_Content.annhilationCue'
    Killer_Sounds(1)=SoundCue'EM_XX_Content.DeathAnnounce_Content.bBoomCue'
    Killer_Sounds(2)=SoundCue'EM_XX_Content.DeathAnnounce_Content.bBowDownCue'
    Killer_Sounds(3)=SoundCue'EM_XX_Content.DeathAnnounce_Content.bFearmeCue'
    Killer_Sounds(4)=SoundCue'EM_XX_Content.DeathAnnounce_Content.bInferiorCue'
    Killer_Sounds(5)=SoundCue'EM_XX_Content.DeathAnnounce_Content.BloodbathCue'
    Killer_Sounds(6)=SoundCue'EM_XX_Content.DeathAnnounce_Content.BobjectivedestCue'
    Killer_Sounds(7)=SoundCue'EM_XX_Content.DeathAnnounce_Content.BobsoleteCue'
    Killer_Sounds(8)=SoundCue'EM_XX_Content.DeathAnnounce_Content.BomegaCue'
    Killer_Sounds(9)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Bloodbath2Cue'
    Killer_Sounds(10)=SoundCue'EM_XX_Content.DeathAnnounce_Content.ByoudieCue'
    Killer_Sounds(11)=SoundCue'EM_XX_Content.DeathAnnounce_Content.daddyCue'
    Killer_Sounds(12)=SoundCue'EM_XX_Content.DeathAnnounce_Content.damnCue'
    Killer_Sounds(13)=SoundCue'EM_XX_Content.DeathAnnounce_Content.EagleEyeCue'
    Killer_Sounds(14)=SoundCue'EM_XX_Content.DeathAnnounce_Content.erasedCue'
    Killer_Sounds(15)=SoundCue'EM_XX_Content.DeathAnnounce_Content.erradicationCue'
    Killer_Sounds(16)=SoundCue'EM_XX_Content.DeathAnnounce_Content.ErrorCue'
    Killer_Sounds(17)=SoundCue'EM_XX_Content.DeathAnnounce_Content.excelCue'
    Killer_Sounds(18)=SoundCue'EM_XX_Content.DeathAnnounce_Content.ExterminationCue'
    Killer_Sounds(19)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Extermination2Cue'
    Killer_Sounds(20)=SoundCue'EM_XX_Content.DeathAnnounce_Content.GinsuCue'
    Killer_Sounds(21)=SoundCue'EM_XX_Content.DeathAnnounce_Content.GoalCue'
    Killer_Sounds(22)=SoundCue'EM_XX_Content.DeathAnnounce_Content.HastaCue'
    Killer_Sounds(23)=SoundCue'EM_XX_Content.DeathAnnounce_Content.HatTrickCue'
    Killer_Sounds(24)=SoundCue'EM_XX_Content.DeathAnnounce_Content.HolyShit_FCue'
    Killer_Sounds(25)=SoundCue'EM_XX_Content.DeathAnnounce_Content.HolyShit_F2Cue'
    Killer_Sounds(26)=SoundCue'EM_XX_Content.DeathAnnounce_Content.insaneCue'
    Killer_Sounds(27)=SoundCue'EM_XX_Content.DeathAnnounce_Content.KnockedoutCue'
    Killer_Sounds(28)=SoundCue'EM_XX_Content.DeathAnnounce_Content.laughCue'
    Killer_Sounds(29)=SoundCue'EM_XX_Content.DeathAnnounce_Content.nc17Cue'
    Killer_Sounds(30)=SoundCue'EM_XX_Content.DeathAnnounce_Content.nicecatchCue'
    Killer_Sounds(31)=SoundCue'EM_XX_Content.DeathAnnounce_Content.NPCue'
    Killer_Sounds(32)=SoundCue'EM_XX_Content.DeathAnnounce_Content.NS1Cue'
    Killer_Sounds(33)=SoundCue'EM_XX_Content.DeathAnnounce_Content.OTrespectmyCue'
    Killer_Sounds(34)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Owned13Cue'
    Killer_Sounds(35)=SoundCue'EM_XX_Content.DeathAnnounce_Content.PrepareCue'
    Killer_Sounds(36)=SoundCue'EM_XX_Content.DeathAnnounce_Content.ProceedCue'
    Killer_Sounds(37)=SoundCue'EM_XX_Content.DeathAnnounce_Content.RampageCue'
    Killer_Sounds(38)=SoundCue'EM_XX_Content.DeathAnnounce_Content.RetributionCue'
    Killer_Sounds(39)=SoundCue'EM_XX_Content.DeathAnnounce_Content.TerminatedCue'
    Killer_Sounds(40)=SoundCue'EM_XX_Content.DeathAnnounce_Content.TerminationCue'
    Killer_Sounds(41)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Top_GunCue'
    Killer_Sounds(42)=SoundCue'EM_XX_Content.DeathAnnounce_Content.TotalledCue'
    Killer_Sounds(43)=SoundCue'EM_XX_Content.DeathAnnounce_Content.UnrealCue'
    Killer_Sounds(44)=SoundCue'EM_XX_Content.DeathAnnounce_Content.UnstoppableCue'
    Killer_Sounds(45)=SoundCue'EM_XX_Content.DeathAnnounce_Content.WhickedSickCue'
    Killer_Sounds(46)=SoundCue'EM_XX_Content.DeathAnnounce_Content.WootCue'
    Killer_Sounds(47)=SoundCue'EM_XX_Content.DeathAnnounce_Content.WowCue'
    Killer_Sounds(48)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Wtf5Cue'
    
    Killed_Sounds(0)=SoundCue'EM_XX_Content.DeathAnnounce_Content.bottom_feederCue'
    Killed_Sounds(1)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Burn_out2Cue'
    Killed_Sounds(2)=SoundCue'EM_XX_Content.DeathAnnounce_Content.degradationCue'
    Killed_Sounds(3)=SoundCue'EM_XX_Content.DeathAnnounce_Content.DisgraceCue'
    Killed_Sounds(4)=SoundCue'EM_XX_Content.DeathAnnounce_Content.failedCue'
    Killed_Sounds(5)=SoundCue'EM_XX_Content.DeathAnnounce_Content.HijackedCue'
    Killed_Sounds(6)=SoundCue'EM_XX_Content.DeathAnnounce_Content.Humiliating_defeatCue'
    Killed_Sounds(7)=SoundCue'EM_XX_Content.DeathAnnounce_Content.OutrageCue'
    Killed_Sounds(8)=SoundCue'EM_XX_Content.DeathAnnounce_Content.OwnageCue'
    Killed_Sounds(9)=SoundCue'EM_XX_Content.DeathAnnounce_Content.ShameCue'
    Killed_Sounds(10)=SoundCue'EM_XX_Content.DeathAnnounce_Content.slaughter2Cue'
    Killed_Sounds(11)=SoundCue'EM_XX_Content.DeathAnnounce_Content.whoreCue'

}