/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Quickfoot extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true;
}

function AddMagic (UTPawn P, int Level)
{
  P.GroundSpeed = P.GroundSpeed * (1.0 + Level/20.0);
  P.WaterSpeed = P.WaterSpeed * (1.0 + Level/20.0);
}

function RemoveMagic (UTPawn P, int Level)
{
  P.GroundSpeed = P.GroundSpeed / (1.0 + Level/20.0);
  P.WaterSpeed = P.WaterSpeed / (1.0 + Level/20.0);
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * (1.0 + Level * 0.02); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Quickfoot";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Quick';
  bPositiveMagic = true;
  DamageChangePercentage = 2;
}