/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Poison_InvItem extends Inventory;

var Controller InstigatorController; // Client and server
var int Level; // Server
var bool bShownMessage; // Client

replication
{
  if (Role == ROLE_Authority)
    InstigatorController;
}


simulated function PostBeginPlay()
{
  super.PostBeginPlay();
  SetTimer (1.0, True, 'Timer');
}

simulated function Timer()
{
  if (Role == ROLE_Authority) {
    if (Owner == None) {
      Destroy();
      return;
    }

    Owner.TakeDamage(Level * 2, InstigatorController, Owner.Location, vect(0,0,0), class'BattleWeaponMagic_Poison_DamageType');
  }

  if (WorldInfo.NetMode != NM_DedicatedServer && UTPawn(Owner) != None && UTPawn(Owner).Controller != None) {
    if (!bShownMessage && UTPawn(Owner).Controller != None) {
      if (InstigatorController != None && InstigatorController.PlayerReplicationInfo != None) {        
        class'BattleStaticFunctions'.static.Message2Pawn (UTPawn(Owner), "posionedfrom", "You have been poisoned by"@InstigatorController.PlayerReplicationInfo.PlayerName);
        class'BattleStaticFunctions'.static.Message2PC (PlayerController(InstigatorController), "posionedto", "You poisoned"@UTPawn(Owner).Controller.PlayerReplicationInfo.PlayerName);
      } else {
        class'BattleStaticFunctions'.static.Message2Pawn (UTPawn(Owner), "posionedfrom", "You have been poisoned");
      }
      bShownMessage = true;
      if (Role != ROLE_Authority) Destroy (); 
    }    
  }
}

defaultproperties
{
}