/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Poison extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  if (ClassIsChildOf(W.Class, class'UTWeap_Stinger')) return false;
  return true;
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local BattleWeaponMagic_Poison_InvItem Inv;

  if (DamageType == class'BattleWeaponMagic_Poison_DamageType' || Damage <= 0)  return;
  if (InjuredPawn == None) return;
  if (UTTeamGame(P.WorldInfo.Game) != None && P != InjuredPawn && P.GetTeam() == InjuredPawn.GetTeam()) return; // You can poison yourself but not your team mates

  Inv = BattleWeaponMagic_Poison_InvItem (InjuredPawn.FindInventoryType (class'BattleWeaponMagic_Poison_InvItem'));
  if (Inv == None) {
    Inv = InjuredPawn.Spawn (class'BattleWeaponMagic_Poison_InvItem', InjuredPawn);
	Inv.GiveTo (InjuredPawn);
  }
  if (Inv == None) return;
  Inv.Level = Level;
  Inv.Lifespan = 5;
  Inv.InstigatorController = P.Controller;

  Damage = Damage * (1.0 + Level * 0.02); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Poison";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_BioGreen';
  bPositiveMagic = true;
  DamageChangePercentage = 2;
}