/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Medic extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true;
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local int GiveHealth;
  local PlayerController PC;
  local BPRIDATA BD;

  if (InjuredPawn == None) return;
  if (P == InjuredPawn) { // Self healing
    GiveHealth = Level; // Up to 5
  } else if (UTTeamGame(P.WorldInfo.Game) != None && P.GetTeam() == InjuredPawn.GetTeam()) { // Heal a team mate
    GiveHealth = 5 * Level; // Up to 25 (somewhere OriginalDamage gets set to 0 unfortunately)
  }
  if (GiveHealth > 0) {
    Damage = 0;
  }
  GiveHealth = Min (GiveHealth, InjuredPawn.HealthMax - InjuredPawn.Health + 10 * Level);
  if (GiveHealth > 0) {
    if (InjuredPawn != None && InjuredPawn.Controller != None && P != InjuredPawn) {
      if (P != None && P.Controller != None && P.Controller.PlayerReplicationInfo != None) {
        class'BattleStaticFunctions'.static.Message2Pawn (InjuredPawn, "healedfrom", "You have been healed by "@P.Controller.PlayerReplicationInfo.PlayerName);
        class'BattleStaticFunctions'.static.Message2Pawn (P, "healedto", "You healed "@InjuredPawn.Controller.PlayerReplicationInfo.PlayerName@" +"@GiveHealth);
      } else {
        class'BattleStaticFunctions'.static.Message2Pawn (InjuredPawn, "healedfrom", "You have been healed");
      }
    } else {
      class'BattleStaticFunctions'.static.Message2Pawn (P, "healedto", "You healed +"@GiveHealth);
    }
    InjuredPawn.Health += GiveHealth;
    if (P != InjuredPawn) { // Give the healer some experience
      if (Rand (100) < GiveHealth) { // 1% chance per 1 health
        if (P != None && P.Owner != None) {
          PC = PlayerController (P.Owner);
          if (PC != None) {
            BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
            BD.XP += 1;
            class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
          }
        }              
      }    
    }
  }

  Damage = Damage * (1.0 + Level * 0.02); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Medic";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_LiquidWhite';
  bPositiveMagic = true;
  DamageChangePercentage = 2;
}