/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Infinity extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  if (ClassIsChildOf(W.Class, class'UTWeap_ImpactHammer')) return false;
  if (ClassIsChildOf(W.Class, class'UTWeap_Stinger')) return false;
  return true;
}

function RapidServerTimer (UTPawn P, int Level)
{
  if (UTWeapon(P.Weapon) != None && !UTWeapon(P.Weapon).bSuperWeapon) {
    if (UTWeapon(P.Weapon).MaxAmmoCount - UTWeapon(P.Weapon).AmmoCount > 0) {
      UTWeapon(P.Weapon).AddAmmo (UTWeapon(P.Weapon).MaxAmmoCount - UTWeapon(P.Weapon).AmmoCount);
    }
  }
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  Damage = Damage * (1.0 + Level * 0.03); // It's positive magic, so we do some extra damage as well
}

defaultproperties
{
  MagicName = "Infinity";
  MagicMaxLevel = 10;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Infinity';
  bPositiveMagic = true;
  DamageChangePercentage = 3;
}