/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleWeaponMagic_Emo extends BattleWeaponMagic config (BattleRPG);

function bool AllowedFor (Weapon w)
{
  return true; // Allow it for everything
}

function DamageToOtherPawn (UTPawn P, int Level, int OriginalDamage, out int Damage, UTPawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local int AntiBonus; 
  AntiBonus = int (Damage * 0.05 * Level);

  // Check if InjuredPawn has enough Health left, otherwise reduce the antibonus.
  if (InjuredPawn!=None) {
    if (Damage > InjuredPawn.Health) AntiBonus = int (InjuredPawn.Health * 0.05 * Level);
  }

  if (AntiBonus > 0) { // Prevent self healing
    P.Health -= AntiBonus;
    if (P.Health < 1) P.Health = 1; // Don't kill the owner
  }

  Damage = Damage * (1.0 - Level * 0.03); // It's negative magic, so we reduce damage as well
}

defaultproperties
{
  MagicName = "Emo";
  MagicMaxLevel = 5;
  MagicMaterial = Material'BattleRPGContent.Materials.MT_Gore';
  bPositiveMagic = false;
  DamageChangePercentage = 3;
}