/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleProjectile_SeekingRocket extends UTProj_SeekingRocket;

var bool bBouncing;
var int Bounces;

replication {
  if (Role == ROLE_Authority) 
    bBouncing;
}

simulated event HitWall (vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
  local Actor A;
   
  if (bBouncing && UTPawn (Wall) == None && UTVehicle (Wall) == None && ++Bounces < 5) {
    foreach VisibleCollidingActors(class'Actor', A, 0.75 * DamageRadius, Location) {
      if (UTPawn (A) != None || UTVehicle (A) != None) {
        Super.HitWall (HitNormal, Wall, WallComp);        
        return;
      }
    } 
    Velocity = 0.9 * (Velocity - 2.0 * HitNormal * (Velocity dot HitNormal));
    Speed = VSize (Velocity);
    SetRotation (Rotator (Velocity));
    bBlockedByInstigator = true;
  } else {
    Super.HitWall (HitNormal, Wall, WallComp);
  }
}

defaultproperties
{
  Name="BattlePRI"
}