/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

// There should be no need for a backup database, but UT3 is no database, so I prefer to do it anyway.
class BattlePersistentPlayerBackupDatabase extends Object config (BattlePersistentPlayerBackupDatabase);

// We backup the most important thing to a RPG player, his/her level.
struct RECORD {
  var name ID;
  var int Level; 
};

var config array<RECORD> DATABASE;
var bool bDirty;

function Commit ()
{
  if (bDirty) { // Only write to disk when there is something to write
    SaveConfig(); // Save the database to disk (useful if the server decides to crash)
  }
}

function SavePlayerLevelBackup (name ID, int Level)
{
  local int index;
  local RECORD R;

  if (Level < 10) return; // Try to keep the database small

  index = DATABASE.Find ('ID', ID); // Let's hope Epic made this with hashing
  if (index==-1) { // insert new record
    bDirty = true;
    R.ID = ID;
    R.Level = Level;
    DATABASE.AddItem (R);
  } else { // update existing record
    if (Level > DATABASE[index].Level && Level < 1000) { // Only increase the level, never reduce it
      bDirty = true;
      DATABASE[index].Level = Level;
    }
  } 
}

function int LoadPlayerLevelBackup (name ID)
{
  local int index;

  index = DATABASE.Find ('ID', ID); // Let's hope Epic made this with hashing
  if (index != -1) {
    return DATABASE[index].Level;
  }
  return 0;
}

defaultproperties
{
  Name="BattlePersistentPlayerBackupDatabase"
}