/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

`include (BattleRPG/Classes/BattleRPG.uci)

`if(`isdefined(BRPG_BuildRegular))  
  // Dummy class to make the compiler happy
  class BattlePRIInvasion extends UTPlayerReplicationInfo;
`endif
`if(`isdefined(BRPG_Build4UT3Invasion))
  class BattlePRIInvasion extends InvasionPlayerReplicationInfo;
`endif
`if(`isdefined(BRPG_Build4GaltanorsInvasion))
  class BattlePRIInvasion extends InvPlayerReplicationInfo;
`endif

var int Level;
var int XP;
var int NeededXP;
var string WeaponMagicDescription;
var bool bAllowDodgeJumping;
var int Mana;
var int PrevScore;
var BattlePersistentPlayerDatabase BPD;

replication
{
  if (Role == ROLE_Authority)
    Level, XP, NeededXP, Mana, bAllowDodgeJumping, WeaponMagicDescription;
}

function Tick (float DeltaTime)
{

  if (Role == ROLE_Authority) {
    class'BattleStaticFunctions'.static.PRITick(self); 
`if(`isdefined(BRPG_Build4GaltanorsInvasion))
    if (PlayerLevel != Level) PlayerLevel = Level;
`endif
  }
}


defaultproperties
{
  Name="BattlePRI"
}