/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/ 

class BattleGameRules extends GameRules dependson(BattleStaticFunctions);

function ScoreKill (Controller Killer, Controller Killed)
{
  local BPRIDATA BD_Killer;
  local BPRIDATA BD_Killed;
  local int Bonus;

  if (Killer != None && Killer.PlayerReplicationInfo != None && Killed != None && Killed.PlayerReplicationInfo != None) {
    BD_Killer = class'BattleStaticFunctions'.static.ReadBPRI (Killer.PlayerReplicationInfo);
    BD_Killed = class'BattleStaticFunctions'.static.ReadBPRI (Killed.PlayerReplicationInfo);
    if (BD_Killer.Level != 0 && BD_Killed.Level != 0) {
      // Bonus if you kill someone with a higher level than yourself
      if (BD_Killer.Level < BD_Killed.Level) {
        Bonus = ((BD_Killed.Level - BD_Killer.Level) * (BD_Killed.Level - BD_Killer.Level)) / 25;
        if (Bonus >= 1) {
          BD_Killer.XP += Bonus;
          class'BattleStaticFunctions'.static.WriteBPRI (Killer.PlayerReplicationInfo, BD_Killer);
        }
      }
    }
  }
  if (NextGameRules != None) NextGameRules.ScoreKill(Killer, Killed);
}

function NetDamage (int OriginalDamage, out int Damage, pawn Injured, Controller InstigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  local UTPawn P_Injured;
  local UTPawn P_InstigatedBy;
  local Pawn LLP_Injured;
  local Pawn LLP_InstigatedBy;
  local BattleGenInvItem4Pawns BGI_Injured;
  local BattleGenInvItem4Pawns BGI_InstigatedBy;
  local BWEAPDATA BWEAP_Injured;
  local BWEAPDATA BWEAP_InstigatedBy;
  local BattlePlayerController BPC;
  local BattleWeaponMagic_Quantum_InvItem Inv;
  local BattleArtifact BAF;
  local int i;
  local int InputDamage;

  InputDamage = Damage;
  
  // Determine the involved pawns and controllers
  LLP_Injured = Injured;
  P_Injured = UTPawn (Injured);
  if (InstigatedBy != None) {
    LLP_InstigatedBy = InstigatedBy.Pawn;
    P_InstigatedBy = UTPawn (InstigatedBy.Pawn);    
  }

  // Handle "DamageToOtherPawn" for all abilities (seen from the InstigatedBy player, e.g. damage bonus)
  if (P_InstigatedBy != None) {
    BGI_InstigatedBy = BattleGenInvItem4Pawns (P_InstigatedBy.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI_InstigatedBy != None) {
      for (i=0; i<BGI_InstigatedBy.ActiveAbilitiesLength; i++) {
        BGI_InstigatedBy.GetAbility(i).DamageToOtherPawn (P_InstigatedBy, BGI_InstigatedBy.GetAbilityLevel(i), OriginalDamage, Damage, P_Injured, HitLocation, Momentum, DamageType);
        BGI_InstigatedBy.GetAbility(i).LLDamageToOtherPawn (LLP_InstigatedBy, BGI_InstigatedBy.GetAbilityLevel(i), OriginalDamage, Damage, LLP_Injured, HitLocation, Momentum, DamageType);
      }
    }
  }

  // Handle "LLDamageToOtherPawn" for all abilities (seen from the InstigatedBy player, e.g. vehicle vampirism)
  if (LLP_InstigatedBy != None && Vehicle (LLP_InstigatedBy) != None && UTPawn (Vehicle (LLP_InstigatedBy).Driver) != None) {
    BGI_InstigatedBy = BattleGenInvItem4Pawns (Vehicle (LLP_InstigatedBy).Driver.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI_InstigatedBy != None) {
      for (i=0; i<BGI_InstigatedBy.ActiveAbilitiesLength; i++) {
        BGI_InstigatedBy.GetAbility(i).LLDamageToOtherPawn (LLP_InstigatedBy, BGI_InstigatedBy.GetAbilityLevel(i), OriginalDamage, Damage, LLP_Injured, HitLocation, Momentum, DamageType);
      }
    }
  }

  // Handle "DamageFromOtherPawn" for all abilities (seen from the Injured player, e.g. damage reduction)
  if (P_Injured != None) {
    BGI_Injured = BattleGenInvItem4Pawns (P_Injured.FindInventoryType(class'BattleRPG.BattleGenInvItem4Pawns'));
    if (BGI_Injured != None) {
      for (i=0; i<BGI_Injured.ActiveAbilitiesLength; i++) {
        BGI_Injured.GetAbility(i).DamageFromOtherPawn (P_Injured, BGI_Injured.GetAbilityLevel(i), OriginalDamage, Damage, P_InstigatedBy, HitLocation, Momentum, DamageType);
      }
    }
  }

  // Handle weapon magic of the InstigatedBy player (e.g. enhanced damage)
  if (P_InstigatedBy != None && P_InstigatedBy.Weapon != None && UTWeapon (P_InstigatedBy.Weapon) != None) {
    BWEAP_InstigatedBy = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon (P_InstigatedBy.Weapon));
    if (BWEAP_InstigatedBy.ActiveBWM != None) {
      BWEAP_InstigatedBy.ActiveBWM.DamageToOtherPawn (P_InstigatedBy, BWEAP_InstigatedBy.ActiveBWMLevel, OriginalDamage, Damage, P_Injured, HitLocation, Momentum, DamageType);
    }
  }

  // Handle weapon magic of the Injured player (e.g. protection)
  if (P_Injured != None && P_Injured.Weapon != None && UTWeapon (P_Injured.Weapon) != None) {
    BWEAP_Injured = class'BattleStaticFunctions'.static.ReadWEAP (UTWeapon (P_Injured.Weapon));
    if (BWEAP_Injured.ActiveBWM != None) {
      BWEAP_Injured.ActiveBWM.DamageFromOtherPawn (P_Injured, BWEAP_Injured.ActiveBWMLevel, OriginalDamage, Damage, P_InstigatedBy, HitLocation, Momentum, DamageType);
    }
  }

  // Handle artifact of the InstigatedBy player (e.g. double damage)
  if (P_InstigatedBy != None && P_InstigatedBy.Weapon != None && UTWeapon (P_InstigatedBy.Weapon) != None) {
    BPC = BattlePlayerController (P_InstigatedBy.Owner);
    if (BPC != None && BGI_InstigatedBy != None && BPC.bDrainingArtifactActive) {
      BAF = BGI_InstigatedBy.GetArtifact (BPC.SelectedArtifact);
      if (BattleArtifactDraining(BAF) != None) {
        BattleArtifactDraining(BAF).DamageToOtherPawn (P_InstigatedBy, OriginalDamage, Damage, P_Injured, HitLocation, Momentum, DamageType);
      }
    }
  }

  if (Injured != None && Controller(Injured.Owner) != None && Controller(Injured.Owner).PlayerReplicationInfo != None) {
    if (Controller(Injured.Owner).PlayerReplicationInfo.bHasFlag) { // Flag or ORB
      if (Damage < InputDamage) Damage = InputDamage; // Undo everything that protects the player
      if (InStr(WorldInfo.GetGameClass().Name, "Ons") != -1) {
        Damage = Damage * 2; // Double the damage if you are carrying the orb
      }
    }
  }

  Inv = BattleWeaponMagic_Quantum_InvItem (Injured.FindInventoryType (class'BattleWeaponMagic_Quantum_InvItem'));
  if (Inv != None) {
    Damage /= 5;
  }  

  if (NextGameRules != None) NextGameRules.NetDamage (OriginalDamage, Damage, Injured, InstigatedBy, HitLocation, Momentum, DamageType);
}

defaultproperties
{
}