/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleArtifactDraining_Flight extends BattleArtifactDraining config (BattleRPG);

function RapidServerTimer (UTPawn P)
{
  local PlayerController PC;

  if (P == None) return;
  PC = PlayerController (P.Owner);
  if (PC != None) {
	PC.bCheatFlying = true;
	PC.GotoState('PlayerFlying');
  }
}

function StartDrainingArtifact (UTPawn P)
{
  local PlayerController PC;

  PC = PlayerController (P.Owner);
  if (PC==None && P.Owner != None && P.DrivenVehicle != None) {
    PC = PlayerController (P.DrivenVehicle.Controller);
  }
  if (PC != None) {
    class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You feel much lighter");
	PC.bCheatFlying = true;
	PC.GotoState('PlayerFlying');
  }
}

function StopDrainingArtifact (UTPawn P, bool bSilent)
{
  local PlayerController PC;

  PC = PlayerController (P.Owner);
  if (PC==None && P.Owner != None && P.DrivenVehicle != None) {
    PC = PlayerController (P.DrivenVehicle.Controller);
	if (!bSilent) class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You feel much heavier");
	PC.bCheatFlying = false;
  } else {
	if (!bSilent) class'BattleStaticFunctions'.static.Message2Pawn (P, "artifactaction", "You feel much heavier");
	PC.bCheatFlying = false;
    PC.Restart (False);
  }
}

defaultproperties
{
  ArtifactName = "Flight";
  ManaUsagePerSecond = 2;
}