/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_ManaBonus extends BattleAbility config (BattleRPG);

var int PrevScore;

function ServerTimer (UTPawn P, int Level)
{
  local PlayerController PC;
  local BPRIDATA BD;
  local int Score;

  if (P != None && P.Owner != None) {
    PC = PlayerController (P.Owner);
    if (PC != None && PC.PlayerReplicationInfo != None) {
      Score = int(PC.PlayerReplicationInfo.Score);
      if (PrevScore == 0) PrevScore = Score;
      if (Score > PrevScore) {
        if (BD.Mana <= 100 + 25 * Level) { // Allow all kinds of Mana bonuses
          BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
          if (InStr(PC.PlayerReplicationInfo.WorldInfo.GetGameClass().name, "Ons")!=-1) {  
            BD.Mana += Level; // Make Mana harder to collect for Warfare
          } else {
            BD.Mana += 1 + Level + (Score-BD.PrevScore); // Mostly less mana for achievements, more for killing
          }
          if (BD.Mana > 100 + 25 * Level) BD.Mana = 100 + 25 * Level;
          PrevScore = Score;
          class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
        }
      }
    }
  }
}

defaultproperties
{
  AbilityName = "Mana Bonus";
  AbilityDescription = "Each level makes you collect Mana faster. You can get up to 25 extra Mana per level, but only by scoring points.";
  AbilityMaxLevel = 3;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}