/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_HealthRegen extends BattleAbility config (BattleRPG);

var int LastHealth;
var int CountDown;

function ServerTimer (UTPawn P, int Level)
{
  local int AbilityMaxRegenHealth;
  if (P.Health < LastHealth) { // Player got damaged.
    CountDown = 5;
  }
  if (CountDown > 0) {
    CountDown--;
  } else {
    AbilityMaxRegenHealth = P.HealthMax;
    // Do this in such a way the 300 health bonus (Mana) doesn't get lost.
    if (P.Health < AbilityMaxRegenHealth) {
      P.Health += Level;
      if (P.Health > AbilityMaxRegenHealth) P.Health = AbilityMaxRegenHealth;
    }
  }
  LastHealth = P.Health;
}

defaultproperties
{
  AbilityName = "Health Regeneration";
  AbilityDescription = "Regenerates 1 health per level per second. Only works if you didn't get harmed in the last 5 seconds.";
  AbilityMaxLevel = 5;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}