/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleAbility_AntiVehicleBonus extends BattleAbility config (BattleRPG);

function LLDamageToOtherPawn (Pawn P, int Level, int OriginalDamage, out int Damage, Pawn InjuredPawn, vector HitLocation, out vector Momentum, class<DamageType> DamageType)
{
  if (UTVehicle (InjuredPawn) == None) return;

  Damage = Damage * (1.0 + Level * 0.2);
}

defaultproperties
{
  AbilityName = "Anti Vehicle Bonus";
  AbilityDescription = "Per level your weapons and vehicles do 20% more damage against vehicles.";
  AbilityMaxLevel = 5;
  AbilityLevel1Cost = 10;
  AbilityCostIncreasePerLevel = 10;
}