/* 
    BattleRPG Copyright (C) 2007 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleRPG extends UTMutator config(BattleRPG) dependson(BattleStaticFunctions, BattlePersistentPlayerDatabase);

var BattlePersistentPlayerDatabase BPD;

function InitMutator(string Options, out string ErrorMessage)
{
  BPD = New class'BattleRPG.BattlePersistentPlayerDatabase';

  SetTimer (15.0, True, 'CommitDatabase'); // Save the database to disk once every 15 seconds (useful if the server decides to crash)

  if (InStr(WorldInfo.GetGameClass().name, "Ons")!=-1) {
    WorldInfo.Game.PlayerReplicationInfoClass = Class'BattlePRIONS';
  } else if (InStr(WorldInfo.GetGameClass().name, "CTF")!=-1) {
    WorldInfo.Game.PlayerReplicationInfoClass = Class'BattlePRI';
  } else if (InStr(WorldInfo.GetGameClass().name, "Duel")!=-1) {
    WorldInfo.Game.PlayerReplicationInfoClass = Class'BattlePRIDuel';
  } else if (InStr(WorldInfo.GetGameClass().name, "Team")!=-1) {
    WorldInfo.Game.PlayerReplicationInfoClass = Class'BattlePRI';
  } else if (InStr(WorldInfo.GetGameClass().name, "Death")!=-1) {
    WorldInfo.Game.PlayerReplicationInfoClass = Class'BattlePRI';
  }
}

function CommitDatabase ()
{
  if (BPD != None) BPD.Commit();
}

simulated function ModifyPlayer(Pawn Other)
{
  local UTPawn P;
  local PlayerController PC;
  local UTPlayerController UTPC;
  local BPRIDATA BD;

  if (Other!=None) {
    PC = PlayerController (Other.Owner);
    UTPC = UTPlayerController (PC);
    if (PC != None && UTPC != None) {
      // Move data for this player from persistant database to memory (function autodetects if this is needed)
      BPD.LoadPlayerData (PC.PlayerReplicationInfo);

      // Determine the players level
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);

      P = UTPawn(Other);
      if (P != None) {
        P.FireRateMultiplier = P.default.FireRateMultiplier / (1.0 + BD.Level/200.0); // 0.5% weapon speed per level
        P.GroundSpeed = P.default.GroundSpeed * (1.0 + BD.Level/200.0); // 0.5% quickfoot per level
        P.WaterSpeed = P.default.WaterSpeed * (1.0 + BD.Level/200.0); // 0.5% faster swimming per level
        P.JumpZ = P.default.JumpZ * (1.0 + BD.Level/200.0); // 0.5% extra jump height per level
        P.Health = P.default.Health + BD.Level; // 1 bonus starting health per level
      }
     
    }
  }

  Super.ModifyPlayer(Other);

  if (Other!=None) Other.CreateInventory(class'BattleRPG.BattleGenInvItem');
}

defaultproperties
{
  Name="BattleRPG"
}