/* 
    BattleRPG Copyright (C) 2007 Nico de Vries.

    This file is part of BattleRPG.

    BattleRPG is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleGenInvItem extends Inventory dependson(BattleStaticFunctions);

simulated function PostBeginPlay()
{
  super.PostBeginPlay();
  if (Role == ROLE_Authority) {
    SetTimer (1.0, True, 'ServerTimer');
  }
  if (WorldInfo.NetMode == NM_ListenServer || WorldInfo.NetMode == NM_Client) {
    SetTimer (1.0, True, 'ClientTimer'); 
  }
}

function ServerTimer ()
{
  local PlayerController PC;
  local BPRIDATA BD;
  local array< class<Inventory> > BonusInventory;
  local int i;

  if (Pawn(Owner) != None) {
    PC = PlayerController (Owner.Owner);
    if (PC != None && PC.PlayerReplicationInfo != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.Level > 19) {
        if (Pawn(Owner).Health < 200) {
          Pawn(Owner).Health += int (BD.Level / 20.0); // Add 1 health per second per 20 levels
        }
      }
      if (BD.Level > 49) { // Level 50 and up get 2 ammo per second for their current weapon
        if (UTWeapon(Pawn(Owner).Weapon) != None && !UTWeapon(Pawn(Owner).Weapon).bSuperWeapon) {
          UTWeapon(Pawn(Owner).Weapon).AddAmmo (2); // Automatically reduced by UT3
        }
      }
      if (BD.Mana >= 100) { // Bonus time
        Pawn(Owner).Health = 999;
        BD.Mana = 0;
        class'BattleStaticFunctions'.static.WriteBPRI (PC.PlayerReplicationInfo, BD);
        BonusInventory.Length = 9;
        BonusInventory[0] = Class'UTGame.UTWeap_Enforcer';
        BonusInventory[1] = Class'UTGame.UTWeap_ImpactHammer';
        BonusInventory[2] = Class'UTGame.UTWeap_RocketLauncher';
        BonusInventory[3] = Class'UTGameContent.UTWeap_Avril_Content';
        BonusInventory[4] = Class'UTGameContent.UTWeap_BioRifle_Content';
        BonusInventory[5] = Class'UTGame.UTWeap_FlakCannon';
        BonusInventory[6] = Class'UTGame.UTWeap_LinkGun';
        BonusInventory[7] = Class'UTGame.UTWeap_ShockRifle';
        BonusInventory[8] = Class'UTGame.UTWeap_SniperRifle';
        BonusInventory[9] = Class'UTGame.UTWeap_Stinger';
        for (i=0; i<BonusInventory.Length; i++) {
          if (Pawn(Owner).FindInventoryType(BonusInventory[i]) == None) {
            Pawn(Owner).CreateInventory(BonusInventory[i], (i > 0));
		  }
	    }
      }
    }
  }   
}

simulated function ClientTimer ()
{
  local PlayerController PC;

  if (Pawn(Owner) != None) {
    PC = PlayerController (Owner.Owner);
    if (PC != None) {
      if (UTPlayerController(PC)!=None) {
        if (InStr(WorldInfo.GetGameClass().name, "Ons")!=-1) {
          PC.ClientSetHUD (Class'BattleHUDOnslaught', Worldinfo.Game.Scoreboardtype);         
        } else if (InStr(WorldInfo.GetGameClass().name, "CTF")!=-1) {
          PC.ClientSetHUD (Class'BattleHUDCTF', Worldinfo.Game.Scoreboardtype);
        } else if (InStr(WorldInfo.GetGameClass().name, "Duel")!=-1) {
          PC.ClientSetHUD (Class'BattleHUDDuel', Worldinfo.Game.Scoreboardtype);
        } else if (InStr(WorldInfo.GetGameClass().name, "Team")!=-1) {
          PC.ClientSetHUD (Class'BattleHUDTeam', Worldinfo.Game.Scoreboardtype);
        } else if (InStr(WorldInfo.GetGameClass().name, "Death")!=-1) {
          PC.ClientSetHUD (Class'BattleHUD', Worldinfo.Game.Scoreboardtype);
        } // Use the default HUD for unknown gametypes.
        UTPlayerController(PC).LoadSettingsFromProfile (True); // Without this sometimes the WeaponBar gets lost.
        ClearTimer ('ClientTimer');
      }
    }
  }   
}

simulated event Tick(float DeltaTime)
{
  local PlayerController PC;
  local BPRIDATA BD;

  if (UTPawn(Owner) != None && UTPawn(Owner).bDodging) {
    PC = PlayerController (Owner.Owner);
    if (PC != None && PC.PlayerReplicationInfo != None) {
      BD = class'BattleStaticFunctions'.static.ReadBPRI (PC.PlayerReplicationInfo);
      if (BD.Level > 24) { // Allow dodge jumping for players of level 25 and higher
        UTPawn(Owner).bReadyToDoubleJump = True;
        UTPawn(Owner).bDodging = False;    
      }
    }
  }
}

defaultproperties
{
  Name="BattleClient"
}