/* 
    BattleTRANS Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTRANS.

    BattleTRANS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleTranslocator extends UTWeap_Translocator_Content HideDropDown;

var int CountDownForWarp;
var bool bTransCamView;
var Projectile TD;
var bool bManualCamReady;
var Texture2D HudMaterial;
var const color TextColor, Black;

replication
{
  if (Role == ROLE_Authority)
    bTransCamView;
}

// Unlimited ammo
simulated function bool HasAmmo(byte FireModeNum, optional int Amount)
{
  AmmoCount = 7;
  return super.HasAmmo(FireModeNum, Amount);
}

simulated function DrawWeaponCrosshair (Hud HUD)
{
  if (bTransCamView) {
    DrawZoomedOverlay(HUD);
  } else {
    Super.DrawWeaponCrosshair (HUD);
  }
}

simulated function String GetHumanReadableName()
{
  local BattlePRI BPRI;
  if (Instigator != None && Instigator.Controller != None && Instigator.Controller.PlayerReplicationInfo != None) {
    BPRI = class'BattleTRANS'.static.GetBattlePRI (Instigator.Controller.PlayerReplicationInfo);
    if (BPRI != None) {
      if (BPRI.TranslocatorMode == "manualcam") return "Battle Translocator with Manual CAM ([FIRE] twice)";
      if (BPRI.TranslocatorMode == "autocam") return "Battle Translocator with Automatic CAM";
    }
  }
  return "Battle Translocator";
}

simulated function CustomFire()
{
  bManualCamReady = false;
  bTransCamView = false;
  Super.CustomFire();
}

simulated function Projectile ProjectileFire()
{
  local BattlePRI BPRI;
  local bool bAutoCam;

  if (bManualCamReady) {
    CountDownForWarp = 2;
    bManualCamReady = false;
    return None;
  }
  TD = Super.ProjectileFire();
  bAutoCam = true;
  if (TD != None) {
    if (Instigator != None && Instigator.Controller != None && Instigator.Controller.PlayerReplicationInfo != None) {
      BPRI = class'BattleTRANS'.static.GetBattlePRI (Instigator.Controller.PlayerReplicationInfo);
      if (BPRI != None) {
        if (BPRI.TranslocatorMode == "standard") bAutoCam = false;
        if (BPRI.TranslocatorMode == "manualcam") {
          bAutoCam = false;
          bManualCamReady = true;
        } 
      } else {
        bAutoCam = false;
        bManualCamReady = true;
      }
    }
    if (bAutoCam) CountDownForWarp = 2; // Tested this to be the lowest value without flicker quirks in networked mode
  } else {
    NormalView();
  }
  return TD;
}

simulated function Tick(float DeltaTime)
{
  if (CountDownForWarp > 0 && TD != None) {
    if (--CountDOwnForWarp == 0) {
      TransCamView ();
    }
  }
  if (WorldInfo.NetMode != NM_Client) { // Only do this on the server
    if (bTransCamView && UTPawn(Instigator.Controller.Pawn) != None && UTPawn(Instigator.Controller.Pawn).Weapon.Class != class'BattleTranslocator') {
      NormalView ();
    }
  }
}

simulated function TransCamView ()
{
  bTransCamView = true;
  if (Instigator != None && Instigator.Controller != None) {
    PlayerController(Instigator.Controller).SetViewTarget (TD);
    PlayerController(Instigator.Controller).ClientSetViewTarget (TD);
  }
}

simulated function NormalView () // aka walking
{
  if (bTransCamView) {
    bTransCamView = false;
    if (Instigator != None && Instigator.Controller != None) {
      PlayerController(Instigator.Controller).SetViewTarget (Instigator.Controller.Pawn);
      PlayerController(Instigator.Controller).ClientSetViewTarget (Instigator.Controller.Pawn);
    }
    bManualCamReady = false;
  }
}

simulated function DrawZoomedOverlay (HUD H)
// This function derived from UTWeap_SniperRifle.uc Copyright 1998-2007 Epic Games, Inc. All Rights Reserved. 
{
	local float ScaleX, ScaleY, StartX;
	local float OldOrgX, OldOrgY, OldClipX, OldClipY;

	OldOrgX = H.Canvas.OrgX;
	OldOrgY = H.Canvas.OrgY;
	OldClipX = H.Canvas.ClipX;
	OldClipY = H.Canvas.ClipY;
	H.Canvas.OrgX = 0.0;
	H.Canvas.OrgY = 0.0;
	H.Canvas.ClipX = H.Canvas.SizeX;
	H.Canvas.ClipY = H.Canvas.SizeY;

	ScaleY = H.Canvas.ClipY/768.0;
	ScaleX = ScaleY;
	StartX = 0.5*H.Canvas.ClipX - 512.0*ScaleX;

    H.Canvas.SetDrawColor(64,255,64);

	H.Canvas.SetPos(StartX, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 0, 510, 383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, 0.0);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 0, -510, 383);

	H.Canvas.SetPos(StartX, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 2, 383, 510, -383);

	H.Canvas.SetPos(H.Canvas.ClipX*0.5, H.Canvas.ClipY*0.5);
	H.Canvas.DrawTile(HudMaterial, 512.0 * ScaleX, 384.0 * ScaleY, 510, 383, -510, -383);

	if ( StartX > 0 )
	{
		H.Canvas.SetPos(0.0, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 0, 3, 383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, 0.0);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 0, -3, 383);

		H.Canvas.SetPos(0.0, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 1, 383, 3, -383);

		H.Canvas.SetPos(H.Canvas.ClipX - StartX, H.Canvas.ClipY*0.5);
		H.Canvas.DrawTile(HudMaterial, StartX, 384.0 * ScaleY, 4, 383, -3, -383);
	}

    H.Canvas.Font = class'Engine'.static.GetMediumFont();
    H.Canvas.DrawColor = default.Black;
    H.Canvas.SetPos (0.4 * H.Canvas.ClipX+1, 0.85*H.Canvas.ClipY+1);
    H.Canvas.DrawTextClipped ("Translocator CAMERA", false);
    H.Canvas.DrawColor = default.TextColor;
    H.Canvas.SetPos (0.4 * H.Canvas.ClipX, 0.85*H.Canvas.ClipY);
    H.Canvas.DrawTextClipped ("Translocator CAMERA", false);

	H.Canvas.OrgX = OldOrgX;
	H.Canvas.OrgY = OldOrgY;
	H.Canvas.ClipX = OldClipX;
	H.Canvas.ClipY = OldClipY;
}

defaultproperties
{
  TextColor=(B=0,G=255,R=255,A=255)
  Black=(B=0,G=0,R=0,A=255)
  HudMaterial=Texture2D'WP_SniperRifle.Textures.T_SniperCrosshair'
  WeaponProjectiles(0)=Class'BattleTRANS.BattleTransDiscRed'
  WeaponProjectiles(1)=Class'BattleTRANS.BattleTransDiscBlue'
  Name="BattleTranslocator"
}