/* 
    BattleTRANS Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTRANS.

    BattleTRANS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleTransDiscRed extends UTProj_TransDisc_ContentRed;

simulated function ShutDown()
{
  if (Controller(Owner) != None) {
    if (Controller(Owner).Pawn != None) {
      if (BattleTranslocator(Controller(Owner).Pawn.Weapon) != None) {
        BattleTranslocator(Controller(Owner).Pawn.Weapon).NormalView();
      }
    }
  }
  Super.ShutDown();
}

simulated function UpdateSettings ()
{
  local BattlePRI BPRI;
  if (PlayerController (InstigatorController)  != None) {
    if (PlayerController(InstigatorController).PlayerReplicationInfo != None) {
      BPRI = class'BattleTRANS'.static.GetBattlePRI (PlayerController(InstigatorController).PlayerReplicationInfo);
      if (BPRI != None) {
        TossZ = 155 * BPRI.TranslocatorSpeed / 100;
        Speed = 1330 * BPRI.TranslocatorSpeed / 100;
        MaxSpeed = 2000 * BPRI.TranslocatorSpeed / 100;
        MomentumTransfer = 50000 * BPRI.TranslocatorSpeed / 100;
        TerminalVelocity = 3500 * BPRI.TranslocatorSpeed / 100;
        if (BPRI.LongTrail == "off") {
          ProjFlightTemplate=ParticleSystem'WP_Translocator.Particles.P_WP_Translocator_Trail_Red';
        } else {
          ProjFlightTemplate=ParticleSystem'BattleTRANSContent.P_WP_Translocator_Trail_Red';
        }
      }
    }
  }
}

simulated function SpawnFlightEffects()
{
  UpdateSettings ();
  Super.SpawnFlightEffects ();
}

function Init(vector Direction)
{
  UpdateSettings ();
  Super.Init (Direction);
}

simulated function Tick(float DeltaTime)
{
  UpdateSettings ();
  Super.Tick (DeltaTime);
}

defaultproperties
{
  bBounce=True
  ProjFlightTemplate=ParticleSystem'BattleTRANSContent.P_WP_Translocator_Trail_Red'
  Name="BattleTransDiscRed"
}